/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ResourceCollection;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.ResourceTracker;
import edu.umd.cs.findbugs.ba.ResourceValueAnalysis;
import edu.umd.cs.findbugs.ba.ResourceValueFrame;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.log.Profiler;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceTrackingDetector<Resource, ResourceTrackerType extends ResourceTracker<Resource>>
implements Detector {
    private static final boolean DEBUG = SystemProperties.getBoolean("rtd.debug");
    private static final String DEBUG_METHOD_NAME = SystemProperties.getProperty("rtd.method");
    protected BugAccumulator bugAccumulator;
    protected BugReporter bugReporter;

    public ResourceTrackingDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    public abstract boolean prescreen(ClassContext var1, Method var2, boolean var3);

    public abstract ResourceTrackerType getResourceTracker(ClassContext var1, Method var2) throws DataflowAnalysisException, CFGBuilderException;

    public abstract void inspectResult(ClassContext var1, MethodGen var2, CFG var3, Dataflow<ResourceValueFrame, ResourceValueAnalysis<Resource>> var4, Resource var5);

    @Override
    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass jclass = classContext.getJavaClass();
        for (Method method : methodList = jclass.getMethods()) {
            MethodGen methodGen;
            if (method.isAbstract() || method.isNative() || (methodGen = classContext.getMethodGen(method)) == null || DEBUG_METHOD_NAME != null && !DEBUG_METHOD_NAME.equals(method.getName())) continue;
            if (DEBUG) {
                System.out.println("----------------------------------------------------------------------");
                System.out.println("Analyzing " + SignatureConverter.convertMethodSignature(methodGen));
                System.out.println("----------------------------------------------------------------------");
            }
            try {
                ResourceCollection<Resource> resourceCollection;
                ResourceTrackerType resourceTracker = this.getResourceTracker(classContext, method);
                boolean mightClose = this.mightCloseResource(classContext, method, resourceTracker);
                if (!this.prescreen(classContext, method, mightClose) || (resourceCollection = this.buildResourceCollection(classContext, method, resourceTracker)).isEmpty()) continue;
                this.analyzeMethod(classContext, method, resourceTracker, resourceCollection);
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("Error analyzing method " + method.toString(), e);
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError("Error analyzing method " + method.toString(), e);
            }
            this.bugAccumulator.reportAccumulatedBugs();
        }
    }

    private ResourceCollection<Resource> buildResourceCollection(ClassContext classContext, Method method, ResourceTrackerType resourceTracker) throws CFGBuilderException, DataflowAnalysisException {
        ResourceCollection resourceCollection = new ResourceCollection();
        CFG cfg = classContext.getCFG(method);
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        Iterator<Location> i = cfg.locationIterator();
        while (i.hasNext()) {
            Location location = i.next();
            Object resource = resourceTracker.isResourceCreation(location.getBasicBlock(), location.getHandle(), cpg);
            if (resource == null) continue;
            resourceCollection.addCreatedResource(location, resource);
        }
        return resourceCollection;
    }

    private boolean mightCloseResource(ClassContext classContext, Method method, ResourceTrackerType resourceTracker) throws CFGBuilderException, DataflowAnalysisException {
        CFG cfg = classContext.getCFG(method);
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        Iterator<Location> i = cfg.locationIterator();
        while (i.hasNext()) {
            Location location = i.next();
            if (!resourceTracker.mightCloseResource(location.getBasicBlock(), location.getHandle(), cpg)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyzeMethod(ClassContext classContext, Method method, ResourceTrackerType resourceTracker, ResourceCollection<Resource> resourceCollection) throws CFGBuilderException, DataflowAnalysisException {
        MethodGen methodGen = classContext.getMethodGen(method);
        if (methodGen == null) {
            return;
        }
        try {
            CFG cfg = classContext.getCFG(method);
            DepthFirstSearch dfs = classContext.getDepthFirstSearch(method);
            if (DEBUG) {
                System.out.println(SignatureConverter.convertMethodSignature(methodGen));
            }
            Iterator<Resource> i = resourceCollection.resourceIterator();
            while (i.hasNext()) {
                Object var14_14;
                Resource resource = i.next();
                ResourceValueAnalysis<Resource> analysis = new ResourceValueAnalysis<Resource>(methodGen, cfg, dfs, resourceTracker, resource);
                Dataflow<ResourceValueFrame, ResourceValueAnalysis<Resource>> dataflow = new Dataflow<ResourceValueFrame, ResourceValueAnalysis<Resource>>(cfg, analysis);
                Profiler profiler = Global.getAnalysisCache().getProfiler();
                profiler.start(resourceTracker.getClass());
                try {
                    dataflow.execute();
                    var14_14 = null;
                    profiler.end(resourceTracker.getClass());
                }
                catch (Throwable throwable) {
                    var14_14 = null;
                    profiler.end(resourceTracker.getClass());
                    throw throwable;
                }
                this.inspectResult(classContext, methodGen, cfg, dataflow, resource);
            }
        }
        catch (RuntimeException e) {
            AnalysisContext.logError("Exception while analyzing " + methodGen.getClassName() + "." + methodGen.getName() + ":" + methodGen.getSignature(), e);
        }
    }

    @Override
    public void report() {
    }
}

