/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.resources.FileResource;
import org.codehaus.mojo.animal_sniffer.ClassFileVisitor;
import org.codehaus.mojo.animal_sniffer.ClassListBuilder;
import org.codehaus.mojo.animal_sniffer.SignatureChecker;
import org.codehaus.mojo.animal_sniffer.ant.AntLogger;
import org.codehaus.mojo.animal_sniffer.ant.Ignore;

public class CheckSignatureTask
extends Task {
    private File signature;
    private Path classpath;
    private Vector paths = new Vector();
    private Vector ignores = new Vector();

    public void addPath(Path path) {
        this.paths.add(path);
    }

    public Ignore createIgnore() {
        Ignore result = new Ignore();
        this.ignores.add(result);
        return result;
    }

    public void setSignature(File signature) {
        this.signature = signature;
    }

    public Path createClasspath() {
        this.log("In createClasspath", 2);
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspath(Path classpath) {
        this.log("In setClasspath", 2);
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public void setClasspathRef(Reference r) {
        this.log("In setClasspathRef", 2);
        this.createClasspath().setRefid(r);
    }

    public void execute() throws BuildException {
        this.validate();
        try {
            this.log("Checking unresolved references to " + this.signature, 2);
            if (!this.signature.isFile()) {
                throw new BuildException("Could not find signature: " + this.signature);
            }
            Set ignoredPackages = this.buildPackageList();
            Iterator i = this.ignores.iterator();
            while (i.hasNext()) {
                Ignore ignore = (Ignore)i.next();
                if (ignore == null || ignore.getClassName() == null) continue;
                ignoredPackages.add(ignore.getClassName().replace('.', '/'));
            }
            SignatureChecker signatureChecker = new SignatureChecker(new FileInputStream(this.signature), ignoredPackages, new AntLogger(this));
            i = this.paths.iterator();
            while (i.hasNext()) {
                Path path = (Path)i.next();
                String[] files = path.list();
                for (int j = 0; j < files.length; ++j) {
                    signatureChecker.process(new File(files[j]));
                }
            }
            if (signatureChecker.isSignatureBroken()) {
                throw new BuildException("Signature errors found. Verify them and put @IgnoreJRERequirement on them.", this.getLocation());
            }
        }
        catch (IOException e) {
            throw new BuildException("Failed to check signatures", (Throwable)e);
        }
    }

    protected void validate() {
        if (this.signature == null) {
            throw new BuildException("signature not set");
        }
        if (this.paths.size() < 1) {
            throw new BuildException("path not set");
        }
    }

    private Set buildPackageList() throws IOException {
        ClassListBuilder plb = new ClassListBuilder(new AntLogger(this));
        this.apply(plb);
        return plb.getPackages();
    }

    private void apply(ClassFileVisitor v) throws IOException {
        Iterator i = this.paths.iterator();
        while (i.hasNext()) {
            Path path = (Path)i.next();
            String[] files = path.list();
            for (int j = 0; j < files.length; ++j) {
                this.log("Ignoring the signatures from file to be checked: " + files[j], 2);
                v.process(new File(files[j]));
            }
        }
        if (this.classpath != null) {
            i = this.classpath.iterator();
            while (i.hasNext()) {
                Object next = i.next();
                if (!(next instanceof FileResource)) continue;
                File file = ((FileResource)next).getFile();
                this.log("Ignoring the signatures from classpath: " + file, 2);
                v.process(file);
            }
        }
    }
}

