/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.codehaus.mojo.animal_sniffer.SignatureBuilder;
import org.codehaus.mojo.animal_sniffer.ant.AntLogger;
import org.codehaus.mojo.animal_sniffer.ant.Ignore;
import org.codehaus.mojo.animal_sniffer.ant.Signature;

public class BuildSignaturesTask
extends Task {
    private File destfile;
    private Vector paths = new Vector();
    private Vector signatures = new Vector();
    private Vector includeClasses = new Vector();
    private Vector excludeClasses = new Vector();

    public void setDestfile(File dest) {
        this.destfile = dest;
    }

    public void addPath(Path path) {
        this.paths.add(path);
    }

    public Signature createSignature() {
        Signature signature = new Signature();
        this.signatures.add(signature);
        return signature;
    }

    public Ignore createIncludeClasses() {
        Ignore result = new Ignore();
        this.includeClasses.add(result);
        return result;
    }

    public Ignore createExcludeClasses() {
        Ignore result = new Ignore();
        this.excludeClasses.add(result);
        return result;
    }

    protected void validate() {
        Ignore tmp;
        if (this.destfile == null) {
            throw new BuildException("destfile not set");
        }
        if (this.paths.size() < 1) {
            throw new BuildException("path not set");
        }
        Iterator i = this.signatures.iterator();
        while (i.hasNext()) {
            Signature signature = (Signature)i.next();
            if (signature.getSrc() == null) {
                throw new BuildException("signature src not set");
            }
            if (signature.getSrc().isFile()) continue;
            throw new BuildException("signature " + signature.getSrc() + " does not exist");
        }
        i = this.includeClasses.iterator();
        while (i.hasNext()) {
            tmp = (Ignore)i.next();
            if (tmp.getClassName() != null) continue;
            throw new BuildException("includeClasses className not set");
        }
        i = this.excludeClasses.iterator();
        while (i.hasNext()) {
            tmp = (Ignore)i.next();
            if (tmp.getClassName() != null) continue;
            throw new BuildException("excludeClasses className not set");
        }
    }

    public void execute() throws BuildException {
        this.validate();
        try {
            Ignore tmp;
            Vector<FileInputStream> inStreams = new Vector<FileInputStream>();
            Iterator i = this.signatures.iterator();
            while (i.hasNext()) {
                Signature signature = (Signature)i.next();
                this.log("Importing signatures from " + signature.getSrc());
                inStreams.add(new FileInputStream(signature.getSrc()));
            }
            SignatureBuilder builder = new SignatureBuilder(inStreams.toArray(new InputStream[inStreams.size()]), new FileOutputStream(this.destfile), new AntLogger(this));
            i = this.includeClasses.iterator();
            while (i.hasNext()) {
                tmp = (Ignore)i.next();
                builder.addInclude(tmp.getClassName());
            }
            i = this.excludeClasses.iterator();
            while (i.hasNext()) {
                tmp = (Ignore)i.next();
                builder.addExclude(tmp.getClassName());
            }
            i = this.paths.iterator();
            while (i.hasNext()) {
                Path path = (Path)i.next();
                String[] files = path.list();
                for (int j = 0; j < files.length; ++j) {
                    this.log("Capturing signatures from " + files[j], 2);
                    this.process(builder, new File(files[j]));
                }
            }
            builder.close();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void process(SignatureBuilder builder, File f) throws IOException {
        if (f.exists()) {
            builder.process(f);
        }
    }
}

