/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.duplicateway;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Segment;

public class JVector
extends Line2D.Double {
    public static final double EARTH_CIRCUMFERENCE = 4.0041455E7;
    protected static final double PI_ON_2 = 1.5707963267948966;
    protected Point2D.Double slopeIntercept = null;
    protected Point2D.Double rtheta = null;

    public JVector(double x1, double y1, double x2, double y2) {
        super(x1, y1, x2, y2);
    }

    public JVector(JVector v) {
        this.x1 = v.x1;
        this.x2 = v.x2;
        this.y1 = v.y1;
        this.y2 = v.y2;
    }

    public JVector(Segment s) {
        super(s.from.eastNorth.east(), s.from.eastNorth.north(), s.to.eastNorth.east(), s.to.eastNorth.north());
    }

    protected void calculateSlopeIntercept() {
        double slope = (this.y2 - this.y1) / (this.x2 - this.x1);
        double intersect = this.y1 - slope * this.x1;
        this.slopeIntercept = new Point2D.Double(slope, intersect);
    }

    public double getSlope() {
        if (this.slopeIntercept == null) {
            this.calculateSlopeIntercept();
        }
        return this.slopeIntercept.x;
    }

    public double getIntercept() {
        if (this.slopeIntercept == null) {
            this.calculateSlopeIntercept();
        }
        return this.slopeIntercept.y;
    }

    protected void calculatePolar() {
        double x = this.x2 - this.x1;
        double y = this.y2 - this.y1;
        double r = Math.sqrt(x * x + y * y);
        double theta = Math.atan2(y, x);
        this.rtheta = new Point2D.Double(r, theta);
    }

    public double getLength() {
        if (this.rtheta == null) {
            this.calculatePolar();
        }
        return this.rtheta.x;
    }

    public double getTheta() {
        if (this.rtheta == null) {
            this.calculatePolar();
        }
        return this.rtheta.y;
    }

    protected void polarToCartesian() {
        double newx2 = this.x1 + this.getLength() * Math.cos(this.getTheta());
        double newy2 = this.y1 + this.getLength() * Math.sin(this.getTheta());
        this.x2 = newx2;
        this.y2 = newy2;
        this.slopeIntercept = null;
    }

    protected void setPolar(double r, double theta) {
        this.rtheta = new Point2D.Double(r, theta);
        this.polarToCartesian();
    }

    protected void setLength(double l) {
        this.rtheta.x = l;
        this.polarToCartesian();
    }

    public void reverse() {
        double t = this.x2;
        this.x2 = this.x1;
        this.x1 = t;
        t = this.y2;
        this.y2 = this.y1;
        this.y1 = t;
        this.slopeIntercept = null;
        this.rtheta = null;
    }

    protected void rotate(double rot) {
        if (this.rtheta == null) {
            this.calculatePolar();
        }
        this.rtheta.y = this.normalize(this.rtheta.y + rot);
        this.polarToCartesian();
    }

    protected void rotate90CW() {
        this.rotate(-1.5707963267948966);
    }

    protected void rotate90CCW() {
        this.rotate(1.5707963267948966);
    }

    protected double normalize(double theta) {
        while (theta < -Math.PI || theta > Math.PI) {
            if (theta > Math.PI) {
                return theta - Math.PI * 2;
            }
            if (!(theta < -Math.PI)) continue;
            return theta + Math.PI * 2;
        }
        return theta;
    }

    protected void rotate90(double offset) {
        this.rotate(1.5707963267948966 * (double)(offset < 0.0 ? 1 : -1));
        this.setLength(Math.abs(offset));
    }

    protected double calculateOffset(EastNorth target) {
        EastNorth intersectPoint = this.perpIntersect(target);
        JVector intersectRay = new JVector(intersectPoint.east(), intersectPoint.north(), target.east(), target.north());
        double offset = intersectRay.getLength();
        double theta = this.normalize(this.getTheta() - intersectRay.getTheta());
        if (theta < 0.0) {
            offset = -offset;
        }
        return offset;
    }

    public double perpDistance(Node n) {
        return this.perpDistance(n.eastNorth);
    }

    public double perpDistance(EastNorth en) {
        return this.ptLineDist(en.east(), en.north());
    }

    public static double perpDistance(Segment s, EastNorth en) {
        return Line2D.ptSegDist(s.from.eastNorth.east(), s.from.eastNorth.north(), s.to.eastNorth.east(), s.to.eastNorth.north(), en.east(), en.north());
    }

    public JVector bisector(JVector ls, double offset) {
        JVector newSeg = new JVector(ls);
        double newTheta = Math.PI + ls.getTheta() - this.getTheta();
        newSeg.setPolar(Math.abs(offset), newSeg.getTheta() - newTheta / 2.0);
        double angle = this.normalize(this.getTheta() - newSeg.getTheta());
        if (angle < 0.0 && offset > 0.0 || angle > 0.0 && offset < 0.0) {
            newSeg.rotate(Math.PI);
        }
        return newSeg;
    }

    public EastNorth perpIntersect(Node n) {
        return this.perpIntersect(n.eastNorth);
    }

    public EastNorth perpIntersect(EastNorth en) {
        double perpSlope = -1.0 / this.getSlope();
        double perpIntercept = en.north() - en.east() * perpSlope;
        double intersectE = (perpIntercept - this.getIntercept()) / (this.getSlope() - perpSlope);
        double intersectN = intersectE * this.getSlope() + this.getIntercept();
        return new EastNorth(intersectE, intersectN);
    }
}

