/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.duplicateway;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Segment;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.JVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicateWayAction
extends MapMode
implements SelectionChangedListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    protected Cursor oldCursor;
    protected List<Way> selectedWays;
    protected MapMode previousMode;

    public DuplicateWayAction() {
        super(I18n.tr((String)"Duplicate Way"), "duplicateway", I18n.tr((String)"Duplicate selected ways."), 87, null, ImageProvider.getCursor((String)"crosshair", (String)"duplicate"));
        this.setEnabled(false);
        DataSet.listeners.add(this);
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener((MouseListener)this);
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)this);
    }

    public void actionPerformed(ActionEvent e) {
        this.selectedWays = new ArrayList<Way>();
        for (OsmPrimitive osm : Main.ds.getSelected()) {
            if (!(osm instanceof Way)) continue;
            Way way = (Way)osm;
            EastNorth last = null;
            for (Segment seg : way.segments) {
                if (last != null && !seg.from.eastNorth.equals((Object)last)) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Can't duplicate unnordered way."));
                    return;
                }
                last = seg.to.eastNorth;
            }
            this.selectedWays.add(way);
        }
        if (Main.map == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No data loaded."));
            return;
        }
        if (this.selectedWays.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"You must select at least one way."));
            return;
        }
        this.previousMode = Main.map.mapMode;
        super.actionPerformed(e);
    }

    public static Node createNode(double east, double north) {
        return new Node(Main.proj.eastNorth2latlon(new EastNorth(east, north)));
    }

    protected void duplicate(Point clickPoint) {
        EastNorth clickEN = Main.map.mapView.getEastNorth(clickPoint.x, clickPoint.y);
        Segment cs = null;
        for (Way way : this.selectedWays) {
            double minDistance = Double.MAX_VALUE;
            for (Segment ls : way.segments) {
                double perDist;
                if (ls.deleted || ls.incomplete || !((perDist = JVector.perpDistance((Segment)ls, (EastNorth)clickEN)) < minDistance)) continue;
                minDistance = perDist;
                cs = ls;
            }
        }
        if (cs == null) {
            return;
        }
        JVector closestSegment = new JVector(cs);
        double offset = closestSegment.calculateOffset(clickEN);
        LinkedList<AddCommand> commands = new LinkedList<AddCommand>();
        LinkedList<Way> ways = new LinkedList<Way>();
        for (Way way : this.selectedWays) {
            Way newWay = new Way();
            Node lastNode = null;
            JVector lastLine = null;
            for (Segment seg : way.segments) {
                JVector currentLine = new JVector(seg);
                Node newNode = null;
                if (lastNode == null) {
                    JVector perpVector = new JVector(currentLine);
                    perpVector.rotate90(offset);
                    newNode = DuplicateWayAction.createNode(perpVector.getP2().getX(), perpVector.getP2().getY());
                    commands.add(new AddCommand((OsmPrimitive)newNode));
                } else {
                    JVector bisector = lastLine.bisector(currentLine, offset);
                    newNode = DuplicateWayAction.createNode(bisector.getP2().getX(), bisector.getP2().getY());
                    commands.add(new AddCommand((OsmPrimitive)newNode));
                    Segment s = new Segment(newNode, lastNode);
                    commands.add(new AddCommand((OsmPrimitive)s));
                    newWay.segments.add(0, s);
                }
                lastLine = currentLine;
                lastNode = newNode;
            }
            lastLine.reverse();
            lastLine.rotate90(-offset);
            Node newNode = DuplicateWayAction.createNode(lastLine.getP2().getX(), lastLine.getP2().getY());
            commands.add(new AddCommand((OsmPrimitive)newNode));
            Segment s = new Segment(newNode, lastNode);
            commands.add(new AddCommand((OsmPrimitive)s));
            newWay.segments.add(0, s);
            for (String key : way.keySet()) {
                newWay.put(key, way.get(key));
            }
            commands.add(new AddCommand((OsmPrimitive)newWay));
            ways.add(newWay);
        }
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Create duplicate way"), commands));
        Main.ds.setSelected(ways);
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        for (OsmPrimitive osmPrimitive : newSelection) {
            if (!(osmPrimitive instanceof Way)) continue;
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.duplicate(e.getPoint());
        this.exitMode();
        Main.map.selectMapMode(this.previousMode);
    }
}

