/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.xml;

import java.io.InputStream;
import junit.extensions.xml.IXMLProcedure;
import junit.extensions.xml.IXMLTest;
import junit.extensions.xml.IXMLTestSuite;
import junit.extensions.xml.XMLConstants;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.XMLObjectCache;
import junit.extensions.xml.XMLPropertyCache;
import junit.extensions.xml.XMLTagResourceBundle;
import junit.extensions.xml.XMLUtil;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLTestSuite
extends TestSuite
implements IXMLTestSuite,
XMLConstants {
    private Element m_element;
    private IXMLTest m_parent = null;
    private String m_fileName;
    private final XMLObjectCache m_procedures = new XMLObjectCache();
    private XMLPropertyCache m_propertyCache = new XMLPropertyCache();

    public XMLTestSuite() {
    }

    public XMLTestSuite(String fileName) {
        this(fileName, XMLUtil.parse(XMLUtil.readFileFromClasspath(fileName)).getDocumentElement());
    }

    public XMLTestSuite(String name, InputStream stream) {
        this(name, XMLUtil.parse(stream).getDocumentElement());
    }

    public XMLTestSuite(String fileName, Element element) {
        super(fileName + ":" + XMLUtil.getPath(element));
        this.m_fileName = fileName;
        this.m_element = element;
        this.processChildren(this.m_element);
    }

    public boolean getDebug() {
        Object str = this.getProperty("debug");
        if (str instanceof String) {
            return Boolean.valueOf((String)str);
        }
        if (str instanceof Boolean) {
            return (Boolean)str;
        }
        return this.m_propertyCache.get("debug") != null;
    }

    public final void setParent(IXMLTest parent) {
        this.m_parent = parent;
        this.m_propertyCache.setParent(parent.getPropertyCache());
        this.m_procedures.setParent(parent.getProcedureCache());
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public IXMLProcedure getProcedure(String name) {
        return (IXMLProcedure)this.m_procedures.get(name);
    }

    public XMLObjectCache getProcedureCache() {
        return this.m_procedures;
    }

    public Object getProperty(String name) {
        return this.getPropertyCache().get(name);
    }

    public XMLObjectCache getPropertyCache() {
        return this.m_propertyCache;
    }

    public String getPropertyName(Object value) {
        return this.getPropertyCache().getName(value);
    }

    public String[] getPropertyNames() {
        return this.getPropertyCache().getNames();
    }

    public void addFile(String xmlFileName) {
        XMLTestSuite suite = new XMLTestSuite(xmlFileName);
        suite.setParent(this);
        this.addTest(suite);
    }

    public void addProcedure(IXMLProcedure proc) {
        if (proc == null) {
            throw new IllegalArgumentException("procedure must be specified");
        }
        this.m_procedures.put(proc.getName(), proc);
    }

    public void addProperty(String name, Object value) {
        this.getPropertyCache().put(name, value);
    }

    public void addTest(Test test) {
        if (test instanceof IXMLTest) {
            ((IXMLTest)test).setParent(this);
        }
        super.addTest(test);
    }

    public void clearProperties() {
        this.getPropertyCache().clear();
    }

    public void removeProperty(String name) {
        this.getPropertyCache().remove(name);
    }

    public String resolveProperties(String s) {
        return this.m_propertyCache.resolve(s);
    }

    private void processChildren(Element e) {
        NodeList children = e.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            Element child = (Element)children.item(i);
            String name = child.getTagName();
            try {
                XMLTagResourceBundle.getTagHandler(child, this, name).processElement();
                continue;
            }
            catch (XMLException xe) {
                throw xe;
            }
            catch (Throwable t) {
                throw new XMLException(t.getMessage(), t, child, this.getPropertyCache());
            }
        }
    }
}

