/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.tools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class ComponentNode
implements TreeNode {
    private Component m_component;
    private ComponentNode m_parent;

    public ComponentNode(ComponentNode parent, Component comp) {
        this.m_parent = parent;
        this.m_component = comp;
    }

    public boolean getAllowsChildren() {
        return this.m_component == null || this.m_component instanceof Container;
    }

    /*
     * WARNING - void declaration
     */
    public TreeNode getChildAt(int childIndex) {
        void var2_2;
        Component child;
        if (this.m_component == null) {
            child = (Window)this.getAllWindows().elementAt(childIndex);
        } else if (this.m_component instanceof Container) {
            Container container = (Container)this.m_component;
            int cnt = container.getComponentCount();
            if (childIndex >= cnt && container instanceof Window) {
                Window[] windows = ((Window)container).getOwnedWindows();
                child = windows[childIndex - cnt];
            } else {
                child = container.getComponent(childIndex);
            }
        } else {
            throw new RuntimeException("no child with index " + childIndex);
        }
        return new ComponentNode(this, (Component)var2_2);
    }

    public int getChildCount() {
        int num = 0;
        if (this.m_component == null) {
            num = this.getAllWindows().size();
        } else if (this.m_component instanceof Container) {
            Container container = (Container)this.m_component;
            num = container.getComponentCount();
            if (container instanceof Window) {
                num += ((Window)container).getOwnedWindows().length;
            }
        }
        return num;
    }

    public Component getComponent() {
        return this.m_component;
    }

    public int getIndex(TreeNode node) {
        int index = -1;
        int num = this.getChildCount();
        for (int i = 0; i < num; ++i) {
            if (!node.equals(this.getChildAt(i))) continue;
            index = i;
            break;
        }
        return index;
    }

    public boolean isLeaf() {
        return !this.getAllowsChildren() || this.getChildCount() == 0;
    }

    public TreeNode getParent() {
        return this.m_parent;
    }

    public Enumeration children() {
        Vector<TreeNode> kids = new Vector<TreeNode>();
        int num = this.getChildCount();
        for (int i = 0; i < num; ++i) {
            kids.add(this.getChildAt(i));
        }
        return kids.elements();
    }

    public boolean equals(Object other) {
        return other instanceof ComponentNode && this.m_component == ((ComponentNode)other).m_component;
    }

    public int hashCode() {
        if (this.m_component == null) {
            return 1;
        }
        return this.m_component.hashCode();
    }

    public String toString() {
        if (this.m_component == null) {
            return "All Frames";
        }
        if (this.m_component.getName() == null) {
            return this.m_component.getClass().getName() + " : " + this.m_component.hashCode();
        }
        return this.m_component.getName();
    }

    private Vector getAllWindows() {
        Frame[] allWindows = Frame.getFrames();
        Vector<Frame> filteredWindows = new Vector<Frame>(allWindows.length);
        if (allWindows == null || allWindows.length == 0) {
            filteredWindows.trimToSize();
            return filteredWindows;
        }
        for (int i = 0; i < allWindows.length; ++i) {
            if (allWindows[i] == null || !(allWindows[i] instanceof Frame) || !allWindows[i].isShowing() || "ComponentBrowser".equals(allWindows[i].getTitle())) continue;
            filteredWindows.addElement(allWindows[i]);
        }
        filteredWindows.trimToSize();
        return filteredWindows;
    }
}

