/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nManager;

public class I18nFactory {
    private static HashMap i18nByPackage = new HashMap();
    public static final String DEFAULT_BASE_NAME = "i18n.Messages";
    public static final String PROPS_FILENAME = "i18n.properties";

    static void clearCache() {
        Iterator it = i18nByPackage.values().iterator();
        while (it.hasNext()) {
            I18n i18n = (I18n)it.next();
            I18nManager.getInstance().remove(i18n);
        }
        i18nByPackage.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerI18n(I18n i18n, String base, Class clazz) {
        String path = clazz.getName();
        if (!path.startsWith(base)) {
            throw new IllegalArgumentException();
        }
        HashMap hashMap = i18nByPackage;
        synchronized (hashMap) {
            int index = path.lastIndexOf(46);
            while (index != -1 && path.length() > base.length()) {
                path = path.substring(0, index);
                i18nByPackage.put(path, i18n);
                index = path.lastIndexOf(46);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerI18nForDefaultPackage(I18n i18n) {
        HashMap hashMap = i18nByPackage;
        synchronized (hashMap) {
            i18nByPackage.put("", i18n);
        }
    }

    static boolean isInDefaultPackage(Class clazz) {
        return clazz.getName().indexOf(46) == -1;
    }

    static I18n findI18nInDefaultPackage(String baseName, ClassLoader loader) {
        I18n i18n = (I18n)i18nByPackage.get("");
        if (i18n != null) {
            return i18n;
        }
        i18n = I18nFactory.readFromPropertiesFile("", loader);
        if (i18n != null) {
            return i18n;
        }
        i18n = I18nFactory.findByBaseName(baseName, "", loader);
        if (i18n != null) {
            return i18n;
        }
        return null;
    }

    public static I18n getI18n(Class clazz) {
        return I18nFactory.getI18n(clazz, DEFAULT_BASE_NAME);
    }

    public static I18n getI18n(Class clazz, String baseName) {
        I18n i18n;
        if (I18nFactory.isInDefaultPackage(clazz)) {
            I18n i18n2 = I18nFactory.findI18nInDefaultPackage(baseName, clazz.getClassLoader());
            if (i18n2 != null) {
                I18nFactory.registerI18nForDefaultPackage(i18n2);
                return i18n2;
            }
            throw new MissingResourceException("resource bundle not found", clazz.getClass().getName(), baseName);
        }
        String path = clazz.getName();
        int index = path.lastIndexOf(46);
        while (index != -1) {
            i18n = (I18n)i18nByPackage.get(path = path.substring(0, index));
            if (i18n != null) {
                I18nFactory.registerI18n(i18n, path, clazz);
                return i18n;
            }
            i18n = I18nFactory.readFromPropertiesFile(path, clazz.getClassLoader());
            if (i18n != null) {
                I18nFactory.registerI18n(i18n, path, clazz);
                return i18n;
            }
            index = path.lastIndexOf(46);
        }
        path = clazz.getName();
        index = path.lastIndexOf(46);
        while (index != -1) {
            i18n = I18nFactory.findByBaseName(baseName, path = path.substring(0, index), clazz.getClassLoader());
            if (i18n != null) {
                I18nFactory.registerI18n(i18n, path, clazz);
                return i18n;
            }
            index = path.lastIndexOf(46);
        }
        throw new MissingResourceException("resource bundle not found", clazz.getClass().getName(), baseName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static I18n readFromPropertiesFile(String path, ClassLoader loader) {
        Properties props = new Properties();
        InputStream in = loader.getResourceAsStream(path = path.length() == 0 ? PROPS_FILENAME : path.replace('.', '/') + "/" + PROPS_FILENAME);
        if (in != null) {
            try {
                props.load(in);
            }
            catch (IOException e) {
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            String baseName = props.getProperty("basename");
            if (baseName != null) {
                return I18nFactory.createI18n(baseName, Locale.getDefault(), loader);
            }
        }
        return null;
    }

    static I18n findByBaseName(String baseName, String path, ClassLoader loader) {
        path = path.length() == 0 ? baseName : path + "." + baseName;
        try {
            return I18nFactory.createI18n(path, Locale.getDefault(), loader);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private static I18n createI18n(String baseName, Locale locale, ClassLoader loader) {
        I18n i18n = new I18n(baseName, locale, loader);
        I18nManager.getInstance().add(i18n);
        return i18n;
    }
}

