/*
 * Decompiled with CFR 0.152.
 */
package mappaint;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import mappaint.AreaElemStyle;
import mappaint.ElemStyle;
import mappaint.IconElemStyle;
import mappaint.LineElemStyle;
import mappaint.MapPaintPlugin;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Segment;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.SimplePaintVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;

public class MapPaintVisitor
extends SimplePaintVisitor {
    protected boolean useRealWidth;
    protected boolean zoomLevelDisplay;
    protected boolean fillAreas;
    protected Color untaggedColor;
    protected Color textColor;
    protected boolean currentDashed = false;
    protected int currentWidth = 0;
    protected Stroke currentStroke = null;
    protected static final Font orderFont = new Font("Helvetica", 0, 8);

    protected boolean isZoomOk(ElemStyle e) {
        double circum = Main.map.mapView.getScale() * 100.0 * Main.proj.scaleFactor() * 4.0041455E7;
        if (!this.zoomLevelDisplay) {
            return true;
        }
        if (e == null) {
            return circum < 1500.0;
        }
        return !(circum >= (double)(e.getMaxScale() / 22L)) && !(circum < (double)(e.getMinScale() / 22L));
    }

    public void visit(Node n) {
        ElemStyle nodeStyle = MapPaintPlugin.elemStyles.getStyle((OsmPrimitive)n);
        if (nodeStyle != null) {
            if (nodeStyle instanceof IconElemStyle && this.isZoomOk(nodeStyle)) {
                this.drawNode(n, ((IconElemStyle)nodeStyle).getIcon(), ((IconElemStyle)nodeStyle).doAnnotate());
            }
        } else {
            this.drawNode(n, n.selected ? this.selectedColor : this.nodeColor);
        }
    }

    public void visit(Segment ls) {
        ElemStyle segmentStyle = MapPaintPlugin.elemStyles.getStyle((OsmPrimitive)ls);
        if (this.isZoomOk(segmentStyle)) {
            this.drawSegment(ls, this.untaggedColor, this.showDirectionArrow);
        }
    }

    public void visit(Way w) {
        double circum = Main.map.mapView.getScale() * 100.0 * Main.proj.scaleFactor() * 4.0041455E7;
        boolean showDirection = this.showDirectionArrow;
        if (this.useRealWidth && showDirection && !w.selected) {
            showDirection = false;
        }
        Color colour = this.untaggedColor;
        int width = 2;
        int realWidth = 0;
        boolean dashed = false;
        boolean area = false;
        ElemStyle wayStyle = MapPaintPlugin.elemStyles.getStyle((OsmPrimitive)w);
        if (!this.isZoomOk(wayStyle)) {
            return;
        }
        if (wayStyle != null) {
            if (wayStyle instanceof LineElemStyle) {
                colour = ((LineElemStyle)wayStyle).getColour();
                width = ((LineElemStyle)wayStyle).getWidth();
                realWidth = ((LineElemStyle)wayStyle).getRealWidth();
                dashed = ((LineElemStyle)wayStyle).dashed;
            } else if (wayStyle instanceof AreaElemStyle) {
                colour = ((AreaElemStyle)wayStyle).getColour();
                area = true;
            }
        }
        if (area && this.fillAreas) {
            this.drawWayAsArea(w, colour);
        }
        int orderNumber = 0;
        for (Segment ls : w.segments) {
            int tmpWidth;
            ++orderNumber;
            if (area && this.fillAreas) {
                this.drawSegment(ls, w.selected ? this.selectedColor : this.untaggedColor, showDirection, width, true);
            } else if (area) {
                this.drawSegment(ls, w.selected ? this.selectedColor : colour, showDirection, width, true);
            } else if (realWidth > 0 && this.useRealWidth && !showDirection && (tmpWidth = (int)(100.0f / (float)(circum / (double)realWidth))) > width) {
                width = tmpWidth;
            }
            this.drawSegment(ls, w.selected ? this.selectedColor : colour, showDirection, width, dashed);
            if (ls.incomplete || !this.showOrderNumber) continue;
            try {
                this.g.setColor(w.selected ? this.selectedColor : colour);
                this.drawOrderNumber(ls, orderNumber);
            }
            catch (IllegalAccessError e) {}
        }
    }

    protected void drawWayAsArea(Way w, Color colour) {
        Polygon polygon = new Polygon();
        boolean first = true;
        for (Segment ls : w.segments) {
            Point p;
            if (ls.incomplete) continue;
            if (first) {
                p = this.nc.getPoint(ls.from.eastNorth);
                polygon.addPoint(p.x, p.y);
                first = false;
            }
            p = this.nc.getPoint(ls.to.eastNorth);
            polygon.addPoint(p.x, p.y);
        }
        this.g.setColor(w.selected ? this.selectedColor : colour);
        this.g.fillPolygon(polygon);
    }

    protected void drawNode(Node n, ImageIcon icon, boolean annotate) {
        String name;
        Point p = this.nc.getPoint(n.eastNorth);
        if (p.x < 0 || p.y < 0 || p.x > this.nc.getWidth() || p.y > this.nc.getHeight()) {
            return;
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        icon.paintIcon((Component)Main.map.mapView, this.g, p.x - w / 2, p.y - h / 2);
        String string = name = n.keys == null ? null : (String)n.keys.get("name");
        if (name != null && annotate) {
            this.g.setColor(this.textColor);
            Font defaultFont = this.g.getFont();
            this.g.setFont(orderFont);
            this.g.drawString(name, p.x + w / 2 + 2, p.y + h / 2 + 2);
            this.g.setFont(defaultFont);
        }
        if (n.selected) {
            this.g.setColor(this.selectedColor);
            this.g.drawRect(p.x - w / 2 - 2, p.y - w / 2 - 2, w + 4, h + 4);
        }
    }

    protected void drawSegment(Segment ls, Color col, boolean showDirection) {
        if (this.useRealWidth && showDirection && !ls.selected) {
            showDirection = false;
        }
        this.drawSegment(ls, col, showDirection, 1, false);
    }

    private void drawSegment(Segment ls, Color col, boolean showDirection, int width, boolean dashed) {
        if (ls.shown) {
            return;
        }
        ls.shown = true;
        if (ls.incomplete) {
            return;
        }
        if (ls.selected) {
            col = this.selectedColor;
        }
        this.drawSeg(ls, col, showDirection, width, dashed);
    }

    private void drawSeg(Segment ls, Color col, boolean showDirection, int width, boolean dashed) {
        if (col != this.currentColor || width != this.currentWidth || dashed != this.currentDashed) {
            this.displaySegments(col, width, dashed);
        }
        Point p1 = this.nc.getPoint(ls.from.eastNorth);
        Point p2 = this.nc.getPoint(ls.to.eastNorth);
        if (p1.x < 0 && p2.x < 0) {
            return;
        }
        if (p1.y < 0 && p2.y < 0) {
            return;
        }
        if (p1.x > this.nc.getWidth() && p2.x > this.nc.getWidth()) {
            return;
        }
        if (p1.y > this.nc.getHeight() && p2.y > this.nc.getHeight()) {
            return;
        }
        this.currrentPath.moveTo(p1.x, p1.y);
        this.currrentPath.lineTo(p2.x, p2.y);
        if (showDirection) {
            double t = Math.atan2(p2.y - p1.y, p2.x - p1.x) + Math.PI;
            this.currrentPath.lineTo((int)((double)p2.x + 10.0 * Math.cos(t - PHI)), (int)((double)p2.y + 10.0 * Math.sin(t - PHI)));
            this.currrentPath.moveTo((int)((double)p2.x + 10.0 * Math.cos(t + PHI)), (int)((double)p2.y + 10.0 * Math.sin(t + PHI)));
            this.currrentPath.lineTo(p2.x, p2.y);
        }
    }

    protected void displaySegments() {
        this.displaySegments(null, 0, false);
    }

    protected void displaySegments(Color newColor, int newWidth, boolean newDash) {
        if (this.currrentPath != null) {
            Graphics2D g2d = (Graphics2D)this.g;
            g2d.setColor(this.currentColor);
            if (this.currentStroke == null) {
                if (this.currentDashed) {
                    g2d.setStroke(new BasicStroke(this.currentWidth, 0, 1, 0.0f, new float[]{9.0f}, 0.0f));
                } else {
                    g2d.setStroke(new BasicStroke(this.currentWidth, 1, 1));
                }
            }
            g2d.draw(this.currrentPath);
            g2d.setStroke(new BasicStroke(1.0f));
            this.currrentPath = new GeneralPath();
            this.currentColor = newColor;
            this.currentWidth = newWidth;
            this.currentDashed = newDash;
            this.currentStroke = null;
        }
    }

    public void drawNode(Node n, Color color) {
        if (this.isZoomOk(null)) {
            Point p = this.nc.getPoint(n.eastNorth);
            if (p.x < 0 || p.y < 0 || p.x > this.nc.getWidth() || p.y > this.nc.getHeight()) {
                return;
            }
            this.g.setColor(color);
            this.g.drawRect(p.x - 1, p.y - 1, 2, 2);
        }
    }

    public void visitAll(DataSet data) {
        this.inactiveColor = MapPaintVisitor.getPreferencesColor((String)"inactive", (Color)Color.DARK_GRAY);
        this.selectedColor = MapPaintVisitor.getPreferencesColor((String)"selected", (Color)Color.YELLOW);
        this.nodeColor = MapPaintVisitor.getPreferencesColor((String)"node", (Color)Color.RED);
        this.segmentColor = MapPaintVisitor.getPreferencesColor((String)"segment", (Color)darkgreen);
        this.dfltWayColor = MapPaintVisitor.getPreferencesColor((String)"way", (Color)darkblue);
        this.incompleteColor = MapPaintVisitor.getPreferencesColor((String)"incomplete way", (Color)darkerblue);
        this.backgroundColor = MapPaintVisitor.getPreferencesColor((String)"background", (Color)Color.BLACK);
        this.untaggedColor = MapPaintVisitor.getPreferencesColor((String)"untagged", (Color)Color.GRAY);
        this.textColor = MapPaintVisitor.getPreferencesColor((String)"text", (Color)Color.WHITE);
        this.showDirectionArrow = Main.pref.getBoolean("draw.segment.direction");
        this.showOrderNumber = Main.pref.getBoolean("draw.segment.order_number");
        this.useRealWidth = Main.pref.getBoolean("mappaint.useRealWidth", false);
        this.zoomLevelDisplay = Main.pref.getBoolean("mappaint.zoomLevelDisplay", false);
        this.fillAreas = Main.pref.getBoolean("mappaint.fillareas", true);
        LinkedList<Way> noAreaWays = new LinkedList<Way>();
        for (Segment segment : data.segments) {
            if (segment.deleted) continue;
            segment.shown = false;
        }
        for (Way way : data.ways) {
            if (!way.deleted && MapPaintPlugin.elemStyles.isArea((OsmPrimitive)way)) {
                way.visit((Visitor)this);
                continue;
            }
            if (way.deleted) continue;
            noAreaWays.add(way);
        }
        for (Way way : noAreaWays) {
            way.visit((Visitor)this);
        }
        for (Segment segment : data.segments) {
            if (segment.deleted) continue;
            segment.visit((Visitor)this);
        }
        for (Node node : data.nodes) {
            if (node.deleted) continue;
            node.visit((Visitor)this);
        }
        for (OsmPrimitive osmPrimitive : data.getSelected()) {
            if (osmPrimitive.deleted) continue;
            osmPrimitive.shown = false;
            osmPrimitive.visit((Visitor)this);
        }
        this.displaySegments();
    }
}

