/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.reflectionassert;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.unitils.core.UnitilsException;
import org.unitils.reflectionassert.comparator.Comparator;
import org.unitils.reflectionassert.difference.Difference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionComparator {
    protected List<Comparator> comparators;
    protected Map<Object, Map<Object, Difference>> firstDifferenceCachedResults = new IdentityHashMap<Object, Map<Object, Difference>>();
    protected Map<Object, Map<Object, Difference>> allDifferencesCachedResults = new IdentityHashMap<Object, Map<Object, Difference>>();

    public ReflectionComparator(List<Comparator> comparators) {
        this.comparators = comparators;
    }

    public boolean isEqual(Object left, Object right) {
        Difference difference = this.getDifference(left, right, true);
        return difference == null;
    }

    public Difference getDifference(Object left, Object right) {
        return this.getDifference(left, right, false);
    }

    public Difference getDifference(Object left, Object right, boolean onlyFirstDifference) {
        Map<Object, Difference> cachedResult = this.getCachedDifference(left, onlyFirstDifference);
        if (cachedResult != null) {
            if (cachedResult.containsKey(right)) {
                return cachedResult.get(right);
            }
        } else {
            cachedResult = new IdentityHashMap<Object, Difference>();
            this.saveResultInCache(left, cachedResult, onlyFirstDifference);
        }
        cachedResult.put(right, null);
        boolean compared = false;
        Difference result = null;
        for (Comparator comparator : this.comparators) {
            if (!comparator.canCompare(left, right)) continue;
            result = comparator.compare(left, right, onlyFirstDifference, this);
            compared = true;
            break;
        }
        if (!compared) {
            throw new UnitilsException("Could not determine differences. No comparator found that is able to compare the values. Left: " + left + ", right " + right);
        }
        cachedResult.put(right, result);
        return result;
    }

    protected void saveResultInCache(Object left, Map<Object, Difference> cachedResult, boolean onlyFirstDifference) {
        if (onlyFirstDifference) {
            this.firstDifferenceCachedResults.put(left, cachedResult);
        } else {
            this.allDifferencesCachedResults.put(left, cachedResult);
        }
    }

    protected Map<Object, Difference> getCachedDifference(Object left, boolean onlyFirstDifference) {
        if (onlyFirstDifference) {
            return this.firstDifferenceCachedResults.get(left);
        }
        return this.allDifferencesCachedResults.get(left);
    }
}

