/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.reflectionassert.difference;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unitils.reflectionassert.difference.Difference;
import org.unitils.reflectionassert.difference.DifferenceVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnorderedCollectionDifference
extends Difference {
    private Map<Integer, Map<Integer, Difference>> elementDifferences = new HashMap<Integer, Map<Integer, Difference>>();
    private Map<Integer, Integer> bestMatchingIndexes = new HashMap<Integer, Integer>();
    private int bestMatchingScore = Integer.MAX_VALUE;
    private List<?> leftList;
    private List<?> rightList;

    public UnorderedCollectionDifference(String message, Object leftValue, Object rightValue, List<?> leftList, List<?> rightList) {
        super(message, leftValue, rightValue);
        this.leftList = leftList;
        this.rightList = rightList;
    }

    public void addElementDifference(int leftIndex, int rightIndex, Difference difference) {
        Map<Integer, Difference> rightDifferences = this.elementDifferences.get(leftIndex);
        if (rightDifferences == null) {
            rightDifferences = new HashMap<Integer, Difference>();
            this.elementDifferences.put(leftIndex, rightDifferences);
        }
        rightDifferences.put(rightIndex, difference);
    }

    public Difference getElementDifference(int leftIndex, int rightIndex) {
        Map<Integer, Difference> rightDifferences = this.elementDifferences.get(leftIndex);
        if (rightDifferences == null) {
            return null;
        }
        return rightDifferences.get(rightIndex);
    }

    public Map<Integer, Map<Integer, Difference>> getElementDifferences() {
        return this.elementDifferences;
    }

    public void setBestMatchingIndexes(int leftIndex, int rightIndex) {
        this.bestMatchingIndexes.put(leftIndex, rightIndex);
    }

    public Map<Integer, Integer> getBestMatchingIndexes() {
        return this.bestMatchingIndexes;
    }

    public int getBestMatchingScore() {
        return this.bestMatchingScore;
    }

    public void setBestMatchingScore(int bestMatchingScore) {
        this.bestMatchingScore = bestMatchingScore;
    }

    public List<?> getLeftList() {
        return this.leftList;
    }

    public List<?> getRightList() {
        return this.rightList;
    }

    @Override
    public <T, A> T accept(DifferenceVisitor<T, A> visitor, A argument) {
        return visitor.visit(this, argument);
    }
}

