/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.reflectionassert.report.impl;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;
import org.unitils.core.util.ObjectFormatter;
import org.unitils.reflectionassert.difference.ClassDifference;
import org.unitils.reflectionassert.difference.CollectionDifference;
import org.unitils.reflectionassert.difference.Difference;
import org.unitils.reflectionassert.difference.DifferenceVisitor;
import org.unitils.reflectionassert.difference.MapDifference;
import org.unitils.reflectionassert.difference.ObjectDifference;
import org.unitils.reflectionassert.difference.UnorderedCollectionDifference;
import org.unitils.reflectionassert.report.DifferenceView;
import org.unitils.reflectionassert.report.impl.DefaultDifferenceReport;

public class TreeDifferenceView
implements DifferenceView {
    protected ObjectFormatter objectFormatter = new ObjectFormatter();
    protected TreeDifferenceFormatterVisitor treeDifferenceFormatterVisitor = new TreeDifferenceFormatterVisitor();

    public String createView(Difference difference) {
        return difference.accept(this.treeDifferenceFormatterVisitor, null);
    }

    protected String formatDifference(Difference difference, String fieldName) {
        return this.formatValues(fieldName, difference.getLeftValue(), difference.getRightValue());
    }

    protected String formatDifference(ObjectDifference objectDifference, String fieldName) {
        StringBuilder result = new StringBuilder();
        result.append(this.formatDifference((Difference)objectDifference, fieldName));
        for (Map.Entry<String, Difference> fieldDifference : objectDifference.getFieldDifferences().entrySet()) {
            String innerFieldName = this.createFieldName(fieldName, fieldDifference.getKey(), true);
            result.append(fieldDifference.getValue().accept(this.treeDifferenceFormatterVisitor, innerFieldName));
        }
        return result.toString();
    }

    protected String formatDifference(ClassDifference classDifference, String fieldName) {
        StringBuilder result = new StringBuilder();
        result.append(fieldName == null ? "" : fieldName + ":");
        result.append("Expected: object of type ").append(ClassUtils.getShortClassName(classDifference.getLeftClass()));
        result.append(", actual: object of type ").append(ClassUtils.getShortClassName(classDifference.getRightClass())).append("\n");
        return result.toString();
    }

    protected String formatDifference(CollectionDifference collectionDifference, String fieldName) {
        String innerFieldName;
        StringBuilder result = new StringBuilder();
        result.append(this.formatDifference((Difference)collectionDifference, fieldName));
        for (Map.Entry<Integer, Difference> elementDifferences : collectionDifference.getElementDifferences().entrySet()) {
            String innerFieldName2 = this.createFieldName(fieldName, "[" + elementDifferences.getKey() + "]", false);
            result.append(elementDifferences.getValue().accept(this.treeDifferenceFormatterVisitor, innerFieldName2));
        }
        List<?> leftList = collectionDifference.getLeftList();
        List<?> rightList = collectionDifference.getRightList();
        for (Integer leftIndex : collectionDifference.getLeftMissingIndexes()) {
            innerFieldName = this.createFieldName(fieldName, "[" + leftIndex + "]", false);
            result.append(this.formatValues(innerFieldName, leftList.get(leftIndex), ""));
        }
        for (Integer rightIndex : collectionDifference.getRightMissingIndexes()) {
            innerFieldName = this.createFieldName(fieldName, "[" + rightIndex + "]", false);
            result.append(this.formatValues(innerFieldName, "", rightList.get(rightIndex)));
        }
        return result.toString();
    }

    protected String formatDifference(MapDifference mapDifference, String fieldName) {
        String innerFieldName;
        StringBuilder result = new StringBuilder();
        result.append(this.formatDifference((Difference)mapDifference, fieldName));
        for (Map.Entry<Object, Difference> valueDifference : mapDifference.getValueDifferences().entrySet()) {
            String innerFieldName2 = this.createFieldName(fieldName, this.formatObject(valueDifference.getKey()), true);
            result.append(valueDifference.getValue().accept(this.treeDifferenceFormatterVisitor, innerFieldName2));
        }
        Map<?, ?> leftMap = mapDifference.getLeftMap();
        Map<?, ?> rightMap = mapDifference.getRightMap();
        for (Object leftKey : mapDifference.getLeftMissingKeys()) {
            innerFieldName = this.createFieldName(fieldName, this.formatObject(leftKey), true);
            result.append(this.formatValues(innerFieldName, leftMap.get(leftKey), ""));
        }
        for (Object rightKey : mapDifference.getRightMissingKeys()) {
            innerFieldName = this.createFieldName(fieldName, this.formatObject(rightKey), true);
            result.append(this.formatValues(innerFieldName, rightMap.get(rightKey), ""));
        }
        return result.toString();
    }

    protected String formatObject(Object object) {
        if (object == DefaultDifferenceReport.MatchType.NO_MATCH) {
            return "--no match--";
        }
        return this.objectFormatter.format(object);
    }

    protected String formatDifference(UnorderedCollectionDifference unorderedCollectionDifference, String fieldName) {
        StringBuilder result = new StringBuilder();
        result.append(this.formatDifference((Difference)unorderedCollectionDifference, fieldName));
        Map<Integer, Integer> bestMatchingIndexes = unorderedCollectionDifference.getBestMatchingIndexes();
        for (Map.Entry<Integer, Integer> bestMatchingIndex : bestMatchingIndexes.entrySet()) {
            String innerFieldName;
            int leftIndex = bestMatchingIndex.getKey();
            int rightIndex = bestMatchingIndex.getValue();
            if (leftIndex == -1) {
                innerFieldName = this.createFieldName(fieldName, "[x," + rightIndex + "]", false);
                result.append(this.formatValues(innerFieldName, (Object)DefaultDifferenceReport.MatchType.NO_MATCH, unorderedCollectionDifference.getRightList().get(rightIndex)));
                continue;
            }
            if (rightIndex == -1) {
                innerFieldName = this.createFieldName(fieldName, "[" + leftIndex + ",x]", false);
                result.append(this.formatValues(innerFieldName, unorderedCollectionDifference.getLeftList().get(leftIndex), (Object)DefaultDifferenceReport.MatchType.NO_MATCH));
                continue;
            }
            Difference difference = unorderedCollectionDifference.getElementDifference(leftIndex, rightIndex);
            if (difference == null) continue;
            String innerFieldName2 = this.createFieldName(fieldName, "[" + leftIndex + "," + rightIndex + "]", false);
            result.append(difference.accept(this.treeDifferenceFormatterVisitor, innerFieldName2));
        }
        return result.toString();
    }

    protected String formatValues(String fieldName, Object leftValue, Object rightValue) {
        StringBuilder result = new StringBuilder();
        String prefix = fieldName == null ? "" : fieldName;
        result.append(prefix);
        result.append(" expected: ");
        result.append(this.formatObject(leftValue));
        result.append("\n");
        result.append(prefix);
        result.append("   actual: ");
        result.append(this.formatObject(rightValue));
        result.append("\n\n");
        return result.toString();
    }

    protected String createFieldName(String fieldName, String innerFieldName, boolean includePoint) {
        if (fieldName == null) {
            return innerFieldName;
        }
        StringBuilder result = new StringBuilder();
        result.append(fieldName);
        if (includePoint) {
            result.append(".");
        }
        result.append(innerFieldName);
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TreeDifferenceFormatterVisitor
    implements DifferenceVisitor<String, String> {
        protected TreeDifferenceFormatterVisitor() {
        }

        @Override
        public String visit(Difference difference, String fieldName) {
            return TreeDifferenceView.this.formatDifference(difference, fieldName);
        }

        @Override
        public String visit(ObjectDifference objectDifference, String fieldName) {
            return TreeDifferenceView.this.formatDifference(objectDifference, fieldName);
        }

        @Override
        public String visit(ClassDifference classDifference, String fieldName) {
            return TreeDifferenceView.this.formatDifference(classDifference, fieldName);
        }

        @Override
        public String visit(MapDifference mapDifference, String fieldName) {
            return TreeDifferenceView.this.formatDifference(mapDifference, fieldName);
        }

        @Override
        public String visit(CollectionDifference collectionDifference, String fieldName) {
            return TreeDifferenceView.this.formatDifference(collectionDifference, fieldName);
        }

        @Override
        public String visit(UnorderedCollectionDifference unorderedCollectionDifference, String fieldName) {
            return TreeDifferenceView.this.formatDifference(unorderedCollectionDifference, fieldName);
        }
    }
}

