/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.core.dbsupport;

import java.util.Set;
import org.unitils.core.dbsupport.DbSupport;
import org.unitils.core.dbsupport.SQLHandler;
import org.unitils.core.util.StoredIdentifierCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySqlDbSupport
extends DbSupport {
    public MySqlDbSupport() {
        super("mysql");
    }

    @Override
    public Set<String> getTableNames() {
        return this.getSQLHandler().getItemsAsStringSet("select table_name from information_schema.tables where table_schema = '" + this.getSchemaName() + "' and table_type = 'BASE TABLE'");
    }

    @Override
    public Set<String> getColumnNames(String tableName) {
        return this.getSQLHandler().getItemsAsStringSet("select column_name from information_schema.columns where table_name = '" + tableName + "' and table_schema = '" + this.getSchemaName() + "'");
    }

    @Override
    public Set<String> getViewNames() {
        return this.getSQLHandler().getItemsAsStringSet("select table_name from information_schema.tables where table_schema = '" + this.getSchemaName() + "' and table_type = 'VIEW'");
    }

    @Override
    public Set<String> getTriggerNames() {
        return this.getSQLHandler().getItemsAsStringSet("select trigger_name from information_schema.triggers where trigger_schema = '" + this.getSchemaName() + "'");
    }

    @Override
    public void disableReferentialConstraints() {
        Set<String> tableNames = this.getTableNames();
        for (String tableName : tableNames) {
            this.disableReferentialConstraints(tableName);
        }
    }

    protected void disableReferentialConstraints(String tableName) {
        SQLHandler sqlHandler = this.getSQLHandler();
        Set<String> constraintNames = sqlHandler.getItemsAsStringSet("select constraint_name from information_schema.table_constraints where constraint_type = 'FOREIGN KEY' AND table_name = '" + tableName + "' and constraint_schema = '" + this.getSchemaName() + "'");
        for (String constraintName : constraintNames) {
            sqlHandler.executeUpdate("alter table " + this.qualified(tableName) + " drop foreign key " + this.quoted(constraintName));
        }
    }

    @Override
    public void disableValueConstraints() {
        Set<String> tableNames = this.getTableNames();
        for (String tableName : tableNames) {
            this.disableValueConstraints(tableName);
        }
    }

    protected void disableValueConstraints(String tableName) {
        SQLHandler sqlHandler = this.getSQLHandler();
        Set<String> constraintNames = sqlHandler.getItemsAsStringSet("select constraint_name from information_schema.table_constraints where constraint_type in ('UNIQUE') AND table_name = '" + tableName + "' and constraint_schema = '" + this.getSchemaName() + "'");
        for (String constraintName : constraintNames) {
            sqlHandler.executeUpdate("alter table " + this.qualified(tableName) + " drop key " + this.quoted(constraintName));
        }
        Set<String> notNullColumnNames = sqlHandler.getItemsAsStringSet("select column_name from information_schema.columns where is_nullable = 'NO' and column_key <> 'PRI' and table_name = '" + tableName + "' and table_schema = '" + this.getSchemaName() + "'");
        for (String notNullColumnName : notNullColumnNames) {
            String columnType = sqlHandler.getItemAsString("select column_type from information_schema.columns where table_schema = '" + this.getSchemaName() + "' and table_name = '" + tableName + "' and column_name = '" + notNullColumnName + "'");
            sqlHandler.executeUpdate("alter table " + this.qualified(tableName) + " change column " + this.quoted(notNullColumnName) + " " + this.quoted(notNullColumnName) + " " + columnType + " NULL ");
        }
    }

    @Override
    public Set<String> getIdentityColumnNames(String tableName) {
        return this.getSQLHandler().getItemsAsStringSet("select column_name from information_schema.columns where table_name = '" + tableName + "' and column_key = 'PRI' and table_schema = '" + this.getSchemaName() + "'");
    }

    @Override
    public void incrementIdentityColumnToValue(String tableName, String primaryKeyColumnName, long identityValue) {
        this.getSQLHandler().executeUpdate("alter table " + this.qualified(tableName) + " AUTO_INCREMENT = " + identityValue);
    }

    @Override
    public String toCorrectCaseIdentifier(String identifier) {
        StoredIdentifierCase storedIdentifierCase;
        String identifierQuoteString;
        if ((identifier = identifier.trim()).startsWith(identifierQuoteString = this.getIdentifierQuoteString()) && identifier.endsWith(identifierQuoteString)) {
            identifier = identifier.substring(1, identifier.length() - 1);
        }
        if ((storedIdentifierCase = this.getStoredIdentifierCase()) == StoredIdentifierCase.UPPER_CASE) {
            return identifier.toUpperCase();
        }
        if (storedIdentifierCase == StoredIdentifierCase.LOWER_CASE) {
            return identifier.toLowerCase();
        }
        return identifier;
    }

    @Override
    public boolean supportsTriggers() {
        return true;
    }

    @Override
    public boolean supportsIdentityColumns() {
        return true;
    }

    @Override
    public boolean supportsCascade() {
        return true;
    }
}

