/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.unitils.core.UnitilsException;
import org.unitils.thirdparty.org.apache.commons.io.IOUtils;

public class FileUtils {
    public static void copyClassPathResource(String classPathResourceName, String fileSystemDirectoryName) {
        InputStream resourceInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            resourceInputStream = FileUtils.class.getResourceAsStream(classPathResourceName);
            String fileName = StringUtils.substringAfterLast((String)classPathResourceName, (String)"/");
            File fileSystemDirectory = new File(fileSystemDirectoryName);
            fileSystemDirectory.mkdirs();
            fileOutputStream = new FileOutputStream(fileSystemDirectoryName + "/" + fileName);
            IOUtils.copy(resourceInputStream, (OutputStream)fileOutputStream);
        }
        catch (IOException e) {
            try {
                throw new UnitilsException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(resourceInputStream);
                IOUtils.closeQuietly(fileOutputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(resourceInputStream);
        IOUtils.closeQuietly(fileOutputStream);
    }

    public static URL getUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new UnitilsException("Unable to create URL for file " + file.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(File file, String string) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            IOUtils.write(string, (OutputStream)out, null);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly(out);
    }
}

