/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.lakewalker;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.lakewalker.DoubleConfigurer;
import org.openstreetmap.josm.plugins.lakewalker.IntConfigurer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class LakewalkerPreferences
implements PreferenceSetting {
    public static final String PREF_PYTHON = "lakewalker.python";
    public static final String PREF_MAX_SEG = "lakewalker.max_segs_in_way";
    public static final String PREF_MAX_NODES = "lakewalker.max_nodes";
    public static final String PREF_THRESHOLD = "lakewalker.threshold";
    public static final String PREF_EPSILON = "lakewalker.epsilon";
    protected JTextField python = new JTextField(10);
    protected IntConfigurer maxSegs = new IntConfigurer();
    protected IntConfigurer maxNodes = new IntConfigurer();
    protected IntConfigurer threshold = new IntConfigurer();
    protected DoubleConfigurer epsilon = new DoubleConfigurer();

    public void addGui(PreferenceDialog gui) {
        this.python.setToolTipText(I18n.tr((String)"Path to python executable."));
        this.maxSegs.setToolTipText(I18n.tr((String)"Maximum nuber of nodes allowed in one way."));
        this.maxNodes.setToolTipText(I18n.tr((String)"Maximum number of nodes to generate before bailing out (before simplifying lines)."));
        this.maxNodes.setToolTipText(I18n.tr((String)"Maximum gray value to accept as water (based on Landsat IR-1 data). Can be in the range 0-255."));
        this.epsilon.setToolTipText(I18n.tr((String)"Accuracy of Douglas-Peucker line simplification, measured in degrees. Lower values give more nodes, and more accurate lines. Defaults to 0.0003."));
        String description = I18n.tr((String)"An interlude to the Lakewalker Python module to trace water bodies on Landsat imagery.<br><br>Version: {0}", (Object[])new Object[]{"0.3"});
        JPanel prefPanel = gui.createPreferenceTab("lakewalker.png", I18n.tr((String)"Lakewalker Plugin Preferences"), description);
        this.buildPreferences(prefPanel);
        this.python.setText(Main.pref.get(PREF_PYTHON, "python.exe"));
        this.maxSegs.setValue(Main.pref.get(PREF_MAX_SEG, "250"));
        this.maxNodes.setValue(Main.pref.get(PREF_MAX_NODES, "50000"));
        this.threshold.setValue(Main.pref.get(PREF_THRESHOLD, "35"));
        this.epsilon.setValue(Main.pref.get(PREF_EPSILON, "0.0003"));
    }

    public void buildPreferences(JPanel prefPanel) {
        prefPanel.add((Component)new JLabel(I18n.tr((String)"Python executable")), GBC.std().insets(10, 5, 5, 0));
        prefPanel.add((Component)this.python, GBC.eol().insets(0, 5, 0, 0).fill(2));
        prefPanel.add((Component)new JLabel(I18n.tr((String)"Maximum number of segments per way")), GBC.std().insets(10, 5, 5, 0));
        prefPanel.add(this.maxSegs.getControls(), GBC.eol().insets(0, 5, 0, 0).fill(2));
        prefPanel.add((Component)new JLabel(I18n.tr((String)"Maximum number of nodes to trace")), GBC.std().insets(10, 5, 5, 0));
        prefPanel.add(this.maxNodes.getControls(), GBC.eol().insets(0, 5, 0, 0).fill(2));
        prefPanel.add((Component)new JLabel(I18n.tr((String)"Maximum gray value to count as water")), GBC.std().insets(10, 5, 5, 0));
        prefPanel.add(this.threshold.getControls(), GBC.eol().insets(0, 5, 0, 0).fill(2));
        prefPanel.add((Component)new JLabel(I18n.tr((String)"Line simplification accuracy, measured in degrees.")), GBC.std().insets(10, 5, 5, 0));
        prefPanel.add(this.epsilon.getControls(), GBC.eol().insets(0, 5, 0, 0).fill(2));
    }

    public void ok() {
        Main.pref.put(PREF_PYTHON, this.python.getText());
        Main.pref.put(PREF_MAX_SEG, this.maxSegs.getValueString());
        Main.pref.put(PREF_MAX_NODES, this.maxNodes.getValueString());
        Main.pref.put(PREF_THRESHOLD, this.threshold.getValueString());
        Main.pref.put(PREF_EPSILON, this.epsilon.getValueString());
    }
}

