/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.lakewalker;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Segment;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

class LakewalkerAction
extends JosmAction
implements MouseListener {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected Cursor oldCursor;
    protected List<Node> selectedNodes;

    public LakewalkerAction(String name) {
        super(name, "lakewalker-sml", I18n.tr((String)"Lake Walker."), 76, 3, true);
        this.name = name;
        this.setEnabled(true);
    }

    public void actionPerformed(ActionEvent e) {
        Main.map.mapView.setCursor(this.oldCursor);
        if (Main.map == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No data loaded."));
            return;
        }
        this.selectedNodes = new ArrayList<Node>();
        for (OsmPrimitive osm : Main.ds.getSelected()) {
            if (!(osm instanceof Node)) continue;
            Node node = (Node)osm;
            this.selectedNodes.add(node);
        }
        if (this.selectedNodes.isEmpty()) {
            this.oldCursor = Main.map.mapView.getCursor();
            Main.map.mapView.setCursor(ImageProvider.getCursor((String)"crosshair", (String)"lakewalker-sml"));
            Main.map.mapView.addMouseListener((MouseListener)this);
        } else {
            this.lakewalk(this.selectedNodes);
        }
    }

    protected void lakewalk(Point clickPoint) {
        LatLon pos = Main.map.mapView.getLatLon(clickPoint.x, clickPoint.y);
        File working_dir = new File(Main.pref.getPreferencesDir(), "plugins");
        working_dir = new File(working_dir, "Lakewalker");
        String target = String.valueOf(Main.pref.get("lakewalker.python")) + " lakewalker.py";
        LatLon topLeft = Main.map.mapView.getLatLon(0, 0);
        LatLon botRight = Main.map.mapView.getLatLon(Main.map.mapView.getWidth(), Main.map.mapView.getHeight());
        target = String.valueOf(target) + " --lat=" + pos.lat();
        target = String.valueOf(target) + " --lon=" + pos.lon();
        target = String.valueOf(target) + " --left=" + topLeft.lon();
        target = String.valueOf(target) + " --right=" + botRight.lon();
        target = String.valueOf(target) + " --top=" + topLeft.lat();
        target = String.valueOf(target) + " --bottom=" + botRight.lat();
        target = String.valueOf(target) + " --josm";
        LinkedList<AddCommand> commands = new LinkedList<AddCommand>();
        Way way = new Way();
        Node lastNode = null;
        Node firstNode = null;
        try {
            String line;
            Runtime rt = Runtime.getRuntime();
            System.out.println("dir: " + working_dir + ", target: " + target);
            Process p = rt.exec(target, null, working_dir);
            System.out.println("Just Run");
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader err = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            block8: while ((line = input.readLine()) != null) {
                System.out.println(line);
                char option = line.charAt(0);
                switch (option) {
                    case 'n': {
                        String[] tokens = line.split(" ");
                        try {
                            LatLon ll = new LatLon(Double.parseDouble(tokens[1]), Double.parseDouble(tokens[2]));
                            Node n = new Node(ll);
                            commands.add(new AddCommand((OsmPrimitive)n));
                            if (lastNode != null) {
                                Segment s = new Segment(lastNode, n);
                                commands.add(new AddCommand((OsmPrimitive)s));
                                way.segments.add(s);
                            } else {
                                firstNode = n;
                            }
                            lastNode = n;
                        }
                        catch (Exception ll) {}
                        continue block8;
                    }
                    case 'x': {
                        Segment s = new Segment(lastNode, firstNode);
                        commands.add(new AddCommand((OsmPrimitive)s));
                        way.segments.add(s);
                        commands.add(new AddCommand((OsmPrimitive)way));
                    }
                }
            }
            while ((line = err.readLine()) != null) {
                System.out.println(line);
            }
            input.close();
            p.destroy();
        }
        catch (Exception ex) {
            System.out.println("Exception caught: " + ex.getMessage());
        }
        if (!commands.isEmpty()) {
            Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Lakewalker trace"), commands));
            Main.ds.setSelected(new OsmPrimitive[]{way});
        }
    }

    protected void lakewalk(List nodes) {
    }

    public void mouseClicked(MouseEvent e) {
        Main.map.mapView.removeMouseListener((MouseListener)this);
        Main.map.mapView.setCursor(this.oldCursor);
        this.lakewalk(e.getPoint());
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

