/* Generated By:JavaCC: Do not edit this line. MapCSSParser.java */
package org.openstreetmap.josm.gui.mappaint.mapcss.parser;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.mapcss.Condition;
import org.openstreetmap.josm.gui.mappaint.mapcss.Condition.Context;
import org.openstreetmap.josm.gui.mappaint.mapcss.Expression;
import org.openstreetmap.josm.gui.mappaint.mapcss.Instruction;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSRule;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.gui.mappaint.mapcss.Expression.FunctionExpression;
import org.openstreetmap.josm.gui.mappaint.mapcss.Expression.LiteralExpression;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSException;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector.ChildOrParentSelector;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector.GeneralSelector;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector.LinkSelector;
import org.openstreetmap.josm.tools.Pair;

public class MapCSSParser implements MapCSSParserConstants {
    MapCSSStyleSource sheet;

/*************
 * Parser definitions
 *
 *                       rule
 *  _______________________|______________________________
 * |                                                      |
 *        selector                      declaration
 *  _________|___________________   _________|____________
 * |                             | |                      |
 *
 * way|z11-12[highway=residential] { color: red; width: 3 }
 *
 *    |_____||___________________|   |_________|
 *       |            |                   |
 *     zoom       condition          instruction
 *
 * more general:
 *
 * way|z13-[a=b][c=d]::subpart, way|z-3[u=v]:closed::subpart2 { p1 : val; p2 : val; }
 *
 * 'val' can be a literal, or an expression like "prop(width, default) + 0.8".
 *
 */
  final public int uint() throws ParseException {
    Token i;
    i = jj_consume_token(UINT);
               {if (true) return Integer.parseInt(i.image);}
    throw new Error("Missing return statement in function");
  }

  final public int int_() throws ParseException {
    int i;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUS:
      jj_consume_token(MINUS);
      i = uint();
                       {if (true) return -i;}
      break;
    case UINT:
      i = uint();
                                                 {if (true) return i;}
      break;
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public float ufloat() throws ParseException {
    Token f;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UFLOAT:
      f = jj_consume_token(UFLOAT);
      break;
    case UINT:
      f = jj_consume_token(UINT);
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return Float.parseFloat(f.image);}
    throw new Error("Missing return statement in function");
  }

  final public float float_() throws ParseException {
    float f;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUS:
      jj_consume_token(MINUS);
      f = ufloat();
                         {if (true) return -f;}
      break;
    case UINT:
    case UFLOAT:
      f = ufloat();
                                                     {if (true) return f;}
      break;
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String string() throws ParseException {
    Token t;
    t = jj_consume_token(STRING);
      {if (true) return t.image.substring(1, t.image.length() - 1).replace("\\\"", "\"").replace("\\\\", "\\");}
    throw new Error("Missing return statement in function");
  }

  final public String string_or_ident() throws ParseException {
    Token t;
    String s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENT:
      t = jj_consume_token(IDENT);
                {if (true) return t.image;}
      break;
    case STRING:
      s = string();
                                                 {if (true) return s;}
      break;
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String regex() throws ParseException {
    Token t;
    t = jj_consume_token(REGEX);
      {if (true) return t.image.substring(1, t.image.length() - 1);}
    throw new Error("Missing return statement in function");
  }

/**
 * white-space
 */
  final public void s() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case S:
      jj_consume_token(S);
      break;
    default:
      jj_la1[4] = jj_gen;
      ;
    }
  }

/**
 * mix of white-space and comments
 */
  final public void w() throws ParseException {
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
      case COMMENT_START:
        ;
        break;
      default:
        jj_la1[5] = jj_gen;
        break label_1;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        jj_consume_token(S);
        break;
      case COMMENT_START:
        jj_consume_token(COMMENT_START);
        jj_consume_token(COMMENT_END);
        break;
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
 * comma delimited list of floats (at least 2, all >= 0)
 */
  final public List<Float> float_array() throws ParseException {
    float f;
    List<Float> fs = new ArrayList<Float>();
    f = ufloat();
                 fs.add(f);
    label_2:
    while (true) {
      jj_consume_token(COMMA);
      s();
      f = ufloat();
                     fs.add(f);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[7] = jj_gen;
        break label_2;
      }
    }
        {if (true) return fs;}
    throw new Error("Missing return statement in function");
  }

/**
 * root
 */
  final public void sheet(MapCSSStyleSource sheet) throws ParseException {
    MapCSSRule r;
    Token com = null;
      this.sheet = sheet;
    w();
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
      case STAR:
        ;
        break;
      default:
        jj_la1[8] = jj_gen;
        break label_3;
      }
      try {
        /*            try {*/
                        r = rule();
                           if (r != null) { sheet.rules.add(r); }
        w();
      } catch (MapCSSException mex) {
            error_skipto(RBRACE, mex);
            w();
/*                throw new ParseException(mex.getMessage());*/
/*            }*/

      } catch (ParseException ex) {
            error_skipto(RBRACE, null);
            w();
      }
    }
    jj_consume_token(0);
  }

  final public MapCSSRule rule() throws ParseException {
    List<Selector> selectors = new ArrayList<Selector>();
    Selector sel;
    List<Instruction> decl;
    sel = child_selector();
                           selectors.add(sel);
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[9] = jj_gen;
        break label_4;
      }
      jj_consume_token(COMMA);
      w();
      sel = child_selector();
                               selectors.add(sel);
    }
    decl = declaration();
      {if (true) return new MapCSSRule(selectors, decl);}
    throw new Error("Missing return statement in function");
  }

  final public Selector child_selector() throws ParseException {
    boolean parentSelector = false;
    Condition c;
    List<Condition> conditions = new ArrayList<Condition>();
    Selector selLeft;
    LinkSelector selLink = null;
    Selector selRight = null;
    selLeft = selector();
    w();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case GREATER:
    case LESS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GREATER:
        jj_consume_token(GREATER);
                      parentSelector = false;
        break;
      case LESS:
        jj_consume_token(LESS);
                                                           parentSelector = true;
        break;
      default:
        jj_la1[10] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LSQUARE:
        case EXCLAMATION:
        case COLON:
          ;
          break;
        default:
          jj_la1[11] = jj_gen;
          break label_5;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LSQUARE:
          c = condition(Context.LINK);
          break;
        case EXCLAMATION:
        case COLON:
          c = pseudoclass(Context.LINK);
          break;
        default:
          jj_la1[12] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                                                                        conditions.add(c);
      }
          selLink = new LinkSelector(conditions);
      w();
      selRight = selector();
      w();
      break;
    default:
      jj_la1[13] = jj_gen;
      ;
    }
      {if (true) return selRight != null ? new ChildOrParentSelector(selLeft, selLink, selRight, parentSelector) : selLeft;}
    throw new Error("Missing return statement in function");
  }

  final public Selector selector() throws ParseException {
    Token base;
    Condition c;
    Pair<Integer, Integer> r = null;
    List<Condition> conditions = new ArrayList<Condition>();
    String sub = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENT:
      base = jj_consume_token(IDENT);
      break;
    case STAR:
      base = jj_consume_token(STAR);
      break;
    default:
      jj_la1[14] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PIPE_Z:
      r = zoom();
      break;
    default:
      jj_la1[15] = jj_gen;
      ;
    }
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LSQUARE:
      case EXCLAMATION:
      case COLON:
        ;
        break;
      default:
        jj_la1[16] = jj_gen;
        break label_6;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LSQUARE:
        c = condition(Context.PRIMITIVE);
        break;
      case EXCLAMATION:
      case COLON:
        c = pseudoclass(Context.PRIMITIVE);
        break;
      default:
        jj_la1[17] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                                                              conditions.add(c);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DCOLON:
      sub = subpart();
      break;
    default:
      jj_la1[18] = jj_gen;
      ;
    }
      {if (true) return new GeneralSelector(base.image, r, conditions, sub);}
    throw new Error("Missing return statement in function");
  }

  final public Pair<Integer, Integer> zoom() throws ParseException {
    Integer min = 0;
    Integer max = Integer.MAX_VALUE;
    jj_consume_token(PIPE_Z);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUS:
      jj_consume_token(MINUS);
      max = uint();
      break;
    case UINT:
      min = uint();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MINUS:
        jj_consume_token(MINUS);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UINT:
          max = uint();
          break;
        default:
          jj_la1[19] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[20] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return new Pair<Integer, Integer>(min, max);}
    throw new Error("Missing return statement in function");
  }

  final public Condition condition(Context context) throws ParseException {
    Condition c;
    Expression e;
    jj_consume_token(LSQUARE);
    s();
    if (jj_2_1(2147483647)) {
      c = simple_key_condition(context);
      s();
      jj_consume_token(RSQUARE);
                                                            {if (true) return c;}
    } else if (jj_2_2(2147483647)) {
      c = simple_key_value_condition(context);
      s();
      jj_consume_token(RSQUARE);
                                                                  {if (true) return c;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
      case UINT:
      case UFLOAT:
      case STRING:
      case HEXCOLOR:
      case LPAR:
      case EXCLAMATION:
      case PLUS:
      case MINUS:
        e = expression();
        jj_consume_token(RSQUARE);
                                       {if (true) return Condition.create(e, context);}
        break;
      default:
        jj_la1[22] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public String tag_key() throws ParseException {
    String s;
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING:
      s = string();
                     {if (true) return s;}
      break;
    case IDENT:
      t = jj_consume_token(IDENT);
                    s = t.image;
      label_7:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COLON:
          ;
          break;
        default:
          jj_la1[23] = jj_gen;
          break label_7;
        }
        jj_consume_token(COLON);
        t = jj_consume_token(IDENT);
                                                         s += ':' + t.image;
      }
                                                                                    {if (true) return s;}
      break;
    default:
      jj_la1[24] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Condition simple_key_condition(Context context) throws ParseException {
    boolean not = false;
    boolean yes = false;
    String key;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXCLAMATION:
      jj_consume_token(EXCLAMATION);
                      not = true;
      break;
    default:
      jj_la1[25] = jj_gen;
      ;
    }
    key = tag_key();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUESTION:
      jj_consume_token(QUESTION);
                   yes = true;
      break;
    default:
      jj_la1[26] = jj_gen;
      ;
    }
      {if (true) return Condition.create(key, not, yes, context);}
    throw new Error("Missing return statement in function");
  }

  final public Condition simple_key_value_condition(Context context) throws ParseException {
    String key;
    String val;
    float f;
    int i;
    Condition.Op op;
    key = tag_key();
    s();
    if (jj_2_4(2)) {
      jj_consume_token(EQUAL);
      jj_consume_token(TILDE);
                              op=Condition.Op.REGEX;
      s();
      val = regex();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STAR:
      case EQUAL:
      case EXCLAMATION:
      case TILDE:
      case DOLLAR:
      case CARET:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EXCLAMATION:
          jj_consume_token(EXCLAMATION);
          jj_consume_token(EQUAL);
                                            op=Condition.Op.NEQ;
          break;
        case EQUAL:
          jj_consume_token(EQUAL);
                              op=Condition.Op.EQ;
          break;
        case TILDE:
          jj_consume_token(TILDE);
          jj_consume_token(EQUAL);
                                      op=Condition.Op.ONE_OF;
          break;
        case CARET:
          jj_consume_token(CARET);
          jj_consume_token(EQUAL);
                                      op=Condition.Op.BEGINS_WITH;
          break;
        case DOLLAR:
          jj_consume_token(DOLLAR);
          jj_consume_token(EQUAL);
                                       op=Condition.Op.ENDS_WITH;
          break;
        case STAR:
          jj_consume_token(STAR);
          jj_consume_token(EQUAL);
                                     op=Condition.Op.CONTAINS;
          break;
        default:
          jj_la1[27] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        s();
        if (jj_2_3(2)) {
          i = int_();
                                   val=Integer.toString(i);
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case UINT:
          case UFLOAT:
          case MINUS:
            f = float_();
                                     val=Float.toString(f);
            break;
          case IDENT:
          case STRING:
            val = string_or_ident();
            break;
          default:
            jj_la1[28] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
      case GREATER_EQUAL:
      case LESS_EQUAL:
      case GREATER:
      case LESS:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case GREATER_EQUAL:
          jj_consume_token(GREATER_EQUAL);
                                      op=Condition.Op.GREATER_OR_EQUAL;
          break;
        case GREATER:
          jj_consume_token(GREATER);
                                op=Condition.Op.GREATER;
          break;
        case LESS_EQUAL:
          jj_consume_token(LESS_EQUAL);
                                   op=Condition.Op.LESS_OR_EQUAL;
          break;
        case LESS:
          jj_consume_token(LESS);
                             op=Condition.Op.LESS;
          break;
        default:
          jj_la1[29] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        s();
        f = float_();
                         val=Float.toString(f);
        break;
      default:
        jj_la1[30] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
      {if (true) return Condition.create(key, val, op, context);}
    throw new Error("Missing return statement in function");
  }

  final public Condition pseudoclass(Context context) throws ParseException {
    Token t;
    boolean not = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXCLAMATION:
      jj_consume_token(EXCLAMATION);
                      not = true;
      break;
    default:
      jj_la1[31] = jj_gen;
      ;
    }
    jj_consume_token(COLON);
    t = jj_consume_token(IDENT);
      {if (true) return Condition.create(t.image, not, context);}
    throw new Error("Missing return statement in function");
  }

  final public String subpart() throws ParseException {
    Token t;
    jj_consume_token(DCOLON);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENT:
      t = jj_consume_token(IDENT);
      break;
    case STAR:
      t = jj_consume_token(STAR);
      break;
    default:
      jj_la1[32] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return t.image;}
    throw new Error("Missing return statement in function");
  }

  final public List<Instruction> declaration() throws ParseException {
    List<Instruction> ins = new ArrayList<Instruction>();
    Instruction i;
    Token key;
    Object val;
    jj_consume_token(LBRACE);
    w();
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
        ;
        break;
      default:
        jj_la1[33] = jj_gen;
        break label_8;
      }
      key = jj_consume_token(IDENT);
      w();
      jj_consume_token(COLON);
      w();
      if (jj_2_5(2147483647)) {
        val = float_array();
                  ins.add(new Instruction.AssignmentInstruction(key.image, val));
        w();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case RBRACE:
          jj_consume_token(RBRACE);
                             {if (true) return ins;}
          break;
        case SEMICOLON:
          jj_consume_token(SEMICOLON);
          w();
          break;
        default:
          jj_la1[34] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else if (jj_2_6(2147483647)) {
        val = expression();
                  ins.add(new Instruction.AssignmentInstruction(key.image, val));
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case RBRACE:
          jj_consume_token(RBRACE);
                             {if (true) return ins;}
          break;
        case SEMICOLON:
          jj_consume_token(SEMICOLON);
          w();
          break;
        default:
          jj_la1[35] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        val = readRaw();
        w();
                                    ins.add(new Instruction.AssignmentInstruction(key.image, val));
      }
    }
    jj_consume_token(RBRACE);
      {if (true) return ins;}
    throw new Error("Missing return statement in function");
  }

  final public Expression expression() throws ParseException {
    List<Expression> args = new ArrayList<Expression>();
    Expression e;
    String op = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXCLAMATION:
      jj_consume_token(EXCLAMATION);
                        op = "not";
      w();
      e = primary();
                                                        args.add(e);
      w();
      break;
    case MINUS:
      jj_consume_token(MINUS);
                  op = "minus";
      w();
      e = primary();
                                                    args.add(e);
      w();
      break;
    case IDENT:
    case UINT:
    case UFLOAT:
    case STRING:
    case HEXCOLOR:
    case LPAR:
    case PLUS:
      e = primary();
                          args.add(e);
      w();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STAR:
      case SLASH:
      case GREATER_EQUAL:
      case LESS_EQUAL:
      case GREATER:
      case LESS:
      case EQUAL:
      case PIPE:
      case PLUS:
      case MINUS:
      case AMPERSAND:
      case QUESTION:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PLUS:
          label_9:
          while (true) {
            jj_consume_token(PLUS);
                               op = "plus";
            w();
            e = primary();
                                                                args.add(e);
            w();
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case PLUS:
              ;
              break;
            default:
              jj_la1[36] = jj_gen;
              break label_9;
            }
          }
          break;
        case STAR:
          label_10:
          while (true) {
            jj_consume_token(STAR);
                               op = "times";
            w();
            e = primary();
                                                                 args.add(e);
            w();
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case STAR:
              ;
              break;
            default:
              jj_la1[37] = jj_gen;
              break label_10;
            }
          }
          break;
        case MINUS:
          label_11:
          while (true) {
            jj_consume_token(MINUS);
                                op = "minus";
            w();
            e = primary();
                                                                  args.add(e);
            w();
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case MINUS:
              ;
              break;
            default:
              jj_la1[38] = jj_gen;
              break label_11;
            }
          }
          break;
        case SLASH:
          label_12:
          while (true) {
            jj_consume_token(SLASH);
                                op = "divided_by";
            w();
            e = primary();
                                                                       args.add(e);
            w();
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case SLASH:
              ;
              break;
            default:
              jj_la1[39] = jj_gen;
              break label_12;
            }
          }
          break;
        case GREATER_EQUAL:
          jj_consume_token(GREATER_EQUAL);
                                      op = "greater_equal";
          w();
          e = primary();
                                                                                args.add(e);
          w();
          break;
        case LESS_EQUAL:
          jj_consume_token(LESS_EQUAL);
                                   op = "less_equal";
          w();
          e = primary();
                                                                          args.add(e);
          w();
          break;
        case GREATER:
          jj_consume_token(GREATER);
                                op = "greater";
          w();
          e = primary();
                                                                    args.add(e);
          w();
          break;
        case EQUAL:
          jj_consume_token(EQUAL);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case EQUAL:
            jj_consume_token(EQUAL);
            break;
          default:
            jj_la1[40] = jj_gen;
            ;
          }
                                           op = "equal";
          w();
          e = primary();
                                                                             args.add(e);
          w();
          break;
        case LESS:
          jj_consume_token(LESS);
                             op = "less";
          w();
          e = primary();
                                                              args.add(e);
          w();
          break;
        case AMPERSAND:
          jj_consume_token(AMPERSAND);
          jj_consume_token(AMPERSAND);
                                              op = "and";
          w();
          e = primary();
                                                                              args.add(e);
          w();
          break;
        case PIPE:
          jj_consume_token(PIPE);
          jj_consume_token(PIPE);
                                    op = "or";
          w();
          e = primary();
                                                                   args.add(e);
          w();
          break;
        case QUESTION:
          jj_consume_token(QUESTION);
                                 op = "cond";
          w();
          e = primary();
                                                                  args.add(e);
          w();
          jj_consume_token(COLON);
          w();
          e = primary();
                                                                                                               args.add(e);
          w();
          break;
        default:
          jj_la1[41] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[42] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[43] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        if (op == null)
            {if (true) return args.get(0);}
        {if (true) return new FunctionExpression(op, args);}
    throw new Error("Missing return statement in function");
  }

  final public Expression primary() throws ParseException {
    Expression nested;
    FunctionExpression fn;
    Object lit;
    if (jj_2_7(3)) {
      // both function and identifier start with an identifier (+ optional whitespace)
              fn = function();
                        {if (true) return fn;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
      case UINT:
      case UFLOAT:
      case STRING:
      case HEXCOLOR:
      case PLUS:
        lit = literal();
                        {if (true) return new LiteralExpression(lit);}
        break;
      case LPAR:
        jj_consume_token(LPAR);
        w();
        nested = expression();
        jj_consume_token(RPAR);
                                                {if (true) return nested;}
        break;
      default:
        jj_la1[44] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public FunctionExpression function() throws ParseException {
    Token tmp;
    Expression arg;
    String name;
    List<Expression> args = new ArrayList<Expression>();
    tmp = jj_consume_token(IDENT);
                  name = tmp.image;
    w();
    jj_consume_token(LPAR);
    w();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENT:
    case UINT:
    case UFLOAT:
    case STRING:
    case HEXCOLOR:
    case LPAR:
    case EXCLAMATION:
    case PLUS:
    case MINUS:
      arg = expression();
                           args.add(arg);
      label_13:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[45] = jj_gen;
          break label_13;
        }
        jj_consume_token(COMMA);
        w();
        arg = expression();
                                         args.add(arg);
      }
      break;
    default:
      jj_la1[46] = jj_gen;
      ;
    }
    jj_consume_token(RPAR);
      {if (true) return new FunctionExpression(name, args);}
    throw new Error("Missing return statement in function");
  }

  final public Object literal() throws ParseException {
    String val;
    Token t;
    float f;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENT:
      t = jj_consume_token(IDENT);
                    {if (true) return new Keyword(t.image);}
      break;
    case STRING:
      val = string();
                       {if (true) return val;}
      break;
    case PLUS:
      jj_consume_token(PLUS);
      f = ufloat();
                            {if (true) return new Instruction.RelativeFloat(f);}
      break;
    case UINT:
    case UFLOAT:
      f = ufloat();
                     {if (true) return f;}
      break;
    case HEXCOLOR:
      t = jj_consume_token(HEXCOLOR);
                String clr = t.image.substring(1);
                if (clr.length() == 3) {
                    clr = new String(new char[] {clr.charAt(0),clr.charAt(0),clr.charAt(1),clr.charAt(1),clr.charAt(2),clr.charAt(2)});
                }
                if (clr.length() != 6)
                    {if (true) throw new AssertionError();}
                {if (true) return new Color(Integer.parseInt(clr, 16));}
      break;
    default:
      jj_la1[47] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  void error_skipto(int kind, MapCSSException me) throws ParseException {
    if (token.kind == EOF)
        throw new ParseException("Reached end of file while parsing");

    Exception e = null;
    ParseException pe = generateParseException();

    if (me != null) {
        me.setLine(pe.currentToken.next.beginLine);
        me.setColumn(pe.currentToken.next.beginColumn);
        e = me;
    } else {
        e = new ParseException(pe.getMessage()); // prevent memory leak
    }

    System.err.println("Skipping to the next rule, because of an error:");
    System.err.println(e);
    if (sheet != null) {
        sheet.logError(e);
    }
    Token t;
    do {
        t = getNextToken();
    } while (t.kind != kind && t.kind != EOF);
    if (t.kind == EOF)
        throw new ParseException("Reached end of file while parsing");
  }

/**
 * read everything to the next semicolon
 */
  String readRaw() throws ParseException {
    Token t;
    StringBuilder s = new StringBuilder();
    while (true) {
        t = getNextToken();
        if ((t.kind == S || t.kind == STRING || t.kind == UNEXPECTED_CHAR) &&
                t.image.contains("\n")) {
            ParseException e = new ParseException(String.format("Warning: end of line while reading an unquoted string at line %s column %s.", t.beginLine, t.beginColumn));
            System.err.println(e);
            if (sheet != null) {
                sheet.logError(e);
            }
        }
        if (t.kind == SEMICOLON || t.kind == EOF)
            break;
        s.append(t.image);
    }
    if (t.kind == EOF)
        throw new ParseException("Reached end of file while parsing");
    return s.toString();
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_3R_25() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_39()) {
    jj_scanpos = xsp;
    if (jj_3R_40()) {
    jj_scanpos = xsp;
    if (jj_3R_41()) {
    jj_scanpos = xsp;
    if (jj_3R_42()) {
    jj_scanpos = xsp;
    if (jj_3R_43()) {
    jj_scanpos = xsp;
    if (jj_3R_44()) return true;
    }
    }
    }
    }
    }
    if (jj_3R_15()) return true;
    xsp = jj_scanpos;
    if (jj_3_3()) {
    jj_scanpos = xsp;
    if (jj_3R_45()) {
    jj_scanpos = xsp;
    if (jj_3R_46()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_15() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(9)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_60() {
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_57() {
    if (jj_scan_token(COLON)) return true;
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3_4() {
    if (jj_scan_token(EQUAL)) return true;
    if (jj_scan_token(TILDE)) return true;
    if (jj_3R_15()) return true;
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3R_86() {
    if (jj_scan_token(HEXCOLOR)) return true;
    return false;
  }

  private boolean jj_3R_85() {
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_84() {
    if (jj_scan_token(PLUS)) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_38() {
    if (jj_scan_token(REGEX)) return true;
    return false;
  }

  private boolean jj_3R_16() {
    if (jj_3R_23()) return true;
    if (jj_3R_15()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_4()) {
    jj_scanpos = xsp;
    if (jj_3R_25()) {
    jj_scanpos = xsp;
    if (jj_3R_26()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_83() {
    if (jj_3R_56()) return true;
    return false;
  }

  private boolean jj_3R_82() {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_77() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_82()) {
    jj_scanpos = xsp;
    if (jj_3R_83()) {
    jj_scanpos = xsp;
    if (jj_3R_84()) {
    jj_scanpos = xsp;
    if (jj_3R_85()) {
    jj_scanpos = xsp;
    if (jj_3R_86()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_58() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_75()) {
    jj_scanpos = xsp;
    if (jj_3R_76()) return true;
    }
    return false;
  }

  private boolean jj_3R_75() {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_28() {
    if (jj_3R_52()) return true;
    return false;
  }

  private boolean jj_3R_24() {
    if (jj_scan_token(QUESTION)) return true;
    return false;
  }

  private boolean jj_3R_22() {
    if (jj_scan_token(EXCLAMATION)) return true;
    return false;
  }

  private boolean jj_3R_87() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_19()) return true;
    if (jj_3R_20()) return true;
    return false;
  }

  private boolean jj_3R_14() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_22()) jj_scanpos = xsp;
    if (jj_3R_23()) return true;
    xsp = jj_scanpos;
    if (jj_3R_24()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_56() {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3R_35() {
    if (jj_3R_20()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_87()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_37() {
    if (jj_scan_token(IDENT)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_57()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_36() {
    if (jj_3R_56()) return true;
    return false;
  }

  private boolean jj_3R_23() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_36()) {
    jj_scanpos = xsp;
    if (jj_3R_37()) return true;
    }
    return false;
  }

  private boolean jj_3R_21() {
    if (jj_scan_token(IDENT)) return true;
    if (jj_3R_19()) return true;
    if (jj_scan_token(LPAR)) return true;
    if (jj_3R_19()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_35()) jj_scanpos = xsp;
    if (jj_scan_token(RPAR)) return true;
    return false;
  }

  private boolean jj_3R_51() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_59()) {
    jj_scanpos = xsp;
    if (jj_3R_60()) return true;
    }
    return false;
  }

  private boolean jj_3R_59() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3_2() {
    if (jj_3R_16()) return true;
    if (jj_3R_15()) return true;
    if (jj_scan_token(RSQUARE)) return true;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_14()) return true;
    if (jj_3R_15()) return true;
    if (jj_scan_token(RSQUARE)) return true;
    return false;
  }

  private boolean jj_3R_62() {
    if (jj_scan_token(LPAR)) return true;
    if (jj_3R_19()) return true;
    if (jj_3R_20()) return true;
    if (jj_scan_token(RPAR)) return true;
    return false;
  }

  private boolean jj_3R_61() {
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_29() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(3)) {
    jj_scanpos = xsp;
    if (jj_scan_token(2)) return true;
    }
    return false;
  }

  private boolean jj_3_7() {
    if (jj_3R_21()) return true;
    return false;
  }

  private boolean jj_3R_54() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_7()) {
    jj_scanpos = xsp;
    if (jj_3R_61()) {
    jj_scanpos = xsp;
    if (jj_3R_62()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_27() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_3R_52()) return true;
    return false;
  }

  private boolean jj_3R_17() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_27()) {
    jj_scanpos = xsp;
    if (jj_3R_28()) return true;
    }
    return false;
  }

  private boolean jj_3R_74() {
    if (jj_scan_token(QUESTION)) return true;
    if (jj_3R_19()) return true;
    if (jj_3R_54()) return true;
    if (jj_3R_19()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_19()) return true;
    if (jj_3R_54()) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_73() {
    if (jj_scan_token(PIPE)) return true;
    if (jj_scan_token(PIPE)) return true;
    if (jj_3R_19()) return true;
    if (jj_3R_54()) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_72() {
    if (jj_scan_token(AMPERSAND)) return true;
    if (jj_scan_token(AMPERSAND)) return true;
    if (jj_3R_19()) return true;
    if (jj_3R_54()) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_71() {
    if (jj_scan_token(LESS)) return true;
    if (jj_3R_19()) return true;
    if (jj_3R_54()) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_52() {
    if (jj_scan_token(UINT)) return true;
    return false;
  }

  private boolean jj_3R_70() {
    if (jj_scan_token(EQUAL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(22)) jj_scanpos = xsp;
    if (jj_3R_19()) return true;
    if (jj_3R_54()) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_69() {
    if (jj_scan_token(GREATER)) return true;
    if (jj_3R_19()) return true;
    if (jj_3R_54()) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_68() {
    if (jj_scan_token(LESS_EQUAL)) return true;
    if (jj_3R_19()) return true;
    if (jj_3R_54()) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_81() {
    if (jj_scan_token(SLASH)) return true;
    if (jj_3R_19()) return true;
    if (jj_3R_54()) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_67() {
    if (jj_scan_token(GREATER_EQUAL)) return true;
    if (jj_3R_19()) return true;
    if (jj_3R_54()) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_80() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_3R_19()) return true;
    if (jj_3R_54()) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_66() {
    Token xsp;
    if (jj_3R_81()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_81()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_79() {
    if (jj_scan_token(STAR)) return true;
    if (jj_3R_19()) return true;
    if (jj_3R_54()) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_65() {
    Token xsp;
    if (jj_3R_80()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_80()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_78() {
    if (jj_scan_token(PLUS)) return true;
    if (jj_3R_19()) return true;
    if (jj_3R_54()) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_64() {
    Token xsp;
    if (jj_3R_79()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_79()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_55() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_63()) {
    jj_scanpos = xsp;
    if (jj_3R_64()) {
    jj_scanpos = xsp;
    if (jj_3R_65()) {
    jj_scanpos = xsp;
    if (jj_3R_66()) {
    jj_scanpos = xsp;
    if (jj_3R_67()) {
    jj_scanpos = xsp;
    if (jj_3R_68()) {
    jj_scanpos = xsp;
    if (jj_3R_69()) {
    jj_scanpos = xsp;
    if (jj_3R_70()) {
    jj_scanpos = xsp;
    if (jj_3R_71()) {
    jj_scanpos = xsp;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) {
    jj_scanpos = xsp;
    if (jj_3R_74()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_63() {
    Token xsp;
    if (jj_3R_78()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_78()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_34() {
    if (jj_3R_54()) return true;
    if (jj_3R_19()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_55()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_33() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_3R_19()) return true;
    if (jj_3R_54()) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_32() {
    if (jj_scan_token(EXCLAMATION)) return true;
    if (jj_3R_19()) return true;
    if (jj_3R_54()) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3_6() {
    if (jj_3R_20()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) return true;
    }
    return false;
  }

  private boolean jj_3R_20() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_32()) {
    jj_scanpos = xsp;
    if (jj_3R_33()) {
    jj_scanpos = xsp;
    if (jj_3R_34()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_5() {
    if (jj_3R_18()) return true;
    if (jj_3R_19()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) return true;
    }
    return false;
  }

  private boolean jj_3R_50() {
    if (jj_scan_token(LESS)) return true;
    return false;
  }

  private boolean jj_3R_49() {
    if (jj_scan_token(LESS_EQUAL)) return true;
    return false;
  }

  private boolean jj_3R_48() {
    if (jj_scan_token(GREATER)) return true;
    return false;
  }

  private boolean jj_3R_46() {
    if (jj_3R_58()) return true;
    return false;
  }

  private boolean jj_3R_47() {
    if (jj_scan_token(GREATER_EQUAL)) return true;
    return false;
  }

  private boolean jj_3R_45() {
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_30() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_15()) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_26() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_47()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) {
    jj_scanpos = xsp;
    if (jj_3R_49()) {
    jj_scanpos = xsp;
    if (jj_3R_50()) return true;
    }
    }
    }
    if (jj_3R_15()) return true;
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_18() {
    if (jj_3R_29()) return true;
    Token xsp;
    if (jj_3R_30()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_30()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_3() {
    if (jj_3R_17()) return true;
    return false;
  }

  private boolean jj_3R_44() {
    if (jj_scan_token(STAR)) return true;
    if (jj_scan_token(EQUAL)) return true;
    return false;
  }

  private boolean jj_3R_53() {
    if (jj_scan_token(COMMENT_START)) return true;
    if (jj_scan_token(COMMENT_END)) return true;
    return false;
  }

  private boolean jj_3R_43() {
    if (jj_scan_token(DOLLAR)) return true;
    if (jj_scan_token(EQUAL)) return true;
    return false;
  }

  private boolean jj_3R_42() {
    if (jj_scan_token(CARET)) return true;
    if (jj_scan_token(EQUAL)) return true;
    return false;
  }

  private boolean jj_3R_41() {
    if (jj_scan_token(TILDE)) return true;
    if (jj_scan_token(EQUAL)) return true;
    return false;
  }

  private boolean jj_3R_76() {
    if (jj_3R_56()) return true;
    return false;
  }

  private boolean jj_3R_31() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_3R_53()) return true;
    }
    return false;
  }

  private boolean jj_3R_40() {
    if (jj_scan_token(EQUAL)) return true;
    return false;
  }

  private boolean jj_3R_19() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_31()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_39() {
    if (jj_scan_token(EXCLAMATION)) return true;
    if (jj_scan_token(EQUAL)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public MapCSSParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[48];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x4,0xc,0xc,0x12,0x200,0x200,0x200,0x10000000,0x402,0x10000000,0x300000,0x2804000,0x2804000,0x300000,0x402,0x40000000,0x2804000,0x2804000,0x4000000,0x4,0x0,0x4,0x8081011e,0x2000000,0x12,0x800000,0x0,0x1c00400,0x1e,0x3c0000,0x1fc0400,0x800000,0x402,0x2,0x8002000,0x8002000,0x80000000,0x400,0x0,0x800,0x400000,0xa07c0c00,0xa07c0c00,0x8081011e,0x8001011e,0x10000000,0x8081011e,0x8000011e,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x1,0x0,0x1,0x0,0x0,0x20,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x1,0x1,0x0,0x0,0x0,0x4,0x18,0x1,0x0,0x18,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x7,0x7,0x1,0x0,0x0,0x1,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[7];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public MapCSSParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public MapCSSParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new MapCSSParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 48; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 48; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public MapCSSParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new MapCSSParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 48; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 48; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public MapCSSParser(MapCSSParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 48; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(MapCSSParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 48; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List jj_expentries = new java.util.ArrayList();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[41];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 48; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 41; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 7; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
