/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.ywms;

import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static Plugin getPlugin(Class<? extends Plugin> clazz) {
        String classname = clazz.getName();
        for (PluginProxy plugin : Main.plugins) {
            if (!plugin.info.className.equals(classname)) continue;
            return (Plugin)plugin.plugin;
        }
        return null;
    }

    public static String getPluginDir() {
        return Main.pref.getPreferencesDir() + "plugins/ywms/";
    }

    public static JButton createButton(String name, String icon, String tooltip, ActionListener action) {
        JButton button = new JButton(I18n.tr((String)name), ImageProvider.get((String)icon));
        button.setActionCommand(name);
        button.addActionListener(action);
        button.setToolTipText(I18n.tr((String)tooltip));
        button.putClientProperty("help", "Dialog/SelectionList/" + name);
        return button;
    }

    public static Version getVersion() {
        String revision;
        try {
            revision = Util.loadFile(Util.class.getResource("/resources/REVISION"));
        }
        catch (Exception e) {
            return null;
        }
        Pattern versionPattern = Pattern.compile(".*?Revision: ([0-9]*).*", 34);
        Matcher match = versionPattern.matcher(revision);
        String version = match.matches() ? match.group(1) : "UNKNOWN";
        Pattern timePattern = Pattern.compile(".*?Last Changed Date: ([^\n]*).*", 34);
        match = timePattern.matcher(revision);
        String time = match.matches() ? match.group(1) : "UNKNOWN";
        return new Version(version, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadFile(URL resource) throws IOException {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(resource.openStream()));
            StringBuilder sb = new StringBuilder();
            String line = in.readLine();
            while (line != null) {
                sb.append(line);
                sb.append('\n');
                line = in.readLine();
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File mirror(URL url, String destDir, long maxTime) {
        File destDirFile;
        if (url.getProtocol().equals("file")) {
            return new File(url.toString());
        }
        String localPath = Main.pref.get("tests.mirror." + url);
        File oldFile = null;
        if (localPath != null && localPath.length() > 0) {
            StringTokenizer st = new StringTokenizer(localPath, ";");
            long checkDate = Long.parseLong(st.nextToken());
            localPath = st.nextToken();
            oldFile = new File(localPath);
            long l = maxTime = maxTime <= 0L ? 604800000L : maxTime * 1000L;
            if (System.currentTimeMillis() - checkDate < maxTime && oldFile.exists()) {
                return oldFile;
            }
        }
        if (!(destDirFile = new File(destDir)).exists()) {
            destDirFile.mkdirs();
        }
        localPath = destDir + System.currentTimeMillis() + "-" + new File(url.getPath()).getName();
        FilterOutputStream bos = null;
        BufferedInputStream bis = null;
        try {
            int length;
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(5000);
            bis = new BufferedInputStream(conn.getInputStream());
            bos = new BufferedOutputStream(new FileOutputStream(localPath));
            byte[] buffer = new byte[4096];
            while ((length = bis.read(buffer)) > -1) {
                ((BufferedOutputStream)bos).write(buffer, 0, length);
            }
        }
        catch (IOException ioe) {
            if (oldFile != null) {
                File file = oldFile;
                return file;
            }
            File file = null;
            return file;
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Main.pref.put("tests.mirror." + url, System.currentTimeMillis() + ";" + localPath);
        if (oldFile != null) {
            oldFile.delete();
        }
        return new File(localPath);
    }

    public static void copy(String from, String to) throws FileNotFoundException, IOException {
        File pluginDir = new File(Util.getPluginDir());
        if (!pluginDir.exists()) {
            pluginDir.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(Util.getPluginDir() + to);
        InputStream in = Util.class.getResourceAsStream(from);
        byte[] buffer = new byte[8192];
        int len = in.read(buffer);
        while (len > 0) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
        in.close();
        out.close();
    }

    public static class Version {
        public String revision;
        public String time;

        public Version(String revision, String time) {
            this.revision = revision;
            this.time = time;
        }
    }
}

