/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.ywms;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.ywms.GeckoSupport;
import org.openstreetmap.josm.plugins.ywms.Util;
import org.openstreetmap.josm.plugins.ywms.YWMSPlugin;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class YWMSPreferenceSetting
implements PreferenceSetting {
    public static final String WMS_NAME = "Yahoo";
    public static final String WMS_URL_PARAMS = "/ymap?request=GetMap&format=image/jpeg";
    private JTextField firefox = new JTextField(10);
    private JTextField port = new JTextField(10);
    private JTextField profile = new JTextField(10);

    public void addGui(PreferenceDialog gui) {
        this.firefox.setToolTipText(I18n.tr((String)"<html>Path to firefox executable.<br>The Firefox profile used in this plugin <b>must</b> be configured with the javascript 'dump' method,<br>that can be activated with the property 'browser.dom.window.dump.enabled=true' in the about:config page.</html>"));
        this.port.setToolTipText(I18n.tr((String)"<html>The port that the server will use to listen WMS requests<br>The WMS plugin need to be configured to use this port"));
        this.profile.setToolTipText(I18n.tr((String)"<html>Name of the profile.<br>This profile is used to avoid nag firefox screens asking you to resume failed sessions.<br>Just set the selected profile as not default in the profile selection window and configure to not ask<br>about failed sessions with 'browser.sessionstore.resume_from_crash=false' in the about:config page"));
        Util.Version ver = Util.getVersion();
        String description = I18n.tr((String)"A WMS server for Yahoo imagery based on Firefox.");
        if (ver != null) {
            description = description + "<br><br>" + I18n.tr((String)"Version: {0}<br>Last change at {1}", (Object[])new Object[]{ver.revision, ver.time});
        }
        JPanel ywms = gui.createPreferenceTab("yahoo.gif", I18n.tr((String)"Yahoo! WMS server"), description + I18n.tr((String)"Settings for the Yahoo! imagery server."));
        ywms.add((Component)new JLabel(I18n.tr((String)"YWMS options")), GBC.eol().insets(0, 5, 0, 0));
        ywms.add((Component)new JLabel(I18n.tr((String)"Firefox executable")), GBC.std().insets(10, 5, 5, 0));
        ywms.add((Component)this.firefox, GBC.eol().insets(0, 5, 0, 0).fill(2));
        ywms.add((Component)new JLabel(I18n.tr((String)"Firefox profile")), GBC.std().insets(10, 5, 5, 0));
        ywms.add((Component)this.profile, GBC.std().insets(0, 5, 0, 0).fill(2));
        JButton create = new JButton(I18n.tr((String)"Create"));
        ywms.add((Component)create, GBC.eol().insets(5, 0, 0, 0).fill(13));
        create.addActionListener(new ProfileCreatorActionListener());
        ywms.add((Component)new JLabel(I18n.tr((String)"Server port")), GBC.std().insets(10, 5, 5, 0));
        ywms.add((Component)this.port, GBC.eol().insets(0, 5, 0, 0).fill(2));
        ywms.add(Box.createVerticalGlue(), GBC.eol().fill(3));
        WMSConfigurationActionListener configurationActionListener = new WMSConfigurationActionListener();
        this.port.addActionListener(configurationActionListener);
        this.port.addFocusListener(configurationActionListener);
        this.firefox.setText(Main.pref.get("ywms.firefox", "firefox"));
        this.profile.setText(Main.pref.get("ywms.profile"));
        this.port.setText(Main.pref.get("ywms.port", "8000"));
    }

    public void ok() {
        Main.pref.put("ywms.firefox", this.firefox.getText());
        Main.pref.put("ywms.profile", this.profile.getText());
        String oldPort = Main.pref.get("ywms.port");
        Main.pref.put("ywms.port", this.port.getText());
        if (!oldPort.equals(this.port.getText())) {
            YWMSPlugin plugin = (YWMSPlugin)Util.getPlugin(YWMSPlugin.class);
            plugin.restartServer();
        }
    }

    private void configureWMSPluginPreferences() {
        try {
            Object wmsSetting = null;
            for (PreferenceSetting setting : PreferenceDialog.settings) {
                if (setting.getClass().getName() != "wmsplugin.WMSPreferenceEditor") continue;
                wmsSetting = setting;
                break;
            }
            if (wmsSetting == null) {
                return;
            }
            int portNumber = Integer.parseInt(this.port.getText());
            String strUrl = (String)wmsSetting.getClass().getMethod("getServerUrl", String.class).invoke(wmsSetting, WMS_NAME);
            if (strUrl == null) {
                strUrl = new URL("http", "localhost", portNumber, WMS_URL_PARAMS).toString();
            } else {
                URL oldUrl = new URL(strUrl);
                strUrl = new URL("http", oldUrl.getHost(), portNumber, WMS_URL_PARAMS).toString();
            }
            wmsSetting.getClass().getMethod("setServerUrl", String.class, String.class).invoke(wmsSetting, WMS_NAME, strUrl);
        }
        catch (NoSuchMethodException e) {
        }
        catch (NumberFormatException nfe) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final class ProfileCreatorActionListener
    implements ActionListener {
        private ProfileCreatorActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String profileName = YWMSPreferenceSetting.this.profile.getText();
            if (profileName == null || profileName.length() == 0) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please name the profile you want to create."));
                return;
            }
            try {
                PleaseWaitRunnable createProfileTask = new PleaseWaitRunnable(I18n.tr((String)"Creating profile")){
                    Process process;
                    {
                        this.process = null;
                    }

                    protected void realRun() throws IOException {
                        this.process = GeckoSupport.createProfile(YWMSPreferenceSetting.this.firefox.getText(), YWMSPreferenceSetting.this.profile.getText());
                        try {
                            this.process.waitFor();
                        }
                        catch (InterruptedException e) {
                            IOException ioe = new IOException();
                            ioe.initCause(e);
                            throw ioe;
                        }
                        String configFile = new File(Util.getPluginDir(), "config.html").toURL().toString();
                        GeckoSupport.browse(YWMSPreferenceSetting.this.firefox.getText(), YWMSPreferenceSetting.this.profile.getText(), configFile, false);
                        YWMSPreferenceSetting.this.configureWMSPluginPreferences();
                    }

                    protected void finish() {
                    }

                    protected void cancel() {
                        if (this.process != null) {
                            this.process.destroy();
                        }
                    }
                };
                Main.worker.execute((Runnable)createProfileTask);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final class WMSConfigurationActionListener
    implements ActionListener,
    FocusListener {
        boolean alreadyHandled = false;

        private WMSConfigurationActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.alreadyHandled) {
                YWMSPreferenceSetting.this.configureWMSPluginPreferences();
            }
            this.alreadyHandled = true;
        }

        public void focusGained(FocusEvent e) {
            this.alreadyHandled = false;
        }

        public void focusLost(FocusEvent e) {
            if (!this.alreadyHandled) {
                YWMSPreferenceSetting.this.configureWMSPluginPreferences();
            }
            this.alreadyHandled = true;
        }
    }
}

