/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.ywms;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.RenderedImage;
import java.awt.image.ReplicateScaleFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.plugins.ywms.GeckoSupport;
import org.openstreetmap.josm.plugins.ywms.ImageLoaderException;
import org.openstreetmap.josm.plugins.ywms.PPM;
import org.openstreetmap.josm.plugins.ywms.Util;

public class ImageLoader {
    public static final String GECKO_DEBUG_LINE = "GECKO: PAINT FORCED AFTER ONLOAD:";
    private URL yahooUrl;
    double[] orig_bbox = null;
    int width = -1;
    int height = -1;
    int final_width = -1;
    int final_height = -1;
    Image image;
    List<String> firefoxFiles = new ArrayList<String>();
    private static final Pattern BBOX_RE = Pattern.compile("bbox=([+-]?\\d+\\.\\d+),([+-]?\\d+\\.\\d+),([+-]?\\d+\\.\\d+),([+-]?\\d+\\.\\d+)", 2);

    public ImageLoader(String wmsUrl) throws ImageLoaderException {
        System.out.println("YWMS::Requested WMS URL: " + wmsUrl);
        try {
            URL request = new URL("file:///page" + wmsUrl);
            String query = request.getQuery().toLowerCase();
            this.yahooUrl = new File(Util.getPluginDir(), "ymap.html").toURI().toURL();
            this.yahooUrl = new URL(this.yahooUrl.toExternalForm() + "?" + query);
            StringTokenizer st = new StringTokenizer(query, "&");
            while (st.hasMoreTokens()) {
                String param = st.nextToken();
                if (param.startsWith("width=")) {
                    this.width = Integer.parseInt(param.substring("width=".length()));
                    continue;
                }
                if (param.startsWith("height=")) {
                    this.height = Integer.parseInt(param.substring("height=".length()));
                    continue;
                }
                if (!param.startsWith("bbox=")) continue;
                this.orig_bbox = this.getBbox(param);
            }
            if (this.width == -1 || this.height == -1) {
                throw new ImageLoaderException("Can't find dimensions");
            }
            this.load();
        }
        catch (MalformedURLException e) {
            throw new ImageLoaderException(e);
        }
    }

    private void load() throws ImageLoaderException {
        Process browser = null;
        try {
            browser = GeckoSupport.browse(this.yahooUrl.toString(), true);
            File imageFilePpm = null;
            BufferedReader in = new BufferedReader(new InputStreamReader(browser.getInputStream()));
            String line = in.readLine();
            while (line != null) {
                block21: {
                    System.out.println("YWMS::" + line);
                    if (line.startsWith("new_width=")) {
                        this.final_width = (int)Math.round(Double.parseDouble(line.substring(10)));
                    } else if (line.startsWith("new_height=")) {
                        this.final_height = (int)Math.round(Double.parseDouble(line.substring(11)));
                    } else {
                        if (line.startsWith(GECKO_DEBUG_LINE)) {
                            StringTokenizer st = new StringTokenizer(line);
                            for (int i = 0; i < 5; ++i) {
                                st.nextToken();
                            }
                            String url = st.nextToken();
                            String file = st.nextToken();
                            this.firefoxFiles.add(file);
                            try {
                                URL browserUrl = new URL(url);
                                if (browserUrl.sameFile(this.yahooUrl)) {
                                    String status = st.nextToken();
                                    if (!"(OK)".equals(status)) {
                                        throw new ImageLoaderException("Firefox couldn't load image");
                                    }
                                    imageFilePpm = new File(file);
                                    break;
                                }
                                break block21;
                            }
                            catch (MalformedURLException mue) {
                                break block21;
                            }
                        }
                        if (line.startsWith("WYMS ERROR:")) {
                            throw new ImageLoaderException("Error in JavaScript page:" + line);
                        }
                    }
                }
                line = in.readLine();
            }
            if (this.final_width == -1 && imageFilePpm == null && !this.firefoxFiles.isEmpty()) {
                throw new ImageLoaderException("Is there any other firefox window open with same profile?");
            }
            if (this.final_width == -1) {
                throw new ImageLoaderException("Couldn't find new dimension. Is browser.dom.window.dump.enabled set in Firefox config?");
            }
            if (imageFilePpm == null) {
                throw new ImageLoaderException("Couldn't find dumped image. Is it a modern Gecko browser (i.e., firefox 1.5)?");
            }
            PPM ppmImage = new PPM(imageFilePpm.getAbsolutePath());
            this.image = ppmImage.getImage();
            this.cleanImages();
            this.resizeImage();
        }
        catch (IOException e) {
            throw new ImageLoaderException(e);
        }
        finally {
            if (browser != null) {
                browser.destroy();
            }
        }
    }

    public BufferedImage getBufferedImage() {
        if (this.image == null) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
        Graphics2D g = bufferedImage.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, this.width, this.height);
        g.drawImage(this.image, 0, 0, null);
        g.dispose();
        return bufferedImage;
    }

    private void resizeImage() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.image = tk.createImage(new FilteredImageSource(this.image.getSource(), new CropImageFilter(0, 0, this.final_width, this.final_height)));
        this.image = tk.createImage(new FilteredImageSource(this.image.getSource(), new ReplicateScaleFilter(this.width, this.height)));
    }

    private double[] getBbox(String line) throws ImageLoaderException {
        Matcher matcher = BBOX_RE.matcher(line);
        if (!matcher.matches()) {
            throw new ImageLoaderException("Can't find bounding box");
        }
        double[] bbox = new double[4];
        for (int i = 0; i < 4; ++i) {
            bbox[i] = Double.parseDouble(matcher.group(i + 1));
        }
        return bbox;
    }

    public void save(String fileName) {
        try {
            FileOutputStream fileStream = new FileOutputStream(fileName);
            ImageIO.write((RenderedImage)this.getBufferedImage(), "png", fileStream);
            fileStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cleanImages() {
        for (String fileName : this.firefoxFiles) {
            try {
                File file = new File(fileName);
                file.delete();
            }
            catch (Exception exception) {}
        }
    }
}

