/*
 * Decompiled with CFR 0.152.
 */
package slippymap;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.ImageProvider;
import slippymap.SlippyMapTile;

public class SlippyMapLayer
extends Layer
implements ImageObserver {
    ArrayList<HashMap<Integer, SlippyMapTile>> tileStorage = new ArrayList(20);
    Point[][] pixelpos = new Point[21][21];
    LatLon lastTopLeft;
    LatLon lastBotRight;
    int z12x0;
    int z12x1;
    int z12y0;
    int z12y1;
    private Image bufferImage;
    private SlippyMapTile clickedTile;
    private boolean needRedraw;
    private JPopupMenu tileOptionMenu;

    public SlippyMapLayer() {
        super("Slippy Map");
        for (int i = 0; i < 18; ++i) {
            this.tileStorage.add(new HashMap());
        }
        this.tileOptionMenu = new JPopupMenu();
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction("Load Tile"){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SlippyMapLayer.this.clickedTile != null) {
                    SlippyMapLayer.this.clickedTile.loadImage();
                    SlippyMapLayer.this.needRedraw = true;
                    Main.map.repaint();
                }
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction("Request Update"){

            public void actionPerformed(ActionEvent actionEvent) {
            }

            public boolean isEnabled() {
                return false;
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction("Show Tile Status"){

            public void actionPerformed(ActionEvent actionEvent) {
            }

            public boolean isEnabled() {
                return false;
            }
        }));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Main.map.mapView.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (mouseEvent.getButton() != 3) {
                            return;
                        }
                        SlippyMapLayer.this.clickedTile = SlippyMapLayer.this.getTileForPixelpos(mouseEvent.getX(), mouseEvent.getY());
                        SlippyMapLayer.this.tileOptionMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                });
                Main.map.mapView.addLayerChangeListener(new MapView.LayerChangeListener(){

                    public void activeLayerChange(Layer layer, Layer layer2) {
                    }

                    public void layerAdded(Layer layer) {
                    }

                    public void layerRemoved(Layer layer) {
                        Main.pref.listener.remove(SlippyMapLayer.this);
                    }
                });
            }
        });
    }

    public void paint(Graphics graphics, MapView mapView) {
        Object object;
        Object object2;
        int n;
        Object object3;
        int n2;
        int n3;
        LatLon latLon = mapView.getLatLon(0, 0);
        LatLon latLon2 = mapView.getLatLon(mapView.getWidth(), mapView.getHeight());
        Graphics graphics2 = graphics;
        if (this.lastTopLeft != null && this.lastBotRight != null && latLon.equalsEpsilon(this.lastTopLeft) && latLon2.equalsEpsilon(this.lastBotRight) && this.bufferImage != null && mapView.getWidth() == this.bufferImage.getWidth(null) && mapView.getHeight() == this.bufferImage.getHeight(null) && !this.needRedraw) {
            graphics.drawImage(this.bufferImage, 0, 0, null);
            return;
        }
        this.needRedraw = false;
        this.lastTopLeft = latLon;
        this.lastBotRight = latLon2;
        this.bufferImage = mapView.createImage(mapView.getWidth(), mapView.getHeight());
        graphics = this.bufferImage.getGraphics();
        this.z12x0 = this.lonToTileX(latLon.lon());
        this.z12x1 = this.lonToTileX(latLon2.lon());
        this.z12y0 = this.latToTileY(latLon.lat());
        this.z12y1 = this.latToTileY(latLon2.lat());
        if (this.z12x0 > this.z12x1) {
            n3 = this.z12x0;
            this.z12x0 = this.z12x1;
            this.z12x1 = n3;
        }
        if (this.z12y0 > this.z12y1) {
            n3 = this.z12y0;
            this.z12y0 = this.z12y1;
            this.z12y1 = n3;
        }
        if (this.z12x1 - this.z12x0 > 18) {
            return;
        }
        if (this.z12y1 - this.z12y0 > 18) {
            return;
        }
        for (n3 = this.z12x0 - 1; n3 <= this.z12x1 + 1; ++n3) {
            double d = this.tileXToLon(n3);
            for (n2 = this.z12y0 - 1; n2 <= this.z12y1 + 1; ++n2) {
                object3 = new LatLon(this.tileYToLat(n2), d);
                this.pixelpos[n3 - this.z12x0 + 1][n2 - this.z12y0 + 1] = mapView.getPoint(Main.proj.latlon2eastNorth((LatLon)object3));
            }
        }
        n3 = graphics.getFontMetrics().getHeight();
        graphics.setColor(Color.DARK_GRAY);
        for (n = this.z12x0 - 1; n <= this.z12x1; ++n) {
            for (int i = this.z12y0 - 1; i <= this.z12y1; ++i) {
                Image image;
                n2 = i * 2 << 18 + n;
                object3 = this.tileStorage.get(12).get(n2);
                if (object3 == null) {
                    object3 = new SlippyMapTile(n, i, 12);
                    this.tileStorage.get(12).put(n2, (SlippyMapTile)object3);
                }
                if ((image = ((SlippyMapTile)object3).getImage()) == null) continue;
                object2 = this.pixelpos[n - this.z12x0 + 1][i - this.z12y0 + 1];
                object = this.pixelpos[n - this.z12x0 + 2][i - this.z12y0 + 2];
                graphics.drawImage(image, ((Point)object2).x, ((Point)object2).y, ((Point)object).x - ((Point)object2).x, ((Point)object).y - ((Point)object2).y, this);
            }
        }
        for (n = this.z12x0 - 1; n <= this.z12x1; ++n) {
            Point point = this.pixelpos[n - this.z12x0 + 1][0];
            if (n % 32 == 0) {
                graphics.fillRect(point.x - 1, 0, 3, mapView.getHeight());
            } else {
                graphics.drawLine(point.x, 0, point.x, mapView.getHeight());
            }
            for (n2 = this.z12y0 - 1; n2 <= this.z12y1; ++n2) {
                int n4 = n2 * 2 << 18 + n;
                int n5 = point.y + 2 + n3;
                object2 = this.tileStorage.get(12).get(n4);
                point = this.pixelpos[n - this.z12x0 + 1][n2 - this.z12y0 + 2];
                graphics.drawString("x=" + n + " y=" + n2 + " z=12", point.x + 2, n5);
                n5 += 1 + n3;
                if (n % 32 == 0 && n2 % 32 == 0) {
                    graphics.drawString("x=" + n / 32 + " y=" + n2 / 32 + " z=7", point.x + 2, n5);
                    n5 += 1 + n3;
                }
                if ((object = ((SlippyMapTile)object2).getMetadata()) != null) {
                    graphics.drawString((String)object, point.x + 2, n5);
                    n5 += 1 + n3;
                }
                if (((SlippyMapTile)object2).getImage() == null) {
                    graphics.drawString("image not loaded", point.x + 2, n5);
                    n5 += 1 + n3;
                }
                if (n != this.z12x0 - 1) continue;
                if (n2 % 32 == 31) {
                    graphics.fillRect(0, point.y - 1, mapView.getWidth(), 3);
                    continue;
                }
                graphics.drawLine(0, point.y, mapView.getWidth(), point.y);
            }
        }
        graphics2.drawImage(this.bufferImage, 0, 0, null);
    }

    SlippyMapTile getTileForPixelpos(int n, int n2) {
        int n3;
        int n4 = this.z12x1;
        int n5 = this.z12y1;
        for (n3 = this.z12x0; n3 <= this.z12x1; ++n3) {
            if (this.pixelpos[n3 - this.z12x0 + 1][0].x <= n) continue;
            n4 = n3 - 1;
            break;
        }
        if (n4 == -1) {
            return null;
        }
        for (n3 = this.z12y0; n3 <= this.z12y1; ++n3) {
            if (this.pixelpos[0][n3 - this.z12y0 + 1].y <= n2) continue;
            n5 = n3 - 1;
            break;
        }
        if (n5 == -1) {
            return null;
        }
        n3 = n5 * 2 << 18 + n4;
        SlippyMapTile slippyMapTile = this.tileStorage.get(12).get(n3);
        if (slippyMapTile == null) {
            slippyMapTile = new SlippyMapTile(n4, n5, 12);
            this.tileStorage.get(12).put(n3, slippyMapTile);
        }
        return slippyMapTile;
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"slippymap");
    }

    public Object getInfoComponent() {
        return null;
    }

    public Component[] getMenuEntries() {
        return new Component[]{new JMenuItem((Action)new LayerListDialog.ShowHideLayerAction((Layer)this)), new JMenuItem((Action)new LayerListDialog.DeleteLayerAction((Layer)this)), new JSeparator(), new JMenuItem((Action)new RenameLayerAction(this.associatedFile, (Layer)this)), new JSeparator(), new JMenuItem((Action)new LayerListPopup.InfoAction((Layer)this))};
    }

    public String getToolTipText() {
        return null;
    }

    public boolean isMergable(Layer layer) {
        return false;
    }

    public void mergeFrom(Layer layer) {
    }

    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
    }

    private int latToTileY(double d) {
        double d2 = d / 180.0 * Math.PI;
        double d3 = Math.log(Math.tan(d2) + 1.0 / Math.cos(d2));
        return (int)(2048.0 * (Math.PI - d3) / Math.PI);
    }

    private int lonToTileX(double d) {
        return (int)(512.0 * (d + 180.0) / 45.0);
    }

    private double tileYToLat(int n) {
        return Math.atan(Math.sinh(Math.PI - Math.PI * (double)n / 2048.0)) * 180.0 / Math.PI;
    }

    private double tileXToLon(int n) {
        return (double)n * 45.0 / 512.0 - 180.0;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        boolean bl = (n & 0x70) != 0;
        this.needRedraw = true;
        Main.map.repaint(bl ? 0L : 100L);
        return !bl;
    }
}

