/* Generated By:JavaCC: Do not edit this line. MapCSSParser.java */
package org.openstreetmap.josm.gui.mappaint.mapcss.parser;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

import org.openstreetmap.josm.gui.mappaint.mapcss.Condition;
import org.openstreetmap.josm.gui.mappaint.mapcss.Expression;
import org.openstreetmap.josm.gui.mappaint.mapcss.Instruction;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSRule;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.gui.mappaint.mapcss.Expression.FunctionExpression;
import org.openstreetmap.josm.gui.mappaint.mapcss.Expression.LiteralExpression;
import org.openstreetmap.josm.tools.Pair;

public class MapCSSParser implements MapCSSParserConstants {
    MapCSSStyleSource sheet;

/*************
 * Parser definitions
 *
 *                       rule
 *  _______________________|______________________________
 * |                                                      |
 *        selector                      declaration
 *  _________|___________________   _________|____________
 * |                             | |                      |
 *
 * way|z11-12[highway=residential] { color: red; width: 3 }
 *
 *    |_____||___________________|   |_________|
 *       |            |                   |
 *     zoom       condition          instruction
 *
 * more general:
 *
 * way|z13-[a=b][c=d]::subpart, way|z-3[u=v]:closed::subpart2 { p1 : val; p2 : val; }
 *
 * 'val' can be a literal, or an expression like "prop(width, default) + 0.8".
 *
 */
  final public int uint() throws ParseException {
    Token i;
    i = jj_consume_token(UINT);
               {if (true) return Integer.parseInt(i.image);}
    throw new Error("Missing return statement in function");
  }

  final public float ufloat() throws ParseException {
    Token f;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UFLOAT:
      f = jj_consume_token(UFLOAT);
      break;
    case UINT:
      f = jj_consume_token(UINT);
      break;
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return Float.parseFloat(f.image);}
    throw new Error("Missing return statement in function");
  }

  final public String string() throws ParseException {
    Token t;
    t = jj_consume_token(STRING);
        {if (true) return t.image.substring(1, t.image.length() - 1).replace("\\\"", "\"").replace("\\\\", "\\");}
    throw new Error("Missing return statement in function");
  }

  final public String string_or_ident() throws ParseException {
    Token t;
    String s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENT:
      t = jj_consume_token(IDENT);
                {if (true) return t.image;}
      break;
    case STRING:
      s = string();
                                                 {if (true) return s;}
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * white-space
 */
  final public void s() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case S:
      jj_consume_token(S);
      break;
    default:
      jj_la1[2] = jj_gen;
      ;
    }
  }

/**
 * mix of white-space and comments
 */
  final public void w() throws ParseException {
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
      case COMMENT_START:
        ;
        break;
      default:
        jj_la1[3] = jj_gen;
        break label_1;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        jj_consume_token(S);
        break;
      case COMMENT_START:
        jj_consume_token(COMMENT_START);
        jj_consume_token(COMMENT_END);
        break;
      default:
        jj_la1[4] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
 * comma delimited list of floats (at least 2, all >= 0)
 */
  final public List<Float> float_array() throws ParseException {
    float f;
    List<Float> fs = new ArrayList<Float>();
    f = ufloat();
                 fs.add(f);
    label_2:
    while (true) {
      jj_consume_token(COMMA);
      s();
      f = ufloat();
                     fs.add(f);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[5] = jj_gen;
        break label_2;
      }
    }
        {if (true) return fs;}
    throw new Error("Missing return statement in function");
  }

/**
 * root
 */
  final public void sheet(MapCSSStyleSource sheet) throws ParseException {
    MapCSSRule r;
    Token com = null;
      this.sheet = sheet;
    w();
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
      case STAR:
        ;
        break;
      default:
        jj_la1[6] = jj_gen;
        break label_3;
      }
      r = rule();
                 if (r != null) { sheet.rules.add(r); }
      w();
    }
    jj_consume_token(0);
  }

  final public MapCSSRule rule() throws ParseException {
    List<Selector> selectors = new ArrayList<Selector>();
    Selector sel;
    List<Instruction> decl;
    try {
      sel = selector();
                         selectors.add(sel);
      w();
      label_4:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[7] = jj_gen;
          break label_4;
        }
        jj_consume_token(COMMA);
        w();
        sel = selector();
                             selectors.add(sel);
        w();
      }
    } catch (ParseException ex) {
        error_skipto(RBRACE);
        {if (true) return null;}
    }
    decl = declaration();
      {if (true) return new MapCSSRule(selectors, decl);}
    throw new Error("Missing return statement in function");
  }

  final public Selector selector() throws ParseException {
    Token base;
    Condition c;
    Pair<Integer, Integer> r = null;
    List<Condition> conditions = new ArrayList<Condition>();
    String sub = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENT:
      base = jj_consume_token(IDENT);
      break;
    case STAR:
      base = jj_consume_token(STAR);
      break;
    default:
      jj_la1[8] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PIPE_Z:
      r = zoom();
      break;
    default:
      jj_la1[9] = jj_gen;
      ;
    }
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LSQUARE:
      case COLON:
        ;
        break;
      default:
        jj_la1[10] = jj_gen;
        break label_5;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LSQUARE:
        c = condition();
        break;
      case COLON:
        c = pseudoclass();
        break;
      default:
        jj_la1[11] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                            conditions.add(c);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SLASH:
    case DCOLON:
      sub = subpart();
      break;
    default:
      jj_la1[12] = jj_gen;
      ;
    }
      {if (true) return new Selector(base.image, r, conditions, sub);}
    throw new Error("Missing return statement in function");
  }

  final public Pair<Integer, Integer> zoom() throws ParseException {
    Integer min = 0;
    Integer max = Integer.MAX_VALUE;
    jj_consume_token(PIPE_Z);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUS:
      jj_consume_token(MINUS);
      max = uint();
      break;
    case UINT:
      min = uint();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MINUS:
        jj_consume_token(MINUS);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UINT:
          max = uint();
          break;
        default:
          jj_la1[13] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[14] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return new Pair<Integer, Integer>(min, max);}
    throw new Error("Missing return statement in function");
  }

  final public Condition condition() throws ParseException {
    Condition c;
    Expression e;
    jj_consume_token(LSQUARE);
    if (jj_2_1(2)) {
      c = simple_key_condition();
      jj_consume_token(RSQUARE);
                                                   {if (true) return c;}
    } else if (jj_2_2(3)) {
      c = simple_key_value_condition();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
      case UINT:
      case UFLOAT:
      case STRING:
      case HEXCOLOR:
      case LPAR:
      case EXCLAMATION:
      case PLUS:
      case MINUS:
        e = expression();
                             c = new Condition.ExpressionCondition(e);
        break;
      default:
        jj_la1[16] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RSQUARE);
      {if (true) return c;}
    throw new Error("Missing return statement in function");
  }

  final public Condition simple_key_condition() throws ParseException {
    boolean not = false;
    String key;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXCLAMATION:
      jj_consume_token(EXCLAMATION);
                      not = true;
      break;
    default:
      jj_la1[17] = jj_gen;
      ;
    }
    key = string_or_ident();
      {if (true) return new Condition.KeyCondition(key, not);}
    throw new Error("Missing return statement in function");
  }

  final public Condition simple_key_value_condition() throws ParseException {
    boolean not = false;
    String key;
    String val;
    key = string_or_ident();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXCLAMATION_EQUAL:
      jj_consume_token(EXCLAMATION_EQUAL);
                            not = true;
      break;
    case EQUAL:
      jj_consume_token(EQUAL);
      break;
    default:
      jj_la1[18] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    val = string_or_ident();
      {if (true) return new Condition.KeyValueCondition(key, val, not ? Condition.Op.NEQ : Condition.Op.EQ);}
    throw new Error("Missing return statement in function");
  }

  final public Condition pseudoclass() throws ParseException {
    Token t;
    boolean not = false;
    jj_consume_token(COLON);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXCLAMATION:
      jj_consume_token(EXCLAMATION);
                      not = true;
      break;
    default:
      jj_la1[19] = jj_gen;
      ;
    }
    t = jj_consume_token(IDENT);
      {if (true) return new Condition.PseudoClassCondition(t.image, not);}
    throw new Error("Missing return statement in function");
  }

  final public String subpart() throws ParseException {
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SLASH:
      jj_consume_token(SLASH);
      break;
    case DCOLON:
      jj_consume_token(DCOLON);
      break;
    default:
      jj_la1[20] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENT:
      t = jj_consume_token(IDENT);
      break;
    case STAR:
      t = jj_consume_token(STAR);
      break;
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return t.image;}
    throw new Error("Missing return statement in function");
  }

  final public List<Instruction> declaration() throws ParseException {
    List<Instruction> ins = new ArrayList<Instruction>();
    Instruction i;
    jj_consume_token(LBRACE);
    w();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RBRACE:
      jj_consume_token(RBRACE);
                 {if (true) return ins;}
      break;
    default:
      jj_la1[22] = jj_gen;
      ;
    }
    try {
      i = instruction();
                          if (i != null) ins.add(i);
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SEMICOLON:
          ;
          break;
        default:
          jj_la1[23] = jj_gen;
          break label_6;
        }
        jj_consume_token(SEMICOLON);
        w();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case RBRACE:
          jj_consume_token(RBRACE);
                         {if (true) return ins;}
          break;
        default:
          jj_la1[24] = jj_gen;
          ;
        }
        i = instruction();
                              if (i != null) ins.add(i);
      }
      jj_consume_token(RBRACE);
                   {if (true) return ins;}
    } catch (ParseException ex) {
        error_skipto(RBRACE);
        {if (true) return ins;}
    }
    throw new Error("Missing return statement in function");
  }

  final public Instruction instruction() throws ParseException {
    Token key;
    Object val;
    key = jj_consume_token(IDENT);
    w();
    jj_consume_token(COLON);
    w();
    if (jj_2_3(2)) {
      val = float_array();
      w();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
      case UINT:
      case UFLOAT:
      case STRING:
      case HEXCOLOR:
      case LPAR:
      case EXCLAMATION:
      case PLUS:
      case MINUS:
        val = expression();
        break;
      default:
        jj_la1[25] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        if (val instanceof LiteralExpression)
            {if (true) return new Instruction.AssignmentInstruction(key.image, ((LiteralExpression) val).evaluate(null));}
        else
            {if (true) return new Instruction.AssignmentInstruction(key.image, val);}
    throw new Error("Missing return statement in function");
  }

  final public Expression expression() throws ParseException {
    List<Expression> args = new ArrayList<Expression>();
    Expression e;
    String op = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXCLAMATION:
      jj_consume_token(EXCLAMATION);
                          op = "not";
      w();
      e = primary();
                                                          args.add(e);
      w();
      break;
    case MINUS:
      jj_consume_token(MINUS);
                    op = "minus";
      w();
      e = primary();
                                                      args.add(e);
      w();
      break;
    case IDENT:
    case UINT:
    case UFLOAT:
    case STRING:
    case HEXCOLOR:
    case LPAR:
    case PLUS:
      e = primary();
                          args.add(e);
      w();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STAR:
      case SLASH:
      case GREATER_EQUAL:
      case LESS_EQUAL:
      case GREATER:
      case LESS:
      case EQUAL:
      case PIPE:
      case PLUS:
      case MINUS:
      case AMPERSAND:
      case QUESTION:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PLUS:
          label_7:
          while (true) {
            jj_consume_token(PLUS);
                               op = "plus";
            w();
            e = primary();
                                                                args.add(e);
            w();
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case PLUS:
              ;
              break;
            default:
              jj_la1[26] = jj_gen;
              break label_7;
            }
          }
          break;
        case STAR:
          label_8:
          while (true) {
            jj_consume_token(STAR);
                               op = "times";
            w();
            e = primary();
                                                                 args.add(e);
            w();
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case STAR:
              ;
              break;
            default:
              jj_la1[27] = jj_gen;
              break label_8;
            }
          }
          break;
        case MINUS:
          label_9:
          while (true) {
            jj_consume_token(MINUS);
                                op = "minus";
            w();
            e = primary();
                                                                  args.add(e);
            w();
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case MINUS:
              ;
              break;
            default:
              jj_la1[28] = jj_gen;
              break label_9;
            }
          }
          break;
        case SLASH:
          label_10:
          while (true) {
            jj_consume_token(SLASH);
                                op = "divided_by";
            w();
            e = primary();
                                                                       args.add(e);
            w();
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case SLASH:
              ;
              break;
            default:
              jj_la1[29] = jj_gen;
              break label_10;
            }
          }
          break;
        case GREATER_EQUAL:
          jj_consume_token(GREATER_EQUAL);
                                        op = "greater_equal";
          w();
          e = primary();
                                                                                  args.add(e);
          w();
          break;
        case LESS_EQUAL:
          jj_consume_token(LESS_EQUAL);
                                     op = "less_equal";
          w();
          e = primary();
                                                                            args.add(e);
          w();
          break;
        case GREATER:
          jj_consume_token(GREATER);
                                  op = "greater";
          w();
          e = primary();
                                                                      args.add(e);
          w();
          break;
        case EQUAL:
          jj_consume_token(EQUAL);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case EQUAL:
            jj_consume_token(EQUAL);
            break;
          default:
            jj_la1[30] = jj_gen;
            ;
          }
                                             op = "equal";
          w();
          e = primary();
                                                                               args.add(e);
          w();
          break;
        case LESS:
          jj_consume_token(LESS);
                               op = "less";
          w();
          e = primary();
                                                                args.add(e);
          w();
          break;
        case AMPERSAND:
          jj_consume_token(AMPERSAND);
          jj_consume_token(AMPERSAND);
                                                op = "and";
          w();
          e = primary();
                                                                                args.add(e);
          w();
          break;
        case PIPE:
          jj_consume_token(PIPE);
          jj_consume_token(PIPE);
                                      op = "or";
          w();
          e = primary();
                                                                     args.add(e);
          w();
          break;
        case QUESTION:
          jj_consume_token(QUESTION);
                                   op = "cond";
          w();
          e = primary();
                                                                    args.add(e);
          w();
          jj_consume_token(COLON);
          w();
          e = primary();
                                                                                                                 args.add(e);
          w();
          break;
        default:
          jj_la1[31] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[32] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[33] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        if (op == null)
            {if (true) return args.get(0);}
        {if (true) return new FunctionExpression(op, args);}
    throw new Error("Missing return statement in function");
  }

  final public Expression primary() throws ParseException {
    Expression nested;
    FunctionExpression fn;
    Object lit;
    if (jj_2_4(2)) {
      // both function and identifier start with an identifier
              fn = function();
                        {if (true) return fn;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
      case UINT:
      case UFLOAT:
      case STRING:
      case HEXCOLOR:
      case PLUS:
        lit = literal();
                        {if (true) return new LiteralExpression(lit);}
        break;
      case LPAR:
        jj_consume_token(LPAR);
        w();
        nested = expression();
        jj_consume_token(RPAR);
                                                    {if (true) return nested;}
        break;
      default:
        jj_la1[34] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public FunctionExpression function() throws ParseException {
    Token tmp;
    Expression arg;
    String name;
    List<Expression> args = new ArrayList<Expression>();
    tmp = jj_consume_token(IDENT);
                  name = tmp.image;
    w();
    jj_consume_token(LPAR);
    w();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENT:
    case UINT:
    case UFLOAT:
    case STRING:
    case HEXCOLOR:
    case LPAR:
    case EXCLAMATION:
    case PLUS:
    case MINUS:
      arg = expression();
                           args.add(arg);
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[35] = jj_gen;
          break label_11;
        }
        jj_consume_token(COMMA);
        w();
        arg = expression();
                                         args.add(arg);
      }
      break;
    default:
      jj_la1[36] = jj_gen;
      ;
    }
    jj_consume_token(RPAR);
      {if (true) return new FunctionExpression(name, args);}
    throw new Error("Missing return statement in function");
  }

  final public Object literal() throws ParseException {
    Object val;
    Token t;
    float f;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENT:
    case STRING:
      val = string_or_ident();
                                {if (true) return val;}
      break;
    case PLUS:
      jj_consume_token(PLUS);
      f = ufloat();
                                {if (true) return new Instruction.RelativeFloat(f);}
      break;
    case UINT:
    case UFLOAT:
      f = ufloat();
                     {if (true) return f;}
      break;
    case HEXCOLOR:
      t = jj_consume_token(HEXCOLOR);
                String clr = t.image.substring(1);
                if (clr.length() == 3) {
                    clr = new String(new char[] {clr.charAt(0),clr.charAt(0),clr.charAt(1),clr.charAt(1),clr.charAt(2),clr.charAt(2)});
                }
                if (clr.length() != 6)
                    {if (true) throw new AssertionError();}
                {if (true) return new Color(Integer.parseInt(clr, 16));}
      break;
    default:
      jj_la1[37] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  void error_skipto(int kind) throws ParseException {
    ParseException e = generateParseException();
    System.err.println(e);
    if (sheet != null) {
        sheet.logError(e);
    }
    Token t;
    do {
        t = getNextToken();
    } while (t.kind != kind && t.kind != EOF);
    if (t.kind == EOF)
        throw new ParseException("Reached end of file while parsing");
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_3R_12() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_16()) jj_scanpos = xsp;
    if (jj_3R_17()) return true;
    return false;
  }

  private boolean jj_3R_20() {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3_4() {
    if (jj_3R_15()) return true;
    return false;
  }

  private boolean jj_3R_25() {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3R_14() {
    if (jj_3R_19()) return true;
    Token xsp;
    if (jj_3R_20()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_20()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_23() {
    if (jj_3R_25()) return true;
    return false;
  }

  private boolean jj_3_2() {
    if (jj_3R_13()) return true;
    return false;
  }

  private boolean jj_3R_26() {
    if (jj_scan_token(COMMENT_START)) return true;
    return false;
  }

  private boolean jj_3R_19() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(3)) {
    jj_scanpos = xsp;
    if (jj_scan_token(2)) return true;
    }
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_12()) return true;
    if (jj_scan_token(RSQUARE)) return true;
    return false;
  }

  private boolean jj_3R_24() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(7)) {
    jj_scanpos = xsp;
    if (jj_3R_26()) return true;
    }
    return false;
  }

  private boolean jj_3R_21() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_24()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_3() {
    if (jj_3R_14()) return true;
    return false;
  }

  private boolean jj_3R_18() {
    if (jj_scan_token(EXCLAMATION_EQUAL)) return true;
    return false;
  }

  private boolean jj_3R_15() {
    if (jj_scan_token(IDENT)) return true;
    if (jj_3R_21()) return true;
    if (jj_scan_token(LPAR)) return true;
    return false;
  }

  private boolean jj_3R_13() {
    if (jj_3R_17()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_18()) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) return true;
    }
    if (jj_3R_17()) return true;
    return false;
  }

  private boolean jj_3R_17() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_22()) {
    jj_scanpos = xsp;
    if (jj_3R_23()) return true;
    }
    return false;
  }

  private boolean jj_3R_22() {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_16() {
    if (jj_scan_token(EXCLAMATION)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public MapCSSParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[38];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0xc,0x12,0x80,0x80,0x80,0x4000000,0x102,0x4000000,0x102,0x10000000,0x801000,0x801000,0x1000200,0x4,0x40000000,0x40000004,0x6020405e,0x200000,0x500000,0x200000,0x1000200,0x102,0x800,0x2000000,0x800,0x6020405e,0x20000000,0x100,0x40000000,0x200,0x100000,0xe81f0300,0xe81f0300,0x6020405e,0x2000405e,0x4000000,0x6020405e,0x2000005e,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x2,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x1,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[4];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public MapCSSParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public MapCSSParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new MapCSSParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 38; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 38; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public MapCSSParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new MapCSSParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 38; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 38; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public MapCSSParser(MapCSSParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 38; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(MapCSSParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 38; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List jj_expentries = new java.util.ArrayList();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[37];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 38; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 37; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 4; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
