/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pmtiles.gui.layers;

import jakarta.json.JsonObject;
import java.awt.Image;
import java.awt.Point;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.Projected;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileRange;
import org.openstreetmap.gui.jmapviewer.TileXY;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.IProjected;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.plugins.pmtiles.lib.Header;
import org.openstreetmap.josm.plugins.pmtiles.lib.PMTiles;
import org.openstreetmap.josm.plugins.pmtiles.lib.TileType;

public interface PMTilesTileSource
extends TileSource {
    public JsonObject metadata();

    public Header header();

    public OsmMercator osmMercator();

    default public boolean requiresAttribution() {
        return this.metadata().containsKey((Object)"attribution");
    }

    default public String getAttributionText(int zoom, ICoordinate topLeft, ICoordinate botRight) {
        return this.metadata().getString("attribution", null);
    }

    default public String getAttributionLinkURL() {
        return null;
    }

    default public Image getAttributionImage() {
        return null;
    }

    default public String getAttributionImageURL() {
        return null;
    }

    default public String getTermsOfUseText() {
        return null;
    }

    default public String getTermsOfUseURL() {
        return null;
    }

    default public int getMaxZoom() {
        return this.header().maxZoom();
    }

    default public int getMinZoom() {
        return this.header().minZoom();
    }

    default public String getName() {
        return this.metadata().getString("name", null);
    }

    default public String getId() {
        return this.header().location().toString();
    }

    default public String getTileUrl(int zoom, int tilex, int tiley) {
        return this.header().location().toString() + "/" + PMTilesTileSource.getTileId(this.header(), zoom, tilex, tiley);
    }

    default public String getTileId(int zoom, int tilex, int tiley) {
        return PMTilesTileSource.getTileId(this.header(), zoom, tilex, tiley);
    }

    public static String getTileId(Header header, int zoom, int tilex, int tiley) {
        String extension = switch (header.tileType()) {
            default -> throw new IncompatibleClassChangeError();
            case TileType.MVT -> ".mvt";
            case TileType.PNG -> ".png";
            case TileType.JPEG -> ".jpg";
            case TileType.WEBP -> ".webp";
            case TileType.AVIF -> ".avif";
            case TileType.UNKNOWN -> throw new IllegalArgumentException("Unknown format: " + String.valueOf(header.location()));
        };
        return PMTiles.convertToHilbert(zoom, tilex, tiley) + extension;
    }

    default public int getTileSize() {
        return this.getDefaultTileSize();
    }

    default public int getDefaultTileSize() {
        return 512;
    }

    default public double getDistance(double lat1, double lon1, double lat2, double lon2) {
        return this.osmMercator().getDistance(lat1, lon1, lat2, lon2);
    }

    default public Point latLonToXY(double lat, double lon, int zoom) {
        return new Point((int)Math.round(this.osmMercator().lonToX(lon, zoom)), (int)Math.round(this.osmMercator().latToY(lat, zoom)));
    }

    default public Point latLonToXY(ICoordinate point, int zoom) {
        return this.latLonToXY(point.getLat(), point.getLon(), zoom);
    }

    default public ICoordinate xyToLatLon(Point point, int zoom) {
        return this.xyToLatLon(point.x, point.y, zoom);
    }

    default public ICoordinate xyToLatLon(int x, int y, int zoom) {
        return new Coordinate(this.osmMercator().yToLat((long)y, zoom), this.osmMercator().xToLon((long)x, zoom));
    }

    default public TileXY latLonToTileXY(double lat, double lon, int zoom) {
        return new TileXY(this.osmMercator().lonToX(lon, zoom) / (double)this.getTileSize(), this.osmMercator().latToY(lat, zoom) / (double)this.getTileSize());
    }

    default public TileXY latLonToTileXY(ICoordinate point, int zoom) {
        return this.latLonToTileXY(point.getLat(), point.getLon(), zoom);
    }

    default public ICoordinate tileXYToLatLon(TileXY xy, int zoom) {
        return this.tileXYToLatLon(xy.getXIndex(), xy.getYIndex(), zoom);
    }

    default public ICoordinate tileXYToLatLon(Tile tile) {
        return this.tileXYToLatLon(tile.getXtile(), tile.getYtile(), tile.getZoom());
    }

    default public ICoordinate tileXYToLatLon(int x, int y, int zoom) {
        return new Coordinate(this.osmMercator().yToLat((long)y * (long)this.getTileSize(), zoom), this.osmMercator().xToLon((long)x * (long)this.getTileSize(), zoom));
    }

    default public int getTileXMax(int zoom) {
        return PMTilesTileSource.getTileMax(zoom);
    }

    default public int getTileXMin(int zoom) {
        return 0;
    }

    default public int getTileYMax(int zoom) {
        return PMTilesTileSource.getTileMax(zoom);
    }

    default public int getTileYMin(int zoom) {
        return 0;
    }

    private static int getTileMax(int zoom) {
        return (int)Math.pow(2.0, zoom) - 1;
    }

    default public boolean isNoTileAtZoom(Map<String, List<String>> headers, int statusCode, byte[] content) {
        return content.length == 0;
    }

    default public Map<String, String> getMetadata(Map<String, List<String>> headers) {
        return Collections.emptyMap();
    }

    default public IProjected tileXYtoProjected(int x, int y, int zoom) {
        double mercatorWidth = 4.007501668557849E7;
        double f = 4.007501668557849E7 * (double)this.getTileSize() / (double)this.osmMercator().getMaxPixels(zoom);
        return new Projected(f * (double)x - 2.0037508342789244E7, -(f * (double)y - 2.0037508342789244E7));
    }

    default public TileXY projectedToTileXY(IProjected p, int zoom) {
        double mercatorWidth = 4.007501668557849E7;
        double f = 4.007501668557849E7 * (double)this.getTileSize() / (double)this.osmMercator().getMaxPixels(zoom);
        return new TileXY((p.getEast() + 2.0037508342789244E7) / f, (-p.getNorth() + 2.0037508342789244E7) / f);
    }

    default public boolean isInside(Tile inner, Tile outer) {
        int dz = inner.getZoom() - outer.getZoom();
        if (dz < 0) {
            return false;
        }
        return outer.getXtile() == inner.getXtile() >> dz && outer.getYtile() == inner.getYtile() >> dz;
    }

    default public TileRange getCoveringTileRange(Tile tile, int newZoom) {
        if (newZoom <= tile.getZoom()) {
            int dz = tile.getZoom() - newZoom;
            TileXY xy = new TileXY((double)(tile.getXtile() >> dz), (double)(tile.getYtile() >> dz));
            return new TileRange(xy, xy, newZoom);
        }
        int dz = newZoom - tile.getZoom();
        TileXY t1 = new TileXY((double)(tile.getXtile() << dz), (double)(tile.getYtile() << dz));
        TileXY t2 = new TileXY(t1.getX() + (double)(1 << dz) - 1.0, t1.getY() + (double)(1 << dz) - 1.0);
        return new TileRange(t1, t2, newZoom);
    }

    default public String getServerCRS() {
        return "EPSG:3857";
    }
}

