/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pmtiles.gui.io.session;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.session.SessionLayerImporter;
import org.openstreetmap.josm.io.session.SessionReader;
import org.openstreetmap.josm.plugins.pmtiles.data.imagery.PMTilesImageryInfo;
import org.openstreetmap.josm.plugins.pmtiles.gui.layers.PMTilesImageLayer;
import org.openstreetmap.josm.plugins.pmtiles.lib.Header;
import org.openstreetmap.josm.plugins.pmtiles.lib.PMTiles;
import org.openstreetmap.josm.tools.I18n;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PMTilesImageSessionImporter
implements SessionLayerImporter {
    public Layer load(Element elem, SessionReader.ImportSupport support, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        String version = elem.getAttribute("version");
        if (!"0.1".equals(version)) {
            throw new IllegalDataException(I18n.tr((String)"Version ''{0}'' of meta data for PMTiles layer is not supported. Expected: 0.1", (Object[])new Object[]{version}));
        }
        String fileUri = PMTilesImageSessionImporter.getChildText(elem, "file");
        if (fileUri == null || fileUri.isEmpty()) {
            throw new IllegalDataException(I18n.tr((String)"Missing file URI in PMTiles session data", (Object[])new Object[0]));
        }
        String name = PMTilesImageSessionImporter.getChildText(elem, "name");
        try {
            URI uri = new URI(fileUri);
            Header header = PMTiles.readHeader(uri);
            PMTilesImageryInfo info = new PMTilesImageryInfo(header);
            PMTilesImageLayer layer = new PMTilesImageLayer(info);
            if (name != null && !name.isEmpty()) {
                layer.setName(name);
            }
            return layer;
        }
        catch (URISyntaxException e) {
            throw new IllegalDataException(I18n.tr((String)"Invalid PMTiles file URI: {0}", (Object[])new Object[]{fileUri}), (Throwable)e);
        }
    }

    private static String getChildText(Element parent, String tagName) {
        NodeList nodes = parent.getElementsByTagName(tagName);
        if (nodes.getLength() > 0) {
            return nodes.item(0).getTextContent();
        }
        return null;
    }
}

