/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.modules;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.opendata.core.modules.Module;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleException;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleHandler;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleInformation;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleListParseException;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleListParser;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.SAXException;

public class ReadLocalModuleInformationTask
extends PleaseWaitRunnable {
    private final Map<String, ModuleInformation> availableModules = new HashMap<String, ModuleInformation>();
    private boolean canceled;

    public ReadLocalModuleInformationTask() {
        super(I18n.tr((String)"Reading local module information..", (Object[])new Object[0]), false);
    }

    public ReadLocalModuleInformationTask(ProgressMonitor monitor) {
        super(I18n.tr((String)"Reading local module information..", (Object[])new Object[0]), monitor, false);
    }

    protected void cancel() {
        this.canceled = true;
    }

    protected void finish() {
    }

    protected void processJarFile(File f, String moduleName) throws ModuleException {
        ModuleInformation info = new ModuleInformation(f, moduleName);
        if (!this.availableModules.containsKey(info.getName())) {
            info.localversion = info.version;
            this.availableModules.put(info.getName(), info);
        } else {
            ModuleInformation current = this.availableModules.get(info.getName());
            current.localversion = info.version;
            if (info.icon != null) {
                current.icon = info.icon;
            }
            current.className = info.className;
            current.libraries = info.libraries;
        }
    }

    protected void scanSiteCacheFiles(ProgressMonitor monitor, File modulesDirectory) {
        File[] siteCacheFiles = modulesDirectory.listFiles((dir, name) -> name.matches("^([0-9]+-)?site.*\\.txt$"));
        if (siteCacheFiles == null || siteCacheFiles.length == 0) {
            return;
        }
        monitor.subTask(I18n.tr((String)"Processing module site cache files...", (Object[])new Object[0]));
        monitor.setTicksCount(siteCacheFiles.length);
        for (File f : siteCacheFiles) {
            String fname = f.getName();
            monitor.setCustomText(I18n.tr((String)"Processing file ''{0}''", (Object[])new Object[]{fname}));
            try {
                this.processLocalModuleInformationFile(f);
            }
            catch (ModuleListParseException e) {
                Logging.warn((String)I18n.tr((String)"Warning: Failed to scan file ''{0}'' for module information. Skipping.", (Object[])new Object[]{fname}));
                Logging.debug((Throwable)e);
            }
            monitor.worked(1);
        }
    }

    protected void scanIconCacheFiles(ProgressMonitor monitor, File modulesDirectory) {
        File[] siteCacheFiles = modulesDirectory.listFiles((dir, name) -> name.matches("^([0-9]+-)?site.*modules-icons\\.zip$"));
        if (siteCacheFiles == null || siteCacheFiles.length == 0) {
            return;
        }
        monitor.subTask(I18n.tr((String)"Processing module site cache icon files...", (Object[])new Object[0]));
        monitor.setTicksCount(siteCacheFiles.length);
        for (File f : siteCacheFiles) {
            String fname = f.getName();
            monitor.setCustomText(I18n.tr((String)"Processing file ''{0}''", (Object[])new Object[]{fname}));
            for (ModuleInformation pi : this.availableModules.values()) {
                if (pi.icon != null || pi.iconPath == null) continue;
                pi.icon = new ImageProvider(pi.name + ".jar/" + pi.iconPath).setArchive(f).setMaxWidth(24).setMaxHeight(24).setOptional(true).get();
            }
            monitor.worked(1);
        }
    }

    protected void scanModuleFiles(ProgressMonitor monitor, File modulesDirectory) {
        File[] moduleFiles = modulesDirectory.listFiles((dir, name) -> name.endsWith(".jar") || name.endsWith(".jar.new"));
        if (moduleFiles == null || moduleFiles.length == 0) {
            return;
        }
        monitor.subTask(I18n.tr((String)"Processing module files...", (Object[])new Object[0]));
        monitor.setTicksCount(moduleFiles.length);
        for (File f : moduleFiles) {
            String fname = f.getName();
            monitor.setCustomText(I18n.tr((String)"Processing file ''{0}''", (Object[])new Object[]{fname}));
            try {
                String moduleName;
                if (fname.endsWith(".jar")) {
                    moduleName = fname.substring(0, fname.length() - 4);
                    this.processJarFile(f, moduleName);
                } else if (fname.endsWith(".jar.new")) {
                    moduleName = fname.substring(0, fname.length() - 8);
                    this.processJarFile(f, moduleName);
                }
            }
            catch (ModuleException e) {
                Logging.warn((String)I18n.tr((String)"Warning: Failed to scan file ''{0}'' for module information. Skipping.", (Object[])new Object[]{fname}));
                Logging.debug((Throwable)e);
            }
            monitor.worked(1);
        }
    }

    protected void scanLocalModuleRepository(ProgressMonitor monitor, File modulesDirectory) {
        if (modulesDirectory == null) {
            return;
        }
        try {
            monitor.beginTask("");
            this.scanSiteCacheFiles(monitor, modulesDirectory);
            this.scanIconCacheFiles(monitor, modulesDirectory);
            this.scanModuleFiles(monitor, modulesDirectory);
        }
        finally {
            monitor.setCustomText("");
            monitor.finishTask();
        }
    }

    protected void processLocalModuleInformationFile(File file) throws ModuleListParseException {
        try (FileInputStream fin = new FileInputStream(file);){
            List<ModuleInformation> pis = new ModuleListParser().parse(fin);
            for (ModuleInformation pi : pis) {
                this.availableModules.put(pi.name, pi);
            }
        }
        catch (IOException e) {
            throw new ModuleListParseException(e);
        }
    }

    protected void analyseInProcessModules() {
        for (Module module : ModuleHandler.moduleList) {
            ModuleInformation info = module.getModuleInformation();
            if (this.canceled) {
                return;
            }
            if (!this.availableModules.containsKey(info.name)) {
                this.availableModules.put(info.name, info);
                continue;
            }
            this.availableModules.get((Object)info.name).localversion = info.localversion;
        }
    }

    protected void realRun() throws SAXException, IOException, OsmTransferException {
        Collection<String> moduleLocations = ModuleInformation.getModuleLocations();
        this.getProgressMonitor().setTicksCount(moduleLocations.size() + 2);
        if (this.canceled) {
            return;
        }
        for (String location : moduleLocations) {
            this.scanLocalModuleRepository(this.getProgressMonitor().createSubTaskMonitor(1, false), new File(location));
            this.getProgressMonitor().worked(1);
            if (!this.canceled) continue;
            return;
        }
        this.analyseInProcessModules();
        this.getProgressMonitor().worked(1);
        if (this.canceled) {
            return;
        }
        this.getProgressMonitor().worked(1);
    }

    public List<ModuleInformation> getAvailableModules() {
        return new ArrayList<ModuleInformation>(this.availableModules.values());
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

