/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.geographic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.datum.Ellipsoid;
import org.geotools.api.referencing.datum.GeodeticDatum;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.AbstractDerivedCRS;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.operation.projection.LambertConformal;
import org.geotools.referencing.operation.projection.LambertConformal1SP;
import org.geotools.referencing.operation.projection.LambertConformal2SP;
import org.geotools.referencing.operation.projection.MapProjection;
import org.openstreetmap.josm.data.projection.AbstractProjection;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.proj.LambertConformalConic;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeographicHandler;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;

public interface GeotoolsHandler
extends GeographicHandler {
    public static final List<Pair<Ellipsoid, org.openstreetmap.josm.data.projection.Ellipsoid>> ellipsoids = Collections.unmodifiableList(Arrays.asList(new Pair((Object)DefaultEllipsoid.GRS80, (Object)org.openstreetmap.josm.data.projection.Ellipsoid.GRS80), new Pair((Object)DefaultEllipsoid.WGS84, (Object)org.openstreetmap.josm.data.projection.Ellipsoid.WGS84)));

    @Override
    default public MathTransform findMathTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, boolean lenient) throws FactoryException {
        if (this.getCrsFor(sourceCRS.getName().getCode()) != null) {
            return CRS.findMathTransform((CoordinateReferenceSystem)this.getCrsFor(sourceCRS.getName().getCode()), (CoordinateReferenceSystem)targetCRS, (boolean)lenient);
        }
        if (sourceCRS instanceof AbstractDerivedCRS && "Lambert_Conformal_Conic".equalsIgnoreCase(sourceCRS.getName().getCode())) {
            ArrayList<MathTransform> result = new ArrayList<MathTransform>();
            AbstractDerivedCRS crs = (AbstractDerivedCRS)sourceCRS;
            MathTransform transform = crs.getConversionFromBase().getMathTransform();
            if (transform instanceof LambertConformal && crs.getDatum() instanceof GeodeticDatum) {
                LambertConformal lambert = (LambertConformal)transform;
                GeodeticDatum geo = (GeodeticDatum)crs.getDatum();
                for (ProjectionChoice choice : ProjectionPreference.getProjectionChoices()) {
                    AbstractProjection ap;
                    Projection p = choice.getProjection();
                    if (!(p instanceof AbstractProjection) || !((ap = (AbstractProjection)p).getProj() instanceof LambertConformalConic)) continue;
                    for (Pair<Ellipsoid, org.openstreetmap.josm.data.projection.Ellipsoid> pair : ellipsoids) {
                        if (!((Ellipsoid)pair.a).equals((Object)geo.getEllipsoid()) || !((org.openstreetmap.josm.data.projection.Ellipsoid)pair.b).equals(ap.getEllipsoid())) continue;
                        boolean ok = true;
                        ParameterValueGroup values = lambert.getParameterValues();
                        LambertConformalConic.Parameters params = ((LambertConformalConic)ap.getProj()).getParameters();
                        ok = ok ? GeotoolsHandler.equals(GeotoolsHandler.get(values, MapProjection.AbstractProvider.LATITUDE_OF_ORIGIN), params.latitudeOrigin) : ok;
                        ok = ok ? GeotoolsHandler.equals(GeotoolsHandler.get(values, MapProjection.AbstractProvider.CENTRAL_MERIDIAN), ap.getCentralMeridian()) : ok;
                        ok = ok ? GeotoolsHandler.equals(GeotoolsHandler.get(values, MapProjection.AbstractProvider.SCALE_FACTOR), ap.getScaleFactor()) : ok;
                        ok = ok ? GeotoolsHandler.equals(GeotoolsHandler.get(values, MapProjection.AbstractProvider.FALSE_EASTING), ap.getFalseEasting()) : ok;
                        boolean bl = ok = ok ? GeotoolsHandler.equals(GeotoolsHandler.get(values, MapProjection.AbstractProvider.FALSE_NORTHING), ap.getFalseNorthing()) : ok;
                        if (lambert instanceof LambertConformal2SP && params instanceof LambertConformalConic.Parameters2SP) {
                            LambertConformalConic.Parameters2SP param = (LambertConformalConic.Parameters2SP)params;
                            ok = ok ? GeotoolsHandler.equals(Math.min(GeotoolsHandler.get(values, MapProjection.AbstractProvider.STANDARD_PARALLEL_1), GeotoolsHandler.get(values, MapProjection.AbstractProvider.STANDARD_PARALLEL_2)), Math.min(param.standardParallel1, param.standardParallel2)) : ok;
                            ok = ok ? GeotoolsHandler.equals(Math.max(GeotoolsHandler.get(values, MapProjection.AbstractProvider.STANDARD_PARALLEL_1), GeotoolsHandler.get(values, MapProjection.AbstractProvider.STANDARD_PARALLEL_2)), Math.max(param.standardParallel1, param.standardParallel2)) : ok;
                        } else if (!(lambert instanceof LambertConformal1SP) || !(params instanceof LambertConformalConic.Parameters1SP)) {
                            ok = false;
                        }
                        if (!ok) continue;
                        try {
                            result.add(CRS.findMathTransform((CoordinateReferenceSystem)CRS.decode((String)p.toCode()), (CoordinateReferenceSystem)targetCRS, (boolean)lenient));
                        }
                        catch (FactoryException e) {
                            Logging.error((String)e.getMessage());
                            Logging.debug((Throwable)e);
                        }
                    }
                }
            }
            if (!result.isEmpty()) {
                if (result.size() > 1) {
                    Logging.warn((String)"Found multiple projections !");
                }
                return (MathTransform)result.get(0);
            }
        }
        return null;
    }

    public static Double get(ParameterValueGroup values, ParameterDescriptor<?> desc) {
        return (Double)values.parameter(desc.getName().getCode()).getValue();
    }

    public static boolean equals(Double a, Double b) {
        boolean res;
        boolean bl = res = Math.abs(a - b) <= Config.getPref().getDouble("opendata.crs.comparison_tolerance", OdConstants.DEFAULT_CRS_COMPARISON_TOLERANCE.doubleValue());
        if (Config.getPref().getBoolean("opendata.crs.comparison_debug", false)) {
            Logging.debug((String)("Comparing " + a + " and " + b + " -> " + res));
        }
        return res;
    }
}

