/*
 * Decompiled with CFR 0.152.
 */
package com.innovant.josm.plugin.routing;

import com.innovant.josm.jrt.core.RoutingGraph;
import com.innovant.josm.jrt.osm.OsmEdge;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.tools.Logging;

public class RoutingModel {
    public final RoutingGraph routingGraph;
    private List<Node> nodes = new ArrayList<Node>();
    private List<OsmEdge> path;
    private boolean changeNodes;
    private boolean changeOneway;

    public RoutingModel(DataSet data) {
        Logging.trace((String)("gr " + String.valueOf(data)));
        this.routingGraph = new RoutingGraph(data);
    }

    public List<Node> getSelectedNodes() {
        return this.nodes;
    }

    public void addNode(Node node) {
        this.nodes.add(node);
        this.changeNodes = true;
    }

    public void removeNode(int index) {
        if (this.nodes.size() > index) {
            this.nodes.remove(index);
            this.changeNodes = true;
        }
    }

    public void insertNode(int index, Node node) {
        if (this.nodes.size() >= index) {
            this.nodes.add(index, node);
            this.changeNodes = true;
        }
    }

    public void reverseNodes() {
        ArrayList<Node> aux = new ArrayList<Node>();
        for (Node n : this.nodes) {
            aux.add(0, n);
        }
        this.nodes = aux;
        this.changeNodes = true;
    }

    public List<OsmEdge> getRouteEdges() {
        if (this.changeNodes || this.path == null) {
            this.path = this.routingGraph.applyAlgorithm(this.nodes, RoutingGraph.Algorithm.ROUTING_ALG_DIJKSTRA);
            this.changeNodes = false;
            this.changeOneway = false;
        }
        return this.path;
    }

    public void setNodesChanged() {
        this.changeNodes = true;
    }

    public void setOnewayChanged() {
        this.changeOneway = true;
    }

    public boolean getOnewayChanged() {
        return this.changeOneway;
    }

    public void reset() {
        this.nodes.clear();
        this.changeNodes = true;
    }
}

