/*
 * Decompiled with CFR 0.152.
 */
package symbols;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;

public final class Symbols {
    public static final Color Yland = new Color(15580172);
    public static final Color Bwater = new Color(10208739);
    public static final Color Gdries = new Color(0x689868);
    public static final Color Mline = new Color(10117240);
    public static final Color Msymb = new Color(10682485);
    public static final Color Mtss = new Color(-1060863745, true);

    private Symbols() {
    }

    public static void drawSymbol(Graphics2D g2, Symbol symbol, double scale, double x, double y, Scheme cs, Delta dd) {
        int pn = 0;
        int cn = 0;
        Patt bpat = Patt.Z;
        Color bcol = null;
        g2.setPaint(Color.black);
        if (cs != null) {
            if (cs.pat.size() > 0 && cs.col.size() > 0 && cs.pat.get(0) == Patt.B) {
                bpat = cs.pat.remove(0);
                bcol = cs.col.remove(0);
            }
            pn = cs.pat.size();
            cn = cs.col.size() - (pn != 0 ? pn - 1 : 0);
            if (pn == 0 && cs.col.size() == 1) {
                g2.setPaint(cs.col.get(0));
            }
        }
        AffineTransform savetr = g2.getTransform();
        g2.translate(x, y);
        g2.scale(scale, scale);
        if (symbol != null) {
            block54: for (Instr item : symbol) {
                switch (item.type.ordinal()) {
                    case 0: {
                        Rectangle2D.Double bbox = (Rectangle2D.Double)item.params;
                        double dx = 0.0;
                        double dy = 0.0;
                        if (dd == null) break;
                        g2.transform(dd.t);
                        switch (dd.h.ordinal()) {
                            case 0: {
                                dx -= bbox.x + bbox.width / 2.0;
                                dy -= bbox.y + bbox.height / 2.0;
                                break;
                            }
                            case 1: {
                                dx -= bbox.x;
                                dy -= bbox.y;
                                break;
                            }
                            case 2: {
                                dx -= bbox.x + bbox.width;
                                dy -= bbox.y;
                                break;
                            }
                            case 3: {
                                dx -= bbox.x + bbox.width / 2.0;
                                dy -= bbox.y;
                                break;
                            }
                            case 4: {
                                dx -= bbox.x;
                                dy -= bbox.y + bbox.height / 2.0;
                                break;
                            }
                            case 5: {
                                dx -= bbox.x + bbox.width;
                                dy -= bbox.y + bbox.height / 2.0;
                                break;
                            }
                            case 6: {
                                dx -= bbox.x;
                                dy -= bbox.y + bbox.height;
                                break;
                            }
                            case 7: {
                                dx -= bbox.x + bbox.width;
                                dy -= bbox.y + bbox.height;
                                break;
                            }
                            case 8: {
                                dx -= bbox.x + bbox.width / 2.0;
                                dy -= bbox.y + bbox.height;
                            }
                        }
                        g2.translate(dx, dy);
                        break;
                    }
                    case 2: {
                        if (cs == null || cs.col == null) break;
                        for (Instr patch : (Symbol)item.params) {
                            switch (patch.type.ordinal()) {
                                case 14: {
                                    if (cn <= 0) break;
                                    Symbol s = (Symbol)patch.params;
                                    Symbols.drawSymbol(g2, s, 1.0, 0.0, 0.0, new Scheme(cs.col.get(0)), null);
                                    break;
                                }
                                case 15: {
                                    if (cn <= 0) break;
                                    Symbol s = (Symbol)patch.params;
                                    Symbols.drawSymbol(g2, s, 1.0, 0.0, 0.0, new Scheme(cn > 1 ? cs.col.get(1) : cs.col.get(0)), null);
                                    break;
                                }
                                case 16: {
                                    if (cn <= 0) break;
                                    g2.setPaint(cs.col.get(0));
                                    g2.fill((Path2D.Double)patch.params);
                                    break;
                                }
                                case 17: {
                                    if (cn <= 0) break;
                                    if (cn > 1) {
                                        g2.setPaint(cs.col.get(1));
                                    } else {
                                        g2.setPaint(cs.col.get(0));
                                    }
                                    g2.fill((Path2D.Double)patch.params);
                                    break;
                                }
                                case 18: {
                                    if (cn <= 1 || pn <= 0 || cs.pat.get(0) != Patt.H) break;
                                    g2.setPaint(cs.col.get(cs.col.size() - pn));
                                    g2.fill((Path2D.Double)patch.params);
                                    break;
                                }
                                case 19: {
                                    if (cn != 3 || pn <= 0 || cs.pat.get(0) != Patt.H) break;
                                    g2.setPaint(cs.col.get(1));
                                    g2.fill((Path2D.Double)patch.params);
                                    break;
                                }
                                case 20: {
                                    if (cn != 4 || pn <= 0 || cs.pat.get(0) != Patt.H) break;
                                    g2.setPaint(cs.col.get(1));
                                    g2.fill((Path2D.Double)patch.params);
                                    break;
                                }
                                case 21: {
                                    if (cn != 4 || pn <= 0 || cs.pat.get(0) != Patt.H) break;
                                    g2.setPaint(cs.col.get(2));
                                    g2.fill((Path2D.Double)patch.params);
                                    break;
                                }
                                case 22: {
                                    if (cn <= 1 || pn <= 0 || cs.pat.get(0) != Patt.V) break;
                                    g2.setPaint(cs.col.get(cs.col.size() - pn));
                                    g2.fill((Path2D.Double)patch.params);
                                    break;
                                }
                                case 23: {
                                    if (cn != 3 || pn <= 0 || cs.pat.get(0) != Patt.V) break;
                                    g2.setPaint(cs.col.get(1));
                                    g2.fill((Path2D.Double)patch.params);
                                    break;
                                }
                                case 27: {
                                    if (bpat != Patt.B) break;
                                    g2.setPaint(bcol);
                                    g2.fill((Path2D.Double)patch.params);
                                    break;
                                }
                                case 28: {
                                    if (cn <= 1 || pn <= 0 || cs.pat.get(0) != Patt.S) break;
                                    g2.setPaint(cs.col.get(1));
                                    g2.fill((Path2D.Double)patch.params);
                                    break;
                                }
                                case 29: {
                                    if (cn <= 2 || pn <= 0 || cs.pat.get(0) != Patt.S) break;
                                    g2.setPaint(cs.col.get(2));
                                    g2.fill((Path2D.Double)patch.params);
                                    break;
                                }
                                case 30: {
                                    if (cn != 4 || pn <= 0 || cs.pat.get(0) != Patt.S) break;
                                    g2.setPaint(cs.col.get(3));
                                    g2.fill((Path2D.Double)patch.params);
                                    break;
                                }
                            }
                        }
                        continue block54;
                    }
                    case 1: {
                        g2.setStroke((BasicStroke)item.params);
                        break;
                    }
                    case 3: {
                        g2.setPaint((Color)item.params);
                        break;
                    }
                    case 4: {
                        g2.draw((Line2D.Double)item.params);
                        break;
                    }
                    case 5: {
                        g2.draw((Rectangle2D.Double)item.params);
                        break;
                    }
                    case 6: {
                        g2.draw((RoundRectangle2D.Double)item.params);
                        break;
                    }
                    case 7: {
                        g2.draw((Ellipse2D.Double)item.params);
                        break;
                    }
                    case 8: {
                        g2.draw((Arc2D.Double)item.params);
                        break;
                    }
                    case 9: {
                        g2.draw((Path2D.Double)item.params);
                        break;
                    }
                    case 10: {
                        g2.fill((Path2D.Double)item.params);
                        break;
                    }
                    case 11: {
                        g2.fill((RectangularShape)item.params);
                        break;
                    }
                    case 13: {
                        SubSymbol s = (SubSymbol)item.params;
                        Symbols.drawSymbol(g2, s.instr, s.scale, s.x, s.y, s.scheme != null ? s.scheme : cs, s.delta);
                        break;
                    }
                    case 12: {
                        Caption c = (Caption)item.params;
                        g2.setPaint(c.colour);
                        TextLayout layout = new TextLayout(c.string, c.font, g2.getFontRenderContext());
                        Rectangle2D bb = layout.getBounds();
                        double dx = 0.0;
                        double dy = 0.0;
                        if (c.dd != null) {
                            if (c.dd.t != null) {
                                g2.transform(c.dd.t);
                            }
                            switch (c.dd.h.ordinal()) {
                                case 0: {
                                    dx -= bb.getX() + bb.getWidth() / 2.0;
                                    dy -= bb.getY() + bb.getHeight() / 2.0;
                                    break;
                                }
                                case 1: {
                                    dx -= bb.getX();
                                    dy -= bb.getY();
                                    break;
                                }
                                case 2: {
                                    dx -= bb.getX() + bb.getWidth();
                                    dy -= bb.getY();
                                    break;
                                }
                                case 3: {
                                    dx -= bb.getX() + bb.getWidth() / 2.0;
                                    dy -= bb.getY();
                                    break;
                                }
                                case 4: {
                                    dx -= bb.getX();
                                    dy -= bb.getY() + bb.getHeight() / 2.0;
                                    break;
                                }
                                case 5: {
                                    dx -= bb.getX() + bb.getWidth();
                                    dy -= bb.getY() + bb.getHeight() / 2.0;
                                    break;
                                }
                                case 6: {
                                    dx -= bb.getX();
                                    dy -= bb.getY() + bb.getHeight();
                                    break;
                                }
                                case 7: {
                                    dx -= bb.getX() + bb.getWidth();
                                    dy -= bb.getY() + bb.getHeight();
                                    break;
                                }
                                case 8: {
                                    dx -= bb.getX() + bb.getWidth() / 2.0;
                                    dy -= bb.getY() + bb.getHeight();
                                }
                            }
                        }
                        layout.draw(g2, (float)dx, (float)dy);
                        break;
                    }
                }
            }
        }
        g2.setTransform(savetr);
    }

    public static enum Patt {
        Z,
        H,
        V,
        D,
        B,
        S,
        C,
        X;

    }

    public static class Scheme {
        public ArrayList<Patt> pat;
        public ArrayList<Color> col;

        public Scheme(ArrayList<Color> icol) {
            this.pat = new ArrayList();
            this.col = icol;
        }

        public Scheme(ArrayList<Patt> ipat, ArrayList<Color> icol) {
            this.pat = ipat;
            this.col = icol;
        }

        public Scheme(Color icol) {
            this.pat = new ArrayList();
            this.col = new ArrayList();
            this.col.add(icol);
        }

        public Scheme() {
            this.pat = new ArrayList();
            this.col = new ArrayList();
        }
    }

    public static class Symbol
    extends ArrayList<Instr> {
    }

    public static class Instr {
        public Form type;
        public Object params;

        public Instr(Form itype, Object iparams) {
            this.type = itype;
            this.params = iparams;
        }
    }

    public static enum Form {
        BBOX,
        STRK,
        COLR,
        FILL,
        LINE,
        RECT,
        RRCT,
        ELPS,
        EARC,
        PLIN,
        PGON,
        RSHP,
        TEXT,
        SYMB,
        N1,
        N2,
        P1,
        P2,
        H2,
        H3,
        H4,
        H5,
        V2,
        V3,
        D2,
        D3,
        D4,
        B1,
        S2,
        S3,
        S4,
        C2,
        X2;

    }

    public static class Delta {
        public Handle h;
        public AffineTransform t;

        public Delta(Handle ih, AffineTransform it) {
            this.h = ih;
            this.t = it;
        }

        public Delta(Handle ih) {
            this.h = ih;
            this.t = new AffineTransform();
        }
    }

    public static enum Handle {
        CC,
        TL,
        TR,
        TC,
        LC,
        RC,
        BL,
        BR,
        BC;

    }

    public static class SubSymbol {
        public Symbol instr;
        public double scale;
        public double x;
        public double y;
        public Delta delta;
        public Scheme scheme;

        public SubSymbol(Symbol iinstr, double iscale, double ix, double iy, Scheme ischeme, Delta idelta) {
            this.instr = iinstr;
            this.scale = iscale;
            this.x = ix;
            this.y = iy;
            this.delta = idelta;
            this.scheme = ischeme;
        }
    }

    public static class Caption {
        public String string;
        public Font font;
        public Color colour;
        public Delta dd;

        public Caption(String istr, Font ifont, Color icolour, Delta idd) {
            this.string = istr;
            this.font = ifont;
            this.colour = icolour;
            this.dd = idd;
        }
    }

    public static class LineStyle {
        public Color line;
        public float width;
        public float[] dash;
        public Color fill;

        public LineStyle(Color ifill) {
            this.line = null;
            this.width = 0.0f;
            this.dash = null;
            this.fill = ifill;
        }

        public LineStyle(Color iline, float iwidth) {
            this.line = iline;
            this.width = iwidth;
            this.dash = null;
            this.fill = null;
        }

        public LineStyle(Color iline, float iwidth, float[] idash) {
            this.line = iline;
            this.width = iwidth;
            this.dash = idash;
            this.fill = null;
        }

        public LineStyle(Color iline, float iwidth, Color ifill) {
            this.line = iline;
            this.width = iwidth;
            this.dash = null;
            this.fill = ifill;
        }

        public LineStyle(Color iline, float iwidth, float[] idash, Color ifill) {
            this.line = iline;
            this.width = iwidth;
            this.dash = idash;
            this.fill = ifill;
        }
    }
}

