/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.editgpx.data;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.WayPoint;

public class EditGpxWayPoint
implements Comparable<EditGpxWayPoint> {
    private final double time;
    private final CachedLatLon coor;
    private boolean deleted;
    private Map<String, Object> attributes;

    public EditGpxWayPoint(WayPoint wayPoint) {
        this.time = wayPoint.getTime();
        this.coor = new CachedLatLon(wayPoint.getCoor());
        this.attributes = new HashMap<String, Object>(wayPoint.attr);
    }

    public WayPoint createWayPoint() {
        WayPoint result = new WayPoint((LatLon)this.getCoor());
        result.setInstant(Instant.ofEpochSecond((long)this.time));
        result.attr = this.attributes;
        return result;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public double getTime() {
        return this.time;
    }

    public CachedLatLon getCoor() {
        return this.coor;
    }

    @Override
    public int compareTo(EditGpxWayPoint o) {
        return Double.compare(this.getTime(), o.getTime());
    }
}

