/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import java.text.DecimalFormat;
import java.util.Collection;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;

public class LiveGpsData {
    private boolean fix = true;
    private LatLon latLon;
    private float course;
    private float speed;
    private float epx;
    private float epy;
    private String wayString;
    private WayPoint waypoint;
    private static final DecimalFormat offsetFormat = new DecimalFormat("0.00");
    private double offs = 0.0;

    public LiveGpsData(double latitude, double longitude, float course, float speed) {
        this.latLon = new LatLon(latitude, longitude);
        this.course = course;
        this.speed = speed;
    }

    public LiveGpsData(double latitude, double longitude, float course, float speed, float epx, float epy) {
        this.latLon = new LatLon(latitude, longitude);
        this.course = course;
        this.speed = speed;
        this.epx = epx;
        this.epy = epy;
    }

    public WayPoint getWaypoint() {
        return this.waypoint;
    }

    public void setWaypoint(WayPoint waypoint) {
        this.waypoint = waypoint;
    }

    public float getCourse() {
        return this.course;
    }

    public void setCourse(float course) {
        this.course = course;
    }

    public boolean isFix() {
        return this.fix;
    }

    public void setFix(boolean haveFix) {
        this.fix = haveFix;
    }

    public double getLatitude() {
        return this.latLon.lat();
    }

    public double getLongitude() {
        return this.latLon.lon();
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public LatLon getLatLon() {
        return this.latLon;
    }

    public void setLatLon(LatLon latLon) {
        this.latLon = latLon;
    }

    public void setEpy(float epy) {
        this.epy = epy;
    }

    public void setEpx(float epx) {
        this.epx = epx;
    }

    public float getEpy() {
        return this.epy;
    }

    public float getEpx() {
        return this.epx;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[fix=" + this.fix + ", lat=" + this.latLon.lat() + ", long=" + this.latLon.lon() + ", speed=" + this.speed + ", course=" + this.course + "]";
    }

    public void setOffset(double offs) {
        this.offs = offs;
    }

    public double getOffset() {
        return this.offs;
    }

    public String getWayInfo() {
        if (this.wayString == null) {
            Node n = new Node(this.latLon);
            Way way = null;
            DataSet ds = MainApplication.getLayerManager().getActiveDataSet();
            if (ds != null) {
                way = (Way)Geometry.getClosestPrimitive((OsmPrimitive)n, (Collection)ds.getWays());
            }
            if (way != null) {
                this.wayString = way.getDisplayName((NameFormatter)new DefaultNameFormatter(){

                    protected void decorateNameWithId(StringBuilder name, IPrimitive primitive) {
                    }

                    protected void decorateNameWithNodes(StringBuilder name, IWay way) {
                    }
                });
                if (this.wayString == null) {
                    this.wayString = I18n.tr((String)"no name", (Object[])new Object[0]);
                }
                if (Config.getPref().getBoolean("livegps.way.offset", false)) {
                    this.offs = Geometry.getDistanceWayNode((Way)way, (Node)n);
                    WaySegment ws = Geometry.getClosestWaySegment((Way)way, (OsmPrimitive)n);
                    if (!Geometry.angleIsClockwise((INode)((Node)ws.getFirstNode()), (INode)((Node)ws.getSecondNode()), (INode)n)) {
                        this.setOffset(-this.offs);
                    }
                    this.wayString = I18n.tr((String)"{0} ({1})", (Object[])new Object[]{offsetFormat.format(this.offs), this.wayString});
                }
            } else {
                this.wayString = "";
            }
        }
        return this.wayString;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.course);
        result = 31 * result + (this.latLon == null ? 0 : this.latLon.hashCode());
        result = 31 * result + Float.floatToIntBits(this.speed);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LiveGpsData)) {
            return false;
        }
        LiveGpsData other = (LiveGpsData)obj;
        if (Float.floatToIntBits(this.course) != Float.floatToIntBits(other.course)) {
            return false;
        }
        if (this.latLon == null ? other.latLon != null : !this.latLon.equals((Object)other.latLon)) {
            return false;
        }
        return Float.floatToIntBits(this.speed) == Float.floatToIntBits(other.speed);
    }
}

