/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tracer2.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ServerParam {
    protected boolean m_bEnabled = false;
    private String m_strName = "Name";
    private String m_strDescription = "";
    private String m_strUrl = "";
    private String m_strTileSize = "0.0004";
    private String m_strResolution = "2048";
    private String m_strSkipBottom = "0";
    private String m_strMode = "boundary";
    private String m_strThreshold = "127";
    private String m_strPointsPerCircle = "16";
    private String m_strTag = "building";
    private String m_strPreferredValues = "yes;house;garage";
    protected JMenuItem m_oMenuItem;

    public boolean isEnabled() {
        return this.m_bEnabled;
    }

    public void setEnabled(boolean enabled) {
        if (!this.m_bEnabled ^ enabled) {
            return;
        }
        this.m_bEnabled = enabled;
    }

    public String getName() {
        return this.m_strName;
    }

    public void setName(String name) {
        this.m_strName = name;
    }

    public String getDescription() {
        return this.m_strDescription;
    }

    public void setDescription(String description) {
        this.m_strDescription = description;
    }

    public String getUrl() {
        return this.m_strUrl;
    }

    public void setUrl(String url) {
        this.m_strUrl = url;
    }

    public String getTileSize() {
        return this.m_strTileSize;
    }

    public void setTileSize(String tileSize) {
        this.m_strTileSize = tileSize;
    }

    public String getResolution() {
        return this.m_strResolution;
    }

    public void setResolution(String resolution) {
        this.m_strResolution = resolution;
    }

    public String getSkipBottom() {
        return this.m_strSkipBottom;
    }

    public void setSkipBottom(String skipBottom) {
        this.m_strSkipBottom = skipBottom;
    }

    public String getMode() {
        return this.m_strMode;
    }

    public void setMode(String mode) {
        this.m_strMode = mode;
    }

    public String getThreshold() {
        return this.m_strThreshold;
    }

    public void setThreshold(String threshold) {
        this.m_strThreshold = threshold;
    }

    public String getPointsPerCircle() {
        return this.m_strPointsPerCircle;
    }

    public void setPointsPerCircle(String pointsPerCircle) {
        this.m_strPointsPerCircle = pointsPerCircle;
    }

    public String getTag() {
        return this.m_strTag;
    }

    public void setTag(String tag) {
        this.m_strTag = tag;
    }

    public String getPreferredValues() {
        return this.m_strPreferredValues;
    }

    public void setPreferredValues(String preferredValues) {
        this.m_strPreferredValues = preferredValues;
    }

    public ServerParam() {
    }

    public ServerParam(String name) {
        this();
        this.m_strName = name;
    }

    public String serialize() {
        StringBuilder oBuilder = new StringBuilder();
        oBuilder.append("name=").append(this.m_strName).append('\n');
        oBuilder.append("description=").append(this.m_strDescription).append('\n');
        oBuilder.append("url=").append(this.m_strUrl).append('\n');
        oBuilder.append("tileSize=").append(this.m_strTileSize).append('\n');
        oBuilder.append("resolution=").append(this.m_strResolution).append('\n');
        oBuilder.append("skipBottom=").append(this.m_strSkipBottom).append('\n');
        oBuilder.append("mode=").append(this.m_strMode).append('\n');
        oBuilder.append("threshold=").append(this.m_strThreshold).append('\n');
        oBuilder.append("pointsPerCircle=").append(this.m_strPointsPerCircle).append('\n');
        oBuilder.append("tag=").append(this.m_strTag).append('\n');
        oBuilder.append("preferredValues=").append(this.m_strPreferredValues).append('\n');
        oBuilder.append("enabled=").append(this.m_bEnabled).append('\n');
        oBuilder.append('\n');
        return oBuilder.toString();
    }

    public static ServerParam unserialize(String str) {
        String[] lines;
        ServerParam oParam = new ServerParam();
        for (String line : lines = str.split("\n")) {
            String[] parts = line.split("=", 2);
            if (parts[0].equals("name")) {
                oParam.m_strName = parts[1];
                continue;
            }
            if (parts[0].equals("description")) {
                oParam.m_strDescription = parts[1];
                continue;
            }
            if (parts[0].equals("url")) {
                oParam.m_strUrl = parts[1];
                continue;
            }
            if (parts[0].equals("tileSize")) {
                oParam.m_strTileSize = parts[1];
                continue;
            }
            if (parts[0].equals("resolution")) {
                oParam.m_strResolution = parts[1];
                continue;
            }
            if (parts[0].equals("skipBottom")) {
                oParam.m_strSkipBottom = parts[1];
                continue;
            }
            if (parts[0].equals("mode")) {
                oParam.m_strMode = parts[1];
                continue;
            }
            if (parts[0].equals("threshold")) {
                oParam.m_strThreshold = parts[1];
                continue;
            }
            if (parts[0].equals("pointsPerCircle")) {
                oParam.m_strPointsPerCircle = parts[1];
                continue;
            }
            if (parts[0].equals("tag")) {
                oParam.m_strTag = parts[1];
                continue;
            }
            if (parts[0].equals("preferredValues")) {
                oParam.m_strPreferredValues = parts[1];
                continue;
            }
            if (!parts[0].equals("enabled")) continue;
            oParam.m_bEnabled = parts[1].equalsIgnoreCase("true");
        }
        return oParam;
    }

    protected void showErrorMessage(String message, String details) {
        final JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JMultilineLabel(message), GBC.eol());
        if (details != null) {
            JTextArea info = new JTextArea(details, 20, 60);
            info.setCaretPosition(0);
            info.setEditable(false);
            p.add((Component)new JScrollPane(info), GBC.eop());
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), p, I18n.tr((String)"Tracer2 error", (Object[])new Object[0]), 0);
            }
        });
    }
}

