/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.editor;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.PrimitiveRenderer;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.plugins.turnrestrictions.dnd.PrimitiveIdListProvider;
import org.openstreetmap.josm.plugins.turnrestrictions.dnd.PrimitiveIdListTransferHandler;
import org.openstreetmap.josm.plugins.turnrestrictions.dnd.PrimitiveIdTransferable;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.ViaListModel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;

public class ViaList
extends JList<OsmPrimitive> {
    private ViaListModel model;
    private DeleteAction actDelete;
    private MoveUpAction actMoveUp;
    private MoveDownAction actMoveDown;
    private CopyAction actCopy;
    private PasteAction actPaste;
    private TransferHandler transferHandler;

    public ViaList(ViaListModel model, DefaultListSelectionModel selectionModel) {
        super(model);
        this.model = model;
        this.setSelectionMode(2);
        this.setSelectionModel(selectionModel);
        this.setCellRenderer(new PrimitiveRenderer());
        this.setDragEnabled(true);
        this.transferHandler = new ViaListTransferHandler(model);
        this.setTransferHandler(this.transferHandler);
        this.setVisibleRowCount(4);
        this.actDelete = new DeleteAction();
        selectionModel.addListSelectionListener(this.actDelete);
        this.registerKeyboardAction(this.actDelete, KeyStroke.getKeyStroke(127, 0), 1);
        this.actMoveDown = new MoveDownAction();
        selectionModel.addListSelectionListener(this.actMoveDown);
        this.registerKeyboardAction(this.actMoveDown, KeyStroke.getKeyStroke(40, 512), 1);
        this.actMoveUp = new MoveUpAction();
        selectionModel.addListSelectionListener(this.actMoveUp);
        this.registerKeyboardAction(this.actMoveUp, KeyStroke.getKeyStroke(38, 512), 1);
        this.actCopy = new CopyAction();
        this.actPaste = new PasteAction();
        this.getSelectionModel().addListSelectionListener(this.actCopy);
        this.addMouseListener((MouseListener)((Object)new ViaListPopupMenuLaucher()));
    }

    class MoveDownAction
    extends AbstractAction
    implements ListSelectionListener {
        MoveDownAction() {
            this.putValue("Name", I18n.tr((String)"Move down", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Move the selected vias down by one position", (Object[])new Object[0]));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, 512));
            new ImageProvider("dialogs", "down").getResource().attachImageIcon((AbstractAction)this);
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ViaList.this.model.moveDown();
        }

        public void updateEnabledState() {
            if (ViaList.this.getSelectedIndex() < 0) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(ViaList.this.getSelectionModel().getMaxSelectionIndex() < ViaList.this.getModel().getSize() - 1);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class MoveUpAction
    extends AbstractAction
    implements ListSelectionListener {
        MoveUpAction() {
            this.putValue("Name", I18n.tr((String)"Move up", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Move the selected vias up by one position", (Object[])new Object[0]));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(38, 512));
            new ImageProvider("dialogs", "up").getResource().attachImageIcon((AbstractAction)this);
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ViaList.this.model.moveUp();
        }

        public void updateEnabledState() {
            if (ViaList.this.getSelectedIndex() < 0) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(ViaList.this.getSelectionModel().getMinSelectionIndex() > 0);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class DeleteAction
    extends AbstractAction
    implements ListSelectionListener {
        DeleteAction() {
            this.putValue("Name", I18n.tr((String)"Remove", (Object[])new Object[0]));
            new ImageProvider("dialogs", "delete").getResource().attachImageIcon((AbstractAction)this);
            this.putValue("ShortDescription", I18n.tr((String)"Remove the currently selected vias", (Object[])new Object[0]));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
            this.updateEnabledState();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        public void updateEnabledState() {
            this.setEnabled(ViaList.this.getSelectedIndex() >= 0);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ViaList.this.model.removeSelectedVias();
        }
    }

    class PasteAction
    extends AbstractAction {
        private Action delegate;

        public boolean canPaste() {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            for (DataFlavor df : clipboard.getAvailableDataFlavors()) {
                if (!df.equals(PrimitiveIdTransferable.PRIMITIVE_ID_LIST_FLAVOR)) continue;
                return true;
            }
            return false;
        }

        PasteAction() {
            this.putValue("Name", I18n.tr((String)"Paste", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Insert ''via'' objects from the clipboard", (Object[])new Object[0]));
            new ImageProvider("paste").getResource().attachImageIcon((AbstractAction)this);
            this.putValue("AcceleratorKey", Shortcut.getPasteKeyStroke());
            this.delegate = ViaList.this.getActionMap().get("paste");
            this.updateEnabledState();
        }

        public void updateEnabledState() {
            this.setEnabled(this.canPaste());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.delegate.actionPerformed(e);
        }
    }

    class CopyAction
    extends AbstractAction
    implements ListSelectionListener {
        private Action delegate;

        CopyAction() {
            this.putValue("Name", I18n.tr((String)"Copy", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Copy the selected vias to the clipboard", (Object[])new Object[0]));
            new ImageProvider("copy").getResource().attachImageIcon((AbstractAction)this);
            this.putValue("AcceleratorKey", Shortcut.getCopyKeyStroke());
            this.delegate = ViaList.this.getActionMap().get("copy");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.delegate.actionPerformed(e);
        }

        protected void updateEnabledState() {
            this.setEnabled(!ViaList.this.model.getSelectedVias().isEmpty());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class ViaListTransferHandler
    extends PrimitiveIdListTransferHandler {
        Logger logger;
        private boolean isViaListInDragOperation;
        private List<Integer> selectedRowsMemento;

        ViaListTransferHandler(PrimitiveIdListProvider provider) {
            super(provider);
            this.logger = Logger.getLogger(ViaListTransferHandler.class.getName());
            this.isViaListInDragOperation = false;
            this.selectedRowsMemento = null;
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            if (this.isViaListInDragOperation) {
                return true;
            }
            return ViaListTransferHandler.isSupportedFlavor(transferFlavors);
        }

        @Override
        public boolean importData(JComponent comp, Transferable t) {
            if (!ViaListTransferHandler.isSupportedFlavor(t.getTransferDataFlavors())) {
                return false;
            }
            if (this.isViaListInDragOperation) {
                int targetRow = ViaList.this.getSelectedIndex();
                if (targetRow < 0) {
                    return true;
                }
                ViaList.this.model.moveVias(this.selectedRowsMemento, targetRow);
            } else {
                try {
                    List idsToAdd = (List)t.getTransferData(PrimitiveIdTransferable.PRIMITIVE_ID_LIST_FLAVOR);
                    ViaList.this.model.insertVias(idsToAdd);
                }
                catch (UnsupportedFlavorException | IOException e) {
                    Logging.error((Throwable)e);
                }
            }
            return true;
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            this.isViaListInDragOperation = false;
            super.exportDone(source, data, action);
        }

        @Override
        public void exportAsDrag(JComponent comp, InputEvent e, int action) {
            this.isViaListInDragOperation = true;
            this.selectedRowsMemento = ViaList.this.model.getSelectedRows();
            super.exportAsDrag(comp, e, action);
        }
    }

    class ViaListPopupMenuLaucher
    extends PopupMenuLauncher {
        ViaListPopupMenuLaucher() {
        }

        public void launch(MouseEvent evt) {
            int idx;
            if (ViaList.this.getSelectedIndex() < 0 && (idx = ViaList.this.locationToIndex(evt.getPoint())) >= 0) {
                ViaList.this.setSelectedIndex(idx);
            }
            new ViaListPopupMenu().show(ViaList.this, evt.getX(), evt.getY());
        }
    }

    class ViaListPopupMenu
    extends JPopupMenu {
        ViaListPopupMenu() {
            JMenuItem item = this.add(ViaList.this.actCopy);
            item.setTransferHandler(ViaList.this.transferHandler);
            item = this.add(ViaList.this.actPaste);
            ViaList.this.actPaste.updateEnabledState();
            item.setTransferHandler(ViaList.this.transferHandler);
            this.addSeparator();
            this.add(ViaList.this.actDelete);
            this.addSeparator();
            this.add(ViaList.this.actMoveUp);
            this.add(ViaList.this.actMoveDown);
        }
    }
}

