/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.editor;

import java.text.MessageFormat;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.ExceptValueModel;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.JosmSelectionListModel;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.NavigationControler;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.RelationMemberEditorModel;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionLegRole;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.IssuesModel;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class TurnRestrictionEditorModel
extends Observable
implements DataSetListener {
    private OsmDataLayer layer;
    private final TagEditorModel tagEditorModel = new TagEditorModel();
    private RelationMemberEditorModel memberModel;
    private IssuesModel issuesModel;
    private NavigationControler navigationControler;
    private JosmSelectionListModel selectionModel;

    public static boolean hasSameMembersAndTags(Relation tp1, Relation tp2) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)tp1, (String)"tp1");
        CheckParameterUtil.ensureParameterNotNull((Object)tp2, (String)"tp2");
        if (!TagCollection.from((Tagged)tp1).asSet().equals(TagCollection.from((Tagged)tp2).asSet())) {
            return false;
        }
        if (tp1.getMembersCount() != tp2.getMembersCount()) {
            return false;
        }
        for (int i = 0; i < tp1.getMembersCount(); ++i) {
            if (tp1.getMember(i).equals((Object)tp2.getMember(i))) continue;
            return false;
        }
        return true;
    }

    public TurnRestrictionEditorModel(OsmDataLayer layer, NavigationControler navigationControler) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)layer, (String)"layer");
        CheckParameterUtil.ensureParameterNotNull((Object)navigationControler, (String)"navigationControler");
        this.layer = layer;
        this.navigationControler = navigationControler;
        this.memberModel = new RelationMemberEditorModel(layer);
        this.memberModel.addTableModelListener(new RelationMemberModelListener());
        this.issuesModel = new IssuesModel(this);
        this.addObserver(this.issuesModel);
        this.tagEditorModel.addTableModelListener((TableModelListener)new TagEditorModelObserver());
        this.selectionModel = new JosmSelectionListModel(layer);
    }

    public JosmSelectionListModel getJosmSelectionListModel() {
        return this.selectionModel;
    }

    public void setTurnRestrictionLeg(TurnRestrictionLegRole role, Way way) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)((Object)role), (String)"role");
        switch (role) {
            case FROM: {
                this.memberModel.setFromPrimitive((PrimitiveId)way);
                break;
            }
            case TO: {
                this.memberModel.setToPrimitive((PrimitiveId)way);
            }
        }
    }

    public void setTurnRestrictionLeg(TurnRestrictionLegRole role, PrimitiveId wayId) {
        CheckParameterUtil.ensureParameterNotNull((Object)((Object)role), (String)"role");
        if (wayId == null) {
            this.setTurnRestrictionLeg(role, (Way)null);
            return;
        }
        if (!wayId.getType().equals((Object)OsmPrimitiveType.WAY)) {
            throw new IllegalArgumentException(MessageFormat.format("parameter ''wayId'' of type {0} expected, got {1}", OsmPrimitiveType.WAY, wayId.getType()));
        }
        OsmPrimitive p = this.layer.data.getPrimitiveById(wayId);
        if (p == null) {
            throw new IllegalStateException(MessageFormat.format("didn''t find way with id {0} in layer ''{1}''", wayId, this.layer.getName()));
        }
        this.setTurnRestrictionLeg(role, (Way)p);
    }

    public Set<OsmPrimitive> getTurnRestrictionLeg(TurnRestrictionLegRole role) {
        CheckParameterUtil.ensureParameterNotNull((Object)((Object)role), (String)"role");
        switch (role) {
            case FROM: {
                return this.memberModel.getFromPrimitives();
            }
            case TO: {
                return this.memberModel.getToPrimitives();
            }
        }
        return null;
    }

    protected void initFromTurnRestriction(Relation turnRestriction) {
        this.memberModel.populate(turnRestriction);
        TagCollection tags = TagCollection.from((Tagged)turnRestriction);
        tags.setUniqueForKey("type", "restriction");
        this.tagEditorModel.initFromTags(tags);
        this.setChanged();
        this.notifyObservers();
    }

    public void populate(Relation turnRestriction) {
        CheckParameterUtil.ensureParameterNotNull((Object)turnRestriction, (String)"turnRestriction");
        if (turnRestriction.getDataSet() != null && turnRestriction.getDataSet() != this.layer.data) {
            throw new IllegalArgumentException(MessageFormat.format("turnRestriction {0} must not belong to a different dataset than the dataset of layer ''{1}''", turnRestriction.getId(), this.layer.getName()));
        }
        this.initFromTurnRestriction(turnRestriction);
    }

    public void apply(Relation turnRestriction) {
        CheckParameterUtil.ensureParameterNotNull((Object)turnRestriction, (String)"turnRestriction");
        TagCollection tags = this.tagEditorModel.getTagCollection();
        turnRestriction.removeAll();
        tags.applyTo((Tagged)turnRestriction);
        this.memberModel.applyTo(turnRestriction);
    }

    public String getRestrictionTagValue() {
        TagCollection tags = this.tagEditorModel.getTagCollection();
        if (!tags.hasTagsFor("restriction")) {
            return "";
        }
        return tags.getJoinedValues("restriction");
    }

    public void setRestrictionTagValue(String value) {
        if (value == null || value.trim().equals("")) {
            this.tagEditorModel.delete("restriction");
        } else {
            TagModel tm = this.tagEditorModel.get("restriction");
            if (tm != null) {
                tm.setValue(value);
            } else {
                this.tagEditorModel.prepend(new TagModel("restriction", value.trim().toLowerCase()));
            }
        }
        this.setChanged();
        this.notifyObservers();
    }

    public List<OsmPrimitive> getVias() {
        return this.memberModel.getVias();
    }

    public void setVias(List<OsmPrimitive> vias) throws IllegalArgumentException {
        this.memberModel.setVias(vias);
    }

    public OsmDataLayer getLayer() {
        return this.layer;
    }

    public void registerAsEventListener() {
        DatasetEventManager.getInstance().addDatasetListener((DataSetListener)this, DatasetEventManager.FireMode.IN_EDT);
    }

    public void unregisterAsEventListener() {
        DatasetEventManager.getInstance().removeDatasetListener((DataSetListener)this);
    }

    public TagEditorModel getTagEditorModel() {
        return this.tagEditorModel;
    }

    public RelationMemberEditorModel getRelationMemberEditorModel() {
        return this.memberModel;
    }

    public IssuesModel getIssuesModel() {
        return this.issuesModel;
    }

    public NavigationControler getNavigationControler() {
        return this.navigationControler;
    }

    public ExceptValueModel getExcept() {
        TagModel tag = this.tagEditorModel.get("except");
        if (tag == null) {
            return new ExceptValueModel("");
        }
        return new ExceptValueModel(tag.getValue());
    }

    public void setExcept(ExceptValueModel value) {
        if (value == null || value.getValue().equals("")) {
            if (this.tagEditorModel.get("except") != null) {
                this.tagEditorModel.delete("except");
                this.setChanged();
                this.notifyObservers();
            }
            return;
        }
        TagModel tag = this.tagEditorModel.get("except");
        if (tag == null) {
            this.tagEditorModel.prepend(new TagModel("except", value.getValue()));
            this.setChanged();
            this.notifyObservers();
        } else if (!tag.getValue().equals(value.getValue())) {
            tag.setValue(value.getValue().trim());
            this.setChanged();
            this.notifyObservers();
        }
    }

    protected boolean isAffectedByDataSetUpdate(DataSet ds, List<? extends OsmPrimitive> updatedPrimitives) {
        if (ds != this.layer.data) {
            return false;
        }
        if (updatedPrimitives == null || updatedPrimitives.isEmpty()) {
            return false;
        }
        Set<OsmPrimitive> myPrimitives = this.memberModel.getMemberPrimitives();
        int size1 = myPrimitives.size();
        myPrimitives.retainAll(updatedPrimitives);
        return size1 != myPrimitives.size();
    }

    public void dataChanged(DataChangedEvent event) {
        this.setChanged();
        this.notifyObservers();
    }

    public void nodeMoved(NodeMovedEvent event) {
        if (this.isAffectedByDataSetUpdate(event.getDataset(), event.getPrimitives())) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    public void primitivesAdded(PrimitivesAddedEvent event) {
    }

    public void primitivesRemoved(PrimitivesRemovedEvent event) {
    }

    public void relationMembersChanged(RelationMembersChangedEvent event) {
    }

    public void tagsChanged(TagsChangedEvent event) {
        if (this.isAffectedByDataSetUpdate(event.getDataset(), event.getPrimitives())) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void wayNodesChanged(WayNodesChangedEvent event) {
        if (this.isAffectedByDataSetUpdate(event.getDataset(), event.getPrimitives())) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    class RelationMemberModelListener
    implements TableModelListener {
        RelationMemberModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            TurnRestrictionEditorModel.this.setChanged();
            TurnRestrictionEditorModel.this.notifyObservers();
        }
    }

    class TagEditorModelObserver
    implements TableModelListener {
        TagEditorModelObserver() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            TurnRestrictionEditorModel.this.setChanged();
            TurnRestrictionEditorModel.this.notifyObservers();
        }
    }
}

