/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.surveyor.action.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.tools.Logging;

public class DialogClosingThread
extends Thread
implements KeyListener,
DocumentListener {
    public static final long DEFAULT_TIMEOUT = 5000L;
    private JDialog dialog;
    private long timeout;
    private long loopCount;

    public DialogClosingThread(JDialog dialog) {
        this(dialog, 5000L);
    }

    public DialogClosingThread(JDialog dialog, long timeout) {
        this.dialog = dialog;
        this.timeout = timeout;
        this.loopCount = timeout / 1000L;
    }

    @Override
    public void run() {
        String title = this.dialog.getTitle();
        while (this.loopCount > 0L) {
            this.dialog.setTitle(title + " (" + this.loopCount + "sec)");
            --this.loopCount;
            try {
                DialogClosingThread.sleep(1000L);
            }
            catch (InterruptedException ignore) {
                Logging.debug((Throwable)ignore);
            }
        }
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    public void reset() {
        this.loopCount = this.timeout / 1000L;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.reset();
        Logging.debug((String)("keypressed: " + e.getKeyCode()));
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.reset();
        Logging.debug((String)("keyreleased: " + e.getKeyCode()));
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.reset();
        Logging.debug((String)("keytyped: " + e.getKeyCode()));
    }

    public void observe(Container container) {
        for (Component component : container.getComponents()) {
            if (component instanceof JTextField) {
                this.observe((JTextField)component);
                continue;
            }
            this.observe(component);
        }
    }

    public void observe(Component component) {
        component.addKeyListener(this);
    }

    public void observe(JTextField textfield) {
        textfield.getDocument().addDocumentListener(this);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.reset();
        Logging.debug((String)("changedUpdate: " + String.valueOf(e)));
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.reset();
        Logging.debug((String)("insertUpdate: " + String.valueOf(e)));
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.reset();
        Logging.debug((String)("removeUpdate: " + String.valueOf(e)));
    }
}

