/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.surveyor;

import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.plugins.surveyor.SurveyorAction;

public final class SurveyorActionFactory {
    private static Map<String, SurveyorAction> actionCache = new HashMap<String, SurveyorAction>();
    public static final String DEFAULT_PACKAGE = SurveyorActionFactory.class.getPackage().getName() + ".action";

    private SurveyorActionFactory() {
    }

    public static SurveyorAction getInstance(String actionClass) {
        try {
            SurveyorAction action = actionCache.get(actionClass);
            if (action == null) {
                try {
                    action = (SurveyorAction)Class.forName((String)actionClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ClassNotFoundException e) {
                    actionClass = DEFAULT_PACKAGE + "." + (String)actionClass;
                    action = (SurveyorAction)Class.forName((String)actionClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                actionCache.put((String)actionClass, action);
            }
            return action;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Could not create action class '" + (String)actionClass + "'", e);
        }
    }
}

