/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.wms;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.WMSLayer;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class RasterImageGeoreferencer
implements MouseListener {
    private int countMouseClicked = 0;
    private int mode = 0;
    private int cGetCorners = 1;
    private int cGetLambertCrosspieces = 2;
    private EastNorth ea1;
    private EastNorth ea2;
    private long mouseClickedTime = 0L;
    private WMSLayer wmsLayer;
    private EastNorth georefpoint1;
    private EastNorth georefpoint2;
    private boolean ignoreMouseClick = false;
    private boolean clickOnTheMap = false;
    private int initialClickDelay;

    public void addListener() {
        MainApplication.getMap().mapView.addMouseListener((MouseListener)this);
    }

    public boolean startCropping(WMSLayer wmsLayer) {
        this.wmsLayer = wmsLayer;
        this.mode = this.cGetCorners;
        this.countMouseClicked = 0;
        this.initialClickDelay = Config.getPref().getInt("cadastrewms.georef-click-delay", 200);
        this.mouseClickedTime = System.currentTimeMillis();
        Object[] options = new Object[]{"OK", "Cancel"};
        int ret = (Integer)GuiHelper.runInEDTAndWaitAndReturn(() -> JOptionPane.showOptionDialog(null, I18n.tr((String)"Click first corner for image cropping\n(two points required)", (Object[])new Object[0]), I18n.tr((String)"Image cropping", (Object[])new Object[0]), -1, 1, null, options, options[0]));
        if (ret == 0) {
            this.mouseClickedTime = System.currentTimeMillis();
        } else if (this.canceledOrRestartCurrAction("image cropping")) {
            return this.startCropping(wmsLayer);
        }
        return true;
    }

    public boolean startGeoreferencing(WMSLayer wmsLayer) {
        this.wmsLayer = wmsLayer;
        this.countMouseClicked = 0;
        this.mode = this.cGetLambertCrosspieces;
        this.initialClickDelay = Config.getPref().getInt("cadastrewms.georef-click-delay", 200);
        this.mouseClickedTime = System.currentTimeMillis();
        Object[] options = new Object[]{"OK", "Cancel"};
        int ret = JOptionPane.showOptionDialog(null, I18n.tr((String)"Click first Lambert crosspiece for georeferencing\n(two points required)", (Object[])new Object[0]), I18n.tr((String)"Image georeferencing", (Object[])new Object[0]), -1, 1, null, options, options[0]);
        if (ret == 0) {
            this.mouseClickedTime = System.currentTimeMillis();
        } else if (this.canceledOrRestartCurrAction("georeferencing")) {
            return this.startGeoreferencing(wmsLayer);
        }
        return true;
    }

    public boolean isRunning() {
        return this.countMouseClicked != 0 || this.mode != 0;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (System.currentTimeMillis() - this.mouseClickedTime < (long)this.initialClickDelay) {
            Logging.info((String)"mouse click bounce detected");
            return;
        }
        this.mouseClickedTime = System.currentTimeMillis();
        if (e.getButton() != 1) {
            return;
        }
        if (this.ignoreMouseClick) {
            return;
        }
        EastNorth ea = ProjectionRegistry.getProjection().latlon2eastNorth(MainApplication.getMap().mapView.getLatLon(e.getX(), e.getY()));
        Logging.info((String)("click:" + this.countMouseClicked + " ," + String.valueOf(ea) + ", mode:" + this.mode));
        if (this.clickOnTheMap) {
            this.clickOnTheMap = false;
            this.handleNewCoordinates(ea.east(), ea.north());
        } else {
            if (ea.east() < this.wmsLayer.getImage((int)0).min.east() || ea.east() > this.wmsLayer.getImage((int)0).max.east() || ea.north() < this.wmsLayer.getImage((int)0).min.north() || ea.north() > this.wmsLayer.getImage((int)0).max.north()) {
                Logging.info((String)"ignore click outside the image");
                return;
            }
            ++this.countMouseClicked;
            if (this.mode == this.cGetCorners) {
                if (this.countMouseClicked == 1) {
                    this.ea1 = ea;
                    this.continueCropping();
                }
                if (this.countMouseClicked == 2) {
                    this.wmsLayer.cropImage(this.ea1, ea);
                    this.wmsLayer.invalidate();
                    this.startGeoreferencing(this.wmsLayer);
                }
            } else if (this.mode == this.cGetLambertCrosspieces) {
                if (this.countMouseClicked == 1) {
                    this.ea1 = ea;
                    this.inputLambertPosition();
                }
                if (this.countMouseClicked == 2) {
                    this.ea2 = ea;
                    this.inputLambertPosition();
                }
            }
        }
    }

    private boolean canceledOrRestartCurrAction(String action) {
        Object[] options = new Object[]{"Cancel", "Retry"};
        int selectedValue = JOptionPane.showOptionDialog(null, I18n.tr((String)("Do you want to cancel completely\nor just retry " + action + " ?"), (Object[])new Object[0]), "", -1, 2, null, options, options[0]);
        this.countMouseClicked = 0;
        if (selectedValue == 0) {
            MainApplication.getLayerManager().removeLayer((Layer)this.wmsLayer);
            this.wmsLayer = null;
            MainApplication.getMap().mapView.removeMouseListener((MouseListener)this);
            return false;
        }
        return true;
    }

    private void affineTransform(EastNorth org1, EastNorth org2, EastNorth dst1, EastNorth dst2) {
        if (org1 == null || org2 == null || dst1 == null || dst2 == null) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Ooops. I failed to catch all coordinates\ncorrectly. Retry please.", (Object[])new Object[0]));
            Logging.warn((String)("failed to transform: one coordinate missing:org1=" + String.valueOf(org1) + ", org2=" + String.valueOf(org2) + ", dst1=" + String.valueOf(dst1) + ", dst2=" + String.valueOf(dst2)));
            return;
        }
        double angle = dst1.heading(dst2) - org1.heading(org2);
        double proportion = dst1.distance(dst2) / org1.distance(org2);
        double dx = dst1.getX() - org1.getX();
        double dy = dst1.getY() - org1.getY();
        this.wmsLayer.getImage(0).shear(dx, dy);
        this.wmsLayer.getImage(0).rotate(dst1, angle);
        this.wmsLayer.getImage(0).scale(dst1, proportion);
    }

    private void endGeoreferencing() {
        MainApplication.getMap().mapView.removeMouseListener((MouseListener)this);
        this.affineTransform(this.ea1, this.ea2, this.georefpoint1, this.georefpoint2);
        this.wmsLayer.grabThread.saveNewCache();
        this.wmsLayer.invalidate();
        this.actionCompleted();
        this.clickOnTheMap = false;
        this.ignoreMouseClick = false;
    }

    private void inputLambertPosition() {
        JLabel labelEnterPosition = new JLabel(I18n.tr((String)"Enter cadastre east,north position", (Object[])new Object[0]));
        JLabel labelWarning = new JLabel(I18n.tr((String)"(Warning: verify north with arrow !!)", (Object[])new Object[0]));
        JPanel p = new JPanel(new GridBagLayout());
        JLabel labelEast = new JLabel(I18n.tr((String)"East", (Object[])new Object[0]));
        JLabel labelNorth = new JLabel(I18n.tr((String)"North", (Object[])new Object[0]));
        final JTextField inputEast = new JTextField();
        final JTextField inputNorth = new JTextField();
        p.add((Component)labelEnterPosition, GBC.eol());
        p.add((Component)labelWarning, GBC.eol());
        p.add((Component)labelEast, GBC.std().insets(0, 0, 10, 0));
        p.add((Component)inputEast, GBC.eol().fill(2).insets(10, 5, 0, 5));
        p.add((Component)labelNorth, GBC.std().insets(0, 0, 10, 0));
        p.add((Component)inputNorth, GBC.eol().fill(2).insets(10, 5, 0, 5));
        final Object[] options = new Object[]{I18n.tr((String)"OK", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0]), I18n.tr((String)"I use the mouse", (Object[])new Object[0])};
        final JOptionPane pane = new JOptionPane(p, 1, 1, null, options, options[0]);
        String number = this.countMouseClicked == 1 ? "first" : "second";
        JDialog dialog = pane.createDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Set {0} Lambert coordinates", (Object[])new Object[]{number}));
        dialog.setModal(false);
        this.ignoreMouseClick = true;
        dialog.setAlwaysOnTop(true);
        dialog.setVisible(true);
        pane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("value".equals(evt.getPropertyName())) {
                    RasterImageGeoreferencer.this.ignoreMouseClick = false;
                    if (pane.getValue().equals(options[1]) && RasterImageGeoreferencer.this.canceledOrRestartCurrAction("georeferencing")) {
                        RasterImageGeoreferencer.this.startGeoreferencing(RasterImageGeoreferencer.this.wmsLayer);
                    }
                    if (pane.getValue().equals(options[2])) {
                        RasterImageGeoreferencer.this.clickOnTheMap = true;
                    } else {
                        RasterImageGeoreferencer.this.clickOnTheMap = false;
                        if (inputEast.getText().length() != 0 && inputNorth.getText().length() != 0) {
                            double n;
                            double e;
                            try {
                                e = Double.parseDouble(inputEast.getText());
                                n = Double.parseDouble(inputNorth.getText());
                            }
                            catch (NumberFormatException ex) {
                                return;
                            }
                            RasterImageGeoreferencer.this.handleNewCoordinates(e, n);
                        }
                    }
                }
            }
        });
    }

    private boolean continueCropping() {
        Object[] options = new Object[]{"OK", "Cancel"};
        int ret = JOptionPane.showOptionDialog(null, I18n.tr((String)"Click second corner for image cropping", (Object[])new Object[0]), I18n.tr((String)"Image cropping", (Object[])new Object[0]), -1, 1, null, options, options[0]);
        if (ret != 0 && this.canceledOrRestartCurrAction("image cropping")) {
            return this.startCropping(this.wmsLayer);
        }
        return true;
    }

    public void transformGeoreferencedImg() {
        this.georefpoint1 = new EastNorth(this.wmsLayer.X0, this.wmsLayer.Y0);
        this.georefpoint2 = new EastNorth(this.wmsLayer.X0 + this.wmsLayer.fX * this.wmsLayer.communeBBox.max.getX(), this.wmsLayer.Y0 + this.wmsLayer.fY * this.wmsLayer.communeBBox.max.getX());
        this.ea1 = new EastNorth(this.wmsLayer.getImage((int)0).min.east(), this.wmsLayer.getImage((int)0).max.north());
        EastNorth ea2 = this.wmsLayer.getImage((int)0).max;
        this.affineTransform(this.ea1, ea2, this.georefpoint1, this.georefpoint2);
        this.wmsLayer.grabThread.saveNewCache();
        this.wmsLayer.invalidate();
    }

    private boolean continueGeoreferencing() {
        Object[] options = new Object[]{"OK", "Cancel"};
        int ret = JOptionPane.showOptionDialog(null, I18n.tr((String)"Click second Lambert crosspiece for georeferencing", (Object[])new Object[0]), I18n.tr((String)"Image georeferencing", (Object[])new Object[0]), -1, 1, null, options, options[0]);
        if (ret != 0 && this.canceledOrRestartCurrAction("georeferencing")) {
            return this.startGeoreferencing(this.wmsLayer);
        }
        return true;
    }

    private void handleNewCoordinates(double e, double n) {
        if (this.countMouseClicked == 1) {
            this.georefpoint1 = new EastNorth(e, n);
            this.continueGeoreferencing();
        } else {
            this.georefpoint2 = new EastNorth(e, n);
            this.endGeoreferencing();
        }
    }

    private void actionCompleted() {
        this.countMouseClicked = 0;
        this.mode = 0;
        this.mouseClickedTime = System.currentTimeMillis();
    }

    public void actionInterrupted() {
        this.actionCompleted();
        if (this.wmsLayer != null) {
            MainApplication.getLayerManager().removeLayer((Layer)this.wmsLayer);
            this.wmsLayer = null;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

