/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.wms;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.fr.cadastre.CadastrePlugin;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.CadastreInterface;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.GeorefImage;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.ImageModifier;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.RasterImageModifier;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.VectorImageModifier;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.WMSLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class CadastreGrabber {
    private CadastreInterface wmsInterface = new CadastreInterface();

    GeorefImage grab(WMSLayer wmsLayer, EastNorth lambertMin, EastNorth lambertMax) throws IOException, OsmTransferException {
        try {
            URL url = null;
            url = wmsLayer.isRaster() ? CadastreGrabber.getURLRaster(wmsLayer, lambertMin, lambertMax) : CadastreGrabber.getURLVector(lambertMin, lambertMax);
            BufferedImage img = this.grab(url);
            if (img == null) {
                throw new OsmTransferException(url.toString());
            }
            ImageModifier imageModified = wmsLayer.isRaster() ? new RasterImageModifier(img) : new VectorImageModifier(img, false);
            return new GeorefImage(imageModified.getBufferedImage(), lambertMin, lambertMax, wmsLayer);
        }
        catch (MalformedURLException e) {
            throw (IOException)new IOException(I18n.tr((String)"CadastreGrabber: Illegal url.", (Object[])new Object[0])).initCause(e);
        }
    }

    private static URL getURLRaster(WMSLayer wmsLayer, EastNorth lambertMin, EastNorth lambertMax) throws MalformedURLException {
        int cRasterX = CadastrePlugin.imageWidth;
        Object str = "https://www.cadastre.gouv.fr/scpc/wms?version=1.1&request=GetMap";
        str = (String)str + "&layers=CDIF:PMC@";
        str = (String)str + wmsLayer.getCodeCommune();
        str = (String)str + "&format=image/png";
        str = (String)str + "&bbox=";
        str = (String)str + wmsLayer.eastNorth2raster(lambertMin, lambertMax);
        str = (String)str + "&width=" + cRasterX + "&height=";
        str = (String)str + (int)((double)cRasterX * (wmsLayer.communeBBox.max.getY() - wmsLayer.communeBBox.min.getY()) / (wmsLayer.communeBBox.max.getX() - wmsLayer.communeBBox.min.getX()));
        str = (String)str + "&exception=application/vnd.ogc.se_inimage&styles=";
        Logging.info((String)("URL=" + (String)str));
        return new URL(((String)str).replace(" ", "%20"));
    }

    private static URL buildURLVector(String layers, String styles, int width, int height, EastNorth lambertMin, EastNorth lambertMax) throws MalformedURLException {
        Object str = "https://www.cadastre.gouv.fr/scpc/wms?version=1.1&request=GetMap";
        str = (String)str + "&layers=" + layers;
        str = (String)str + "&format=image/png";
        str = (String)str + "&bbox=" + lambertMin.east() + ",";
        str = (String)str + lambertMin.north() + ",";
        str = (String)str + lambertMax.east() + ",";
        str = (String)str + lambertMax.north();
        str = (String)str + "&width=" + width + "&height=" + height;
        str = (String)str + "&exception=application/vnd.ogc.se_inimage";
        str = (String)str + "&styles=" + styles;
        Logging.info((String)("URL=" + (String)str));
        return new URL(((String)str).replace(" ", "%20"));
    }

    private static URL getURLVector(EastNorth lambertMin, EastNorth lambertMax) throws MalformedURLException {
        return CadastreGrabber.buildURLVector(CadastrePlugin.grabLayers, CadastrePlugin.grabStyles, CadastrePlugin.imageWidth, CadastrePlugin.imageHeight, lambertMin, lambertMax);
    }

    private BufferedImage grab(URL url) throws IOException, OsmTransferException {
        try (InputStream is = this.wmsInterface.getContent(url);){
            BufferedImage bufferedImage = ImageIO.read(is);
            return bufferedImage;
        }
    }

    CadastreInterface getWmsInterface() {
        return this.wmsInterface;
    }
}

