/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.edigeo;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoCharset;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoFileTHF;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoLotFile;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoRecord;

public class EdigeoFileDIC
extends EdigeoLotFile<DicBlock> {
    public EdigeoFileDIC(EdigeoFileTHF.Lot lot, String seId, Path path) throws IOException {
        super(lot, seId, path);
        this.register("DID", ObjectDef.class);
        this.register("DIA", AttributeDef.class);
        this.register("DIR", RelationDef.class);
        lot.dic = this;
    }

    public final List<ObjectDef> getObjects() {
        return Collections.unmodifiableList(this.blocks.getInstances(ObjectDef.class));
    }

    public final List<AttributeDef> getAttributes() {
        return Collections.unmodifiableList(this.blocks.getInstances(AttributeDef.class));
    }

    public final List<RelationDef> getRelations() {
        return Collections.unmodifiableList(this.blocks.getInstances(RelationDef.class));
    }

    public static class ObjectDef
    extends DicBlock {
        ObjectDef(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type);
        }

        public String toString() {
            return "ObjectDef [code=" + this.code + ", charset=" + String.valueOf((Object)this.charset) + ", definition=" + this.definition + ", origin=" + this.origin + ", type=" + this.type + ", identifier=" + this.identifier + "]";
        }
    }

    public static class AttributeDef
    extends CategorizedBlock {
        EdigeoRecord.Format type;
        String unit = "";
        int nValues;
        final List<String> values = new ArrayList<String>();
        final List<String> descrs = new ArrayList<String>();

        AttributeDef(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type);
        }

        @Override
        void processRecord(EdigeoRecord r) {
            switch (r.name) {
                case "TYP": {
                    this.type = EdigeoRecord.Format.of(this.safeGetChar(r));
                    break;
                }
                case "UNI": {
                    this.safeGet(r, (String s) -> {
                        this.unit = this.unit + s;
                    });
                    break;
                }
                case "AVC": {
                    this.nValues = this.safeGetInt(r);
                    break;
                }
                case "AVL": {
                    this.safeGet(r, this.values);
                    break;
                }
                case "AVD": {
                    this.safeGet(r, this.descrs);
                    break;
                }
                default: {
                    super.processRecord(r);
                }
            }
        }

        public final EdigeoRecord.Format getType() {
            return this.type;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final int getNumberOfValues() {
            return this.nValues;
        }

        public final List<String> getValues() {
            return Collections.unmodifiableList(this.values);
        }

        public final List<String> getDescriptions() {
            return Collections.unmodifiableList(this.descrs);
        }

        public String toString() {
            return "AttributeDef [type=" + String.valueOf((Object)this.type) + ", unit=" + this.unit + ", values=" + String.valueOf(this.values) + ", descrs=" + String.valueOf(this.descrs) + ", category=" + String.valueOf((Object)this.category) + ", code=" + this.code + ", definition=" + this.definition + ", origin=" + this.origin + ", identifier=" + this.identifier + "]";
        }
    }

    public static class RelationDef
    extends CategorizedBlock {
        RelationDef(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type);
        }

        public String toString() {
            return "RelationDef [category=" + String.valueOf((Object)this.category) + ", code=" + this.code + ", charset=" + String.valueOf((Object)this.charset) + ", definition=" + this.definition + ", origin=" + this.origin + ", type=" + this.type + ", identifier=" + this.identifier + "]";
        }
    }

    static abstract class CategorizedBlock
    extends DicBlock {
        Category category;

        CategorizedBlock(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type);
        }

        @Override
        void processRecord(EdigeoRecord r) {
            switch (r.name) {
                case "CAT": {
                    this.category = Category.of(this.safeGetChar(r));
                    break;
                }
                default: {
                    super.processRecord(r);
                }
            }
        }

        @Override
        boolean isValid() {
            return super.isValid() && CategorizedBlock.areNotNull(new Object[]{this.category});
        }

        public final Category getCategory() {
            return this.category;
        }

        static enum Category {
            GENERAL('G'),
            SPECIFIC('P');

            final char code;

            private Category(char code) {
                this.code = code;
            }

            public static Category of(char code) {
                for (Category s : Category.values()) {
                    if (s.code != code) continue;
                    return s;
                }
                throw new IllegalArgumentException(Character.toString(code));
            }
        }
    }

    static abstract class DicBlock
    extends EdigeoFileTHF.ChildBlock {
        String code = "";
        EdigeoCharset charset;
        String definition = "";
        String origin = "";

        DicBlock(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type);
        }

        @Override
        void processRecord(EdigeoRecord r) {
            switch (r.name) {
                case "LAB": {
                    this.safeGet(r, (String s) -> {
                        this.code = this.code + s;
                    });
                    break;
                }
                case "TEX": {
                    this.safeGet(r, (String s) -> {
                        this.charset = EdigeoCharset.of(s);
                    });
                    break;
                }
                case "DEF": {
                    this.safeGet(r, (String s) -> {
                        this.definition = this.definition + s;
                    });
                    break;
                }
                case "ORI": {
                    this.safeGet(r, (String s) -> {
                        this.origin = this.origin + s;
                    });
                    break;
                }
                default: {
                    super.processRecord(r);
                }
            }
        }

        @Override
        boolean isValid() {
            return super.isValid() && DicBlock.areNotEmpty(this.code);
        }

        public final String getCode() {
            return this.code;
        }

        public final String getDefinition() {
            return this.definition;
        }

        public final String getOrigin() {
            return this.origin;
        }
    }
}

