/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.actions.mapmode;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.CacheControl;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.WMSLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class WMSAdjustAction
extends MapMode {
    private static final long serialVersionUID = 1L;
    private transient WMSLayer modifiedLayer;
    private boolean rasterMoved;
    private EastNorth prevEastNorth;
    private static Mode mode;
    private static final EastNorth[] croppedRaster;

    public WMSAdjustAction() {
        super(I18n.tr((String)"Adjust WMS", (Object[])new Object[0]), "adjustxywms", I18n.tr((String)"Adjust the position of the WMS layer (saved for raster images only)", (Object[])new Object[0]), ImageProvider.getCursor((String)"normal", (String)"move"));
    }

    public void enterMode() {
        if (MainApplication.getMap() != null) {
            if (MainApplication.getLayerManager().getActiveLayer() instanceof WMSLayer) {
                this.modifiedLayer = (WMSLayer)MainApplication.getLayerManager().getActiveLayer();
                super.enterMode();
                MainApplication.getMap().mapView.addMouseListener((MouseListener)((Object)this));
                MainApplication.getMap().mapView.addMouseMotionListener((MouseMotionListener)((Object)this));
                this.rasterMoved = false;
                this.modifiedLayer.adjustModeEnabled = true;
            } else {
                if (Boolean.TRUE.equals(this.getValue("active"))) {
                    this.exitMode();
                }
                MainApplication.getMap().selectMapMode((MapMode)MainApplication.getMap().getDefaultButtonAction());
            }
        }
    }

    public void exitMode() {
        int reply;
        try {
            super.exitMode();
        }
        catch (IllegalArgumentException e) {
            Logging.error((Throwable)e);
        }
        MainApplication.getMap().mapView.removeMouseListener((MouseListener)((Object)this));
        MainApplication.getMap().mapView.removeMouseMotionListener((MouseMotionListener)((Object)this));
        if (this.rasterMoved && CacheControl.cacheEnabled && this.modifiedLayer.isRaster() && (reply = JOptionPane.showConfirmDialog(null, "Save the changes in cache ?", "Update cache", 0)) == 0) {
            this.saveModifiedLayers();
        }
        this.rasterMoved = false;
        if (this.modifiedLayer != null) {
            this.modifiedLayer.adjustModeEnabled = false;
            this.modifiedLayer = null;
        }
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        this.requestFocusInMapView();
        this.updateKeyModifiers(e);
        if (this.shift && !this.ctrl && this.modifiedLayer.isRaster()) {
            WMSAdjustAction.setMode(Mode.MOVE_Z);
        } else if (this.shift && this.ctrl && this.modifiedLayer.isRaster()) {
            WMSAdjustAction.setMode(Mode.ROTATE);
        } else {
            WMSAdjustAction.setMode(Mode.MOVE_XY);
        }
        this.rasterMoved = true;
        this.prevEastNorth = MainApplication.getMap().mapView.getEastNorth(e.getX(), e.getY());
        MainApplication.getMap().mapView.setCursor(Cursor.getPredefinedCursor(13));
    }

    public void mouseDragged(MouseEvent e) {
        EastNorth newEastNorth = MainApplication.getMap().mapView.getEastNorth(e.getX(), e.getY());
        if (mode == Mode.ROTATE) {
            WMSAdjustAction.rotateFrameOnly(this.modifiedLayer, this.prevEastNorth, newEastNorth);
        } else {
            if (mode == Mode.MOVE_XY) {
                this.displace(this.prevEastNorth, newEastNorth);
            } else if (mode == Mode.MOVE_Z) {
                this.resize(newEastNorth);
            }
            this.prevEastNorth = newEastNorth;
        }
        if (this.modifiedLayer != null) {
            this.modifiedLayer.invalidate();
        }
    }

    public static void paintAdjustFrames(Graphics2D g, MapView mv) {
        if (mode == Mode.ROTATE) {
            g.setColor(Color.red);
            for (int i = 0; i < 4; ++i) {
                g.drawLine(mv.getPoint((EastNorth)WMSAdjustAction.croppedRaster[i]).x, mv.getPoint((EastNorth)WMSAdjustAction.croppedRaster[i]).y, mv.getPoint((EastNorth)WMSAdjustAction.croppedRaster[i + 1]).x, mv.getPoint((EastNorth)WMSAdjustAction.croppedRaster[i + 1]).y);
            }
        }
    }

    private void displace(EastNorth start, EastNorth end) {
        this.modifiedLayer.displace(end.east() - start.east(), end.north() - start.north());
    }

    private void resize(EastNorth newEastNorth) {
        EastNorth center = this.modifiedLayer.getRasterCenter();
        double dPrev = this.prevEastNorth.distance(center.east(), center.north());
        double dNew = newEastNorth.distance(center.east(), center.north());
        this.modifiedLayer.resize(center, dNew / dPrev);
    }

    private void rotate(EastNorth start, EastNorth end) {
        EastNorth pivot = this.modifiedLayer.getRasterCenter();
        double startAngle = Math.atan2(start.east() - pivot.east(), start.north() - pivot.north());
        double endAngle = Math.atan2(end.east() - pivot.east(), end.north() - pivot.north());
        double rotationAngle = endAngle - startAngle;
        this.modifiedLayer.rotate(pivot, rotationAngle);
    }

    private static void rotateFrameOnly(WMSLayer modifiedLayer, EastNorth start, EastNorth end) {
        if (start != null && end != null) {
            EastNorth pivot = modifiedLayer.getRasterCenter();
            double startAngle = Math.atan2(start.east() - pivot.east(), start.north() - pivot.north());
            double endAngle = Math.atan2(end.east() - pivot.east(), end.north() - pivot.north());
            double rotationAngle = endAngle - startAngle;
            if (modifiedLayer.getImage((int)0).orgCroppedRaster != null) {
                for (int i = 0; i < 4; ++i) {
                    WMSAdjustAction.croppedRaster[i] = modifiedLayer.getImage((int)0).orgCroppedRaster[i].rotate(pivot, rotationAngle);
                }
                WMSAdjustAction.croppedRaster[4] = croppedRaster[0];
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (mode == Mode.ROTATE) {
            EastNorth newEastNorth = MainApplication.getMap().mapView.getEastNorth(e.getX(), e.getY());
            this.rotate(this.prevEastNorth, newEastNorth);
            if (this.modifiedLayer != null) {
                this.modifiedLayer.invalidate();
            }
        }
        MainApplication.getMap().mapView.setCursor(Cursor.getDefaultCursor());
        this.prevEastNorth = null;
        WMSAdjustAction.setMode(null);
    }

    private static void setMode(Mode mode) {
        WMSAdjustAction.mode = mode;
    }

    private void saveModifiedLayers() {
        this.modifiedLayer.grabThread.saveNewCache();
    }

    static {
        croppedRaster = new EastNorth[5];
    }

    static enum Mode {
        MOVE_XY,
        MOVE_Z,
        ROTATE;

    }
}

