/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.actions.mapmode;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IWaySegment;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmDataManager;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

public class Address
extends MapMode {
    private static final String MESSAGE_UNABLE_TO_PARSE_HOUSE_NUMBER = "Unable to parse house number \"{0}\"";
    private static final String TAG_HIGHWAY = "highway";
    private static final String TAG_HIGHWAY_NAME = "name";
    private static final String TAG_HOUSE_NUMBER = "addr:housenumber";
    private static final String TAG_HOUSE_STREET = "addr:street";
    private static final String TAG_BUILDING = "building";
    private static final String RELATION_ADDR_TYPE = "associatedStreet";
    private static final String RELATION_ADDR_NAME = "name";
    private static final String RELATION_ADDR_STREET_ROLE = "street";
    private static final String RELATION_MEMBER_HOUSE = "house";
    private JRadioButton plusOne = new JRadioButton("+1", false);
    private JRadioButton plusTwo = new JRadioButton("+2", true);
    private JRadioButton minusOne = new JRadioButton("-1", false);
    private JRadioButton minusTwo = new JRadioButton("-2", false);
    final JCheckBox tagPolygon = new JCheckBox(I18n.tr((String)"on polygon", (Object[])new Object[0]));
    JDialog dialog;
    JButton clearButton;
    final JTextField inputNumber = new JTextField();
    final JTextField inputStreet = new JTextField();
    JLabel link = new JLabel();
    private transient Way selectedWay;

    public Address() {
        super(I18n.tr((String)"Add address", (Object[])new Object[0]), "buildings", I18n.tr((String)"Helping tool for tag address", (Object[])new Object[0]), Shortcut.registerShortcut((String)"mapmode:cadastre-fr-buildings", (String)I18n.tr((String)"Mode: {0}", (Object[])new Object[]{I18n.tr((String)"CadastreFR - Buildings", (Object[])new Object[0])}), (int)69, (int)5003), Address.getCursor());
    }

    public void enterMode() {
        super.enterMode();
        if (this.dialog == null) {
            this.createDialog();
        }
        this.dialog.setVisible(true);
        MainApplication.getMap().mapView.addMouseListener((MouseListener)((Object)this));
    }

    public void exitMode() {
        if (MainApplication.getMap().mapView != null) {
            super.exitMode();
            MainApplication.getMap().mapView.removeMouseListener((MouseListener)((Object)this));
        }
        if (this.dialog != null) {
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        this.updateKeyModifiers(e);
        MapView mv = MainApplication.getMap().mapView;
        Point mousePos = e.getPoint();
        Node currentMouseNode = mv.getNearestNode(mousePos, OsmPrimitive::isSelectable);
        if (currentMouseNode != null) {
            this.mousePressedExistingNode(currentMouseNode);
        } else {
            this.mousePressedNoExistingNode(e, mousePos, mv);
        }
    }

    private void mousePressedExistingNode(Node currentMouseNode) {
        Address.setNewSelection((OsmPrimitive)currentMouseNode);
        String num = currentMouseNode.get(TAG_HOUSE_NUMBER);
        if (num != null && currentMouseNode.get(TAG_HOUSE_STREET) == null && Address.findWayInRelationAddr(currentMouseNode) == null && !this.inputStreet.getText().isEmpty()) {
            LinkedList<Command> cmds = new LinkedList<Command>();
            this.addStreetNameOrRelation((OsmPrimitive)currentMouseNode, cmds);
            SequenceCommand c = new SequenceCommand("Add node address", cmds);
            UndoRedoHandler.getInstance().add((Command)c);
            Address.setNewSelection((OsmPrimitive)currentMouseNode);
        } else {
            if (num != null) {
                try {
                    Integer.parseInt(num);
                    this.inputNumber.setText(num);
                    this.applyInputNumberChange();
                }
                catch (NumberFormatException ex) {
                    Logging.warn((String)MESSAGE_UNABLE_TO_PARSE_HOUSE_NUMBER, (Object[])new Object[]{num});
                }
            }
            this.mousePressedExistingNode(currentMouseNode, num);
        }
    }

    private void mousePressedExistingNode(Node currentMouseNode, String num) {
        boolean dontUseRelation = Config.getPref().getBoolean("cadastrewms.addr.dontUseRelation", false);
        String houseStreet = currentMouseNode.get(TAG_HOUSE_STREET);
        if (houseStreet != null && dontUseRelation) {
            this.inputStreet.setText(currentMouseNode.get(TAG_HOUSE_STREET));
            if (this.ctrl) {
                LinkedList<Command> cmds = new LinkedList<Command>();
                this.addAddrToPrimitive((OsmPrimitive)currentMouseNode, cmds);
                if (num == null) {
                    this.applyInputNumberChange();
                }
            }
            this.setSelectedWay(null);
        } else if (houseStreet == null) {
            Way wayInRelationAddr = Address.findWayInRelationAddr(currentMouseNode);
            if (wayInRelationAddr == null) {
                if (this.ctrl) {
                    this.applyInputNumberChange();
                }
                LinkedList<Command> cmds = new LinkedList<Command>();
                this.addAddrToPrimitive((OsmPrimitive)currentMouseNode, cmds);
            } else {
                this.inputStreet.setText(wayInRelationAddr.get("name"));
                this.setSelectedWay(wayInRelationAddr);
            }
        }
    }

    private void mousePressedNoExistingNode(MouseEvent e, Point mousePos, MapView mv) {
        ArrayList<Way> mouseOnExistingWays = new ArrayList<Way>();
        ArrayList<Way> mouseOnExistingBuildingWays = new ArrayList<Way>();
        List wss = mv.getNearestWaySegments(mousePos, OsmPrimitive::isSelectable);
        for (IWaySegment ws : wss) {
            if (((Way)ws.getWay()).get(TAG_HIGHWAY) != null && ((Way)ws.getWay()).get("name") != null) {
                mouseOnExistingWays.add((Way)ws.getWay());
                continue;
            }
            if (((Way)ws.getWay()).get(TAG_BUILDING) == null || ((Way)ws.getWay()).get(TAG_HOUSE_NUMBER) != null) continue;
            mouseOnExistingBuildingWays.add((Way)ws.getWay());
        }
        if (mouseOnExistingWays.size() == 1) {
            this.inputStreet.setText(((Way)mouseOnExistingWays.get(0)).get("name"));
            this.setSelectedWay((Way)mouseOnExistingWays.get(0));
            this.inputNumber.setText("");
            Address.setNewSelection((OsmPrimitive)mouseOnExistingWays.get(0));
        } else if (mouseOnExistingWays.isEmpty()) {
            this.mousePressedNoExistingNodeNoWays(e, mouseOnExistingBuildingWays);
        }
    }

    private void mousePressedNoExistingNodeNoWays(MouseEvent e, List<Way> mouseOnExistingBuildingWays) {
        if (this.inputStreet.getText().isEmpty() || this.inputNumber.getText().isEmpty()) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            LinkedList<Command> cmds = new LinkedList<Command>();
            if (this.ctrl) {
                this.applyInputNumberChange();
            }
            if (this.tagPolygon.isSelected()) {
                this.addAddrToPolygon(mouseOnExistingBuildingWays, cmds);
            } else {
                Node n = Address.createNewNode(e, cmds);
                this.addAddrToPrimitive((OsmPrimitive)n, cmds);
            }
        }
    }

    private static Way findWayInRelationAddr(Node n) {
        List l = n.getReferrers();
        for (OsmPrimitive osm : l) {
            if (!(osm instanceof Relation) || !osm.hasKey("type") || !osm.get("type").equals(RELATION_ADDR_TYPE)) continue;
            for (RelationMember rm : ((Relation)osm).getMembers()) {
                Way w = Address.usableRelationRole(rm);
                if (w == null) continue;
                return w;
            }
        }
        return null;
    }

    private static Way usableRelationRole(RelationMember rm) {
        OsmPrimitive osp;
        if (rm.getRole().equals(RELATION_ADDR_STREET_ROLE) && (osp = rm.getMember()) instanceof Way && osp.hasKey("name")) {
            return (Way)osp;
        }
        return null;
    }

    private void addAddrToPolygon(List<Way> mouseOnExistingBuildingWays, Collection<Command> cmds) {
        for (Way w : mouseOnExistingBuildingWays) {
            this.addAddrToPrimitive((OsmPrimitive)w, cmds);
        }
    }

    private void addAddrToPrimitive(OsmPrimitive osm, Collection<Command> cmds) {
        if (this.shift) {
            try {
                this.revertInputNumberChange();
            }
            catch (NumberFormatException ex) {
                Logging.warn((String)MESSAGE_UNABLE_TO_PARSE_HOUSE_NUMBER, (Object[])new Object[]{this.inputNumber.getText()});
            }
        }
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put(TAG_HOUSE_NUMBER, this.inputNumber.getText());
        cmds.add((Command)new ChangePropertyCommand(OsmDataManager.getInstance().getEditDataSet(), Collections.singleton(osm), tags));
        this.addStreetNameOrRelation(osm, cmds);
        try {
            this.applyInputNumberChange();
            SequenceCommand c = new SequenceCommand("Add node address", cmds);
            UndoRedoHandler.getInstance().add((Command)c);
            Address.setNewSelection(osm);
        }
        catch (NumberFormatException ex) {
            Logging.warn((String)MESSAGE_UNABLE_TO_PARSE_HOUSE_NUMBER, (Object[])new Object[]{this.inputNumber.getText()});
        }
    }

    private static Relation findRelationAddr(Way w) {
        List l = w.getReferrers();
        for (OsmPrimitive osm : l) {
            if (!(osm instanceof Relation) || !osm.hasKey("type") || !osm.get("type").equals(RELATION_ADDR_TYPE)) continue;
            return (Relation)osm;
        }
        return null;
    }

    private void addStreetNameOrRelation(OsmPrimitive osm, Collection<Command> cmds) {
        DataSet ds = OsmDataManager.getInstance().getEditDataSet();
        if (Config.getPref().getBoolean("cadastrewms.addr.dontUseRelation", false)) {
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put(TAG_HOUSE_STREET, this.inputStreet.getText());
            cmds.add((Command)new ChangePropertyCommand(ds, Arrays.asList(osm), tags));
        } else if (this.selectedWay != null) {
            Relation selectedRelation = Address.findRelationAddr(this.selectedWay);
            if (selectedRelation != null) {
                RelationMember rm = new RelationMember(RELATION_MEMBER_HOUSE, osm);
                Relation newRel = new Relation(selectedRelation);
                newRel.addMember(rm);
                cmds.add((Command)new ChangeCommand((OsmPrimitive)selectedRelation, (OsmPrimitive)newRel));
            } else {
                Relation newRel = new Relation();
                newRel.put("type", RELATION_ADDR_TYPE);
                newRel.put("name", this.selectedWay.get("name"));
                newRel.addMember(new RelationMember(RELATION_ADDR_STREET_ROLE, (OsmPrimitive)this.selectedWay));
                newRel.addMember(new RelationMember(RELATION_MEMBER_HOUSE, osm));
                cmds.add((Command)new AddCommand(ds, (OsmPrimitive)newRel));
            }
        }
    }

    private static Node createNewNode(MouseEvent e, Collection<Command> cmds) {
        Node n = new Node(MainApplication.getMap().mapView.getLatLon(e.getX(), e.getY()));
        cmds.add((Command)new AddCommand(OsmDataManager.getInstance().getEditDataSet(), (OsmPrimitive)n));
        List wss = MainApplication.getMap().mapView.getNearestWaySegments(e.getPoint(), OsmPrimitive::isSelectable);
        HashMap insertPoints = new HashMap();
        for (IWaySegment ws : wss) {
            List<Integer> is;
            if (insertPoints.containsKey(ws.getWay())) {
                is = (List)insertPoints.get(ws.getWay());
            } else {
                is = new ArrayList();
                insertPoints.put((Way)ws.getWay(), is);
            }
            is.add(ws.getLowerIndex());
        }
        HashSet<Pair<Node, Node>> segSet = new HashSet<Pair<Node, Node>>();
        ArrayList<Way> replacedWays = new ArrayList<Way>();
        ArrayList<Way> reuseWays = new ArrayList<Way>();
        for (Map.Entry insertPoint : insertPoints.entrySet()) {
            int i;
            Way w = (Way)insertPoint.getKey();
            List is = (List)insertPoint.getValue();
            Way wnew = new Way(w);
            Address.pruneSuccsAndReverse(is);
            Iterator iterator = is.iterator();
            while (iterator.hasNext()) {
                i = (Integer)iterator.next();
                segSet.add((Pair<Node, Node>)Pair.sort((Pair)new Pair((Object)w.getNode(i), (Object)w.getNode(i + 1))));
            }
            iterator = is.iterator();
            while (iterator.hasNext()) {
                i = (Integer)iterator.next();
                wnew.addNode(i + 1, n);
            }
            cmds.add((Command)new ChangeCommand((OsmPrimitive)insertPoint.getKey(), (OsmPrimitive)wnew));
            replacedWays.add((Way)insertPoint.getKey());
            reuseWays.add(wnew);
        }
        Address.adjustNode(segSet, n);
        return n;
    }

    private static void adjustNode(Collection<Pair<Node, Node>> segs, Node n) {
        double q;
        EastNorth enB;
        EastNorth enA;
        Pair<Node, Node> seg;
        switch (segs.size()) {
            case 0: {
                return;
            }
            case 2: {
                Iterator<Pair<Node, Node>> i = segs.iterator();
                seg = i.next();
                enA = ((Node)seg.a).getEastNorth();
                enB = ((Node)seg.b).getEastNorth();
                seg = i.next();
                EastNorth enC = ((Node)seg.a).getEastNorth();
                EastNorth enD = ((Node)seg.b).getEastNorth();
                double u = Address.det(enB.east() - enA.east(), enB.north() - enA.north(), enC.east() - enD.east(), enC.north() - enD.north());
                if (u == 0.0) {
                    return;
                }
                q = Address.det(enB.north() - enC.north(), enB.east() - enC.east(), enD.north() - enC.north(), enD.east() - enC.east()) / u;
                EastNorth intersection = new EastNorth(enB.east() + q * (enA.east() - enB.east()), enB.north() + q * (enA.north() - enB.north()));
                int snapToIntersectionThreshold = Config.getPref().getInt("edit.snap-intersection-threshold", 10);
                MapView mv = MainApplication.getMap().mapView;
                if (!(mv.getPoint(n).distance(mv.getPoint(intersection)) < (double)snapToIntersectionThreshold)) break;
                n.setEastNorth(intersection);
                return;
            }
        }
        EastNorth enP = n.getEastNorth();
        seg = segs.iterator().next();
        enA = ((Node)seg.a).getEastNorth();
        enB = ((Node)seg.b).getEastNorth();
        double a = enP.distanceSq(enB);
        double b = enP.distanceSq(enA);
        double c = enA.distanceSq(enB);
        q = (a - b + c) / (2.0 * c);
        n.setEastNorth(new EastNorth(enB.east() + q * (enA.east() - enB.east()), enB.north() + q * (enA.north() - enB.north())));
    }

    static double det(double a, double b, double c, double d) {
        return a * d - b * c;
    }

    private static void pruneSuccsAndReverse(List<Integer> is) {
        HashSet<Integer> is2 = new HashSet<Integer>();
        for (int i : is) {
            if (is2.contains(i - 1) || is2.contains(i + 1)) continue;
            is2.add(i);
        }
        is.clear();
        is.addAll(is2);
        Collections.sort(is);
        Collections.reverse(is);
    }

    private static Cursor getCursor() {
        try {
            return ImageProvider.getCursor((String)"crosshair", null);
        }
        catch (RuntimeException e) {
            Logging.warn((Throwable)e);
            return Cursor.getPredefinedCursor(1);
        }
    }

    private void applyInputNumberChange() {
        Integer num = Integer.parseInt(this.inputNumber.getText());
        if (this.plusOne.isSelected()) {
            num = num + 1;
        }
        if (this.plusTwo.isSelected()) {
            num = num + 2;
        }
        if (this.minusOne.isSelected() && num > 1) {
            num = num - 1;
        }
        if (this.minusTwo.isSelected() && num > 2) {
            num = num - 2;
        }
        this.inputNumber.setText(num.toString());
    }

    private void revertInputNumberChange() {
        Integer num = Integer.parseInt(this.inputNumber.getText());
        if (this.plusOne.isSelected()) {
            num = num - 1;
        }
        if (this.plusTwo.isSelected()) {
            num = num - 2;
        }
        if (this.minusOne.isSelected() && num > 1) {
            num = num + 1;
        }
        if (this.minusTwo.isSelected() && num > 2) {
            num = num + 2;
        }
        this.inputNumber.setText(num.toString());
    }

    private void createDialog() {
        ImageIcon iconLink = ImageProvider.get(null, (String)"Osm_element_relation");
        this.link.setIcon(iconLink);
        this.link.setEnabled(false);
        JPanel p = new JPanel(new GridBagLayout());
        JLabel number = new JLabel(I18n.tr((String)"Next no", (Object[])new Object[0]));
        JLabel street = new JLabel(I18n.tr((String)"Street", (Object[])new Object[0]));
        p.add((Component)number, GBC.std().insets(0, 0, 0, 0));
        p.add((Component)this.inputNumber, GBC.eol().fill(2).insets(5, 5, 0, 5));
        p.add((Component)street, GBC.std().insets(0, 0, 0, 0));
        JPanel p2 = new JPanel(new GridBagLayout());
        this.inputStreet.setEditable(false);
        p2.add((Component)this.inputStreet, GBC.std().fill(2).insets(5, 0, 0, 0));
        p2.add((Component)this.link, GBC.eol().insets(10, 0, 0, 0));
        p.add((Component)p2, GBC.eol().fill(2));
        this.clearButton = new JButton("Clear");
        this.clearButton.addActionListener(e -> {
            this.inputNumber.setText("");
            this.inputStreet.setText("");
            this.setSelectedWay(null);
        });
        ButtonGroup bgIncremental = new ButtonGroup();
        bgIncremental.add(this.plusOne);
        bgIncremental.add(this.plusTwo);
        bgIncremental.add(this.minusOne);
        bgIncremental.add(this.minusTwo);
        p.add((Component)this.minusOne, GBC.std().insets(10, 0, 10, 0));
        p.add((Component)this.plusOne, GBC.std().insets(0, 0, 10, 0));
        this.tagPolygon.setSelected(Config.getPref().getBoolean("cadastrewms.addr.onBuilding", false));
        this.tagPolygon.addChangeListener(ignored -> Config.getPref().putBoolean("cadastrewms.addr.onBuilding", this.tagPolygon.isSelected()));
        p.add((Component)this.tagPolygon, GBC.eol().fill(2).insets(0, 0, 0, 0));
        p.add((Component)this.minusTwo, GBC.std().insets(10, 0, 10, 0));
        p.add((Component)this.plusTwo, GBC.std().insets(0, 0, 10, 0));
        p.add((Component)this.clearButton, GBC.eol().fill(2).insets(0, 0, 0, 0));
        Object[] options = new Object[]{};
        JOptionPane pane = new JOptionPane(p, -1, 1, null, options, null);
        this.dialog = pane.createDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Enter addresses", (Object[])new Object[0]));
        this.dialog.setModal(false);
        this.dialog.setAlwaysOnTop(true);
        this.dialog.addComponentListener(new ComponentAdapter(){

            protected void rememberGeometry() {
                Config.getPref().put("cadastrewms.addr.bounds", Address.this.dialog.getX() + "," + Address.this.dialog.getY() + "," + Address.this.dialog.getWidth() + "," + Address.this.dialog.getHeight());
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                this.rememberGeometry();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                this.rememberGeometry();
            }
        });
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg) {
                MainApplication.getMap().selectMapMode((MapMode)MainApplication.getMap().getDefaultButtonAction());
            }
        });
        String bounds = Config.getPref().get("cadastrewms.addr.bounds", null);
        if (bounds != null) {
            String[] b = bounds.split(",");
            this.dialog.setBounds(new Rectangle(Integer.parseInt(b[0]), Integer.parseInt(b[1]), Integer.parseInt(b[2]), Integer.parseInt(b[3])));
        }
    }

    private void setSelectedWay(Way w) {
        this.selectedWay = w;
        this.link.setEnabled(w != null);
        this.link.repaint();
    }

    private static void setNewSelection(OsmPrimitive osm) {
        DataSet ds = MainApplication.getLayerManager().getEditDataSet();
        LinkedList<OsmPrimitive> newSelection = new LinkedList<OsmPrimitive>(ds.getSelected());
        newSelection.clear();
        newSelection.add(osm);
        ds.setSelected(new PrimitiveId[]{osm});
    }
}

