/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.fr.cadastre.CadastrePlugin;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.CacheFileLambert4ZoneFilter;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.CacheFileLambert9ZoneFilter;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.CacheFileUTM20NFilter;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.WMSLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class MenuActionLoadFromCache
extends JosmAction {
    private static final long serialVersionUID = 1L;
    private static final String ERROR = I18n.marktr((String)"Error");
    private static final String ACTION_NAME = I18n.marktr((String)"Load layer from cache");

    public MenuActionLoadFromCache() {
        super(I18n.tr((String)ACTION_NAME, (Object[])new Object[0]), "cadastre_small", I18n.tr((String)"Load location from cache (only if cache is enabled)", (Object[])new Object[0]), null, false, "cadastrefr/loadfromcache", true);
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser fc = MenuActionLoadFromCache.createAndOpenFileChooser();
        if (fc == null) {
            return;
        }
        File[] files = fc.getSelectedFiles();
        int layoutZone = CadastrePlugin.getCadastreProjectionLayoutZone();
        for (File file : files) {
            if (!file.exists()) continue;
            String filename = file.getName();
            String ext = MenuActionLoadFromCache.getExtension(filename);
            if (MenuActionLoadFromCache.extIsLambertCC9Z(ext) && !CadastrePlugin.isLambert_cc9() || MenuActionLoadFromCache.extIsUTM20N(ext) && !CadastrePlugin.isUtm_france_dom() || ext.length() == 1 && !CadastrePlugin.isLambert()) {
                JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"{0} not allowed with the current projection", (Object[])new Object[]{filename}), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
                continue;
            }
            MenuActionLoadFromCache.actionPerformed(file, filename, ext, layoutZone);
        }
    }

    private static String getExtension(String filename) {
        return filename.lastIndexOf(46) == -1 ? "" : filename.substring(filename.lastIndexOf(46) + 1);
    }

    private static String simplifyExtension(String ext) {
        if (MenuActionLoadFromCache.extIsLambertCC9Z(ext)) {
            return ext.substring(2);
        }
        if (MenuActionLoadFromCache.extIsUTM20N(ext)) {
            return ext.substring(3);
        }
        return ext;
    }

    private static void actionPerformed(File file, String filename, String ext, int layoutZone) {
        String location = filename.substring(0, filename.lastIndexOf(46));
        ext = MenuActionLoadFromCache.simplifyExtension(ext);
        try {
            int cacheZone = Integer.parseInt(ext) - 1;
            if (cacheZone >= 0 && cacheZone <= 9) {
                if (cacheZone != layoutZone) {
                    JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Cannot load cache {0} which is not compatible with current projection zone", (Object[])new Object[]{filename}), I18n.tr((String)ERROR, (Object[])new Object[0]), 0);
                    return;
                }
                Logging.info((String)("Load cache " + filename));
            }
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Selected file {0} is not a cache file from this plugin (invalid extension)", (Object[])new Object[]{filename}), I18n.tr((String)ERROR, (Object[])new Object[0]), 0);
            return;
        }
        if (MainApplication.getMap() != null) {
            for (Layer l : MainApplication.getLayerManager().getLayers()) {
                if (!(l instanceof WMSLayer) || !l.getName().equals(location)) continue;
                JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"The location {0} is already on screen. Cache not loaded.", (Object[])new Object[]{filename}), I18n.tr((String)ERROR, (Object[])new Object[0]), 0);
                return;
            }
        }
        WMSLayer wmsLayer = new WMSLayer("", "", Integer.parseInt(ext) - 1);
        if (wmsLayer.grabThread.getCacheControl().loadCache(file, layoutZone)) {
            CadastrePlugin.addWMSLayer(wmsLayer);
        }
    }

    private static boolean extIsLambertCC9Z(String ext) {
        return ext.length() == 3 && ext.startsWith("CC");
    }

    private static boolean extIsUTM20N(String ext) {
        return ext.length() == 4 && ext.startsWith("UTM");
    }

    protected static JFileChooser createAndOpenFileChooser() {
        JFileChooser fc = new JFileChooser(new File(CadastrePlugin.cacheDir));
        fc.setMultiSelectionEnabled(true);
        int layoutZone = CadastrePlugin.getCadastreProjectionLayoutZone();
        if (layoutZone != -1) {
            if (CadastrePlugin.isLambert()) {
                fc.addChoosableFileFilter(CacheFileLambert4ZoneFilter.filters[layoutZone]);
            } else if (CadastrePlugin.isLambert_cc9()) {
                fc.addChoosableFileFilter(CacheFileLambert9ZoneFilter.filters[layoutZone]);
            } else if (CadastrePlugin.isUtm_france_dom()) {
                fc.addChoosableFileFilter(CacheFileUTM20NFilter.filters[layoutZone]);
            }
        }
        fc.setAcceptAllFileFilterUsed(false);
        int answer = fc.showOpenDialog((Component)MainApplication.getMainFrame());
        if (answer != 0) {
            return null;
        }
        return fc;
    }
}

