/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.fr.cadastre.CadastrePlugin;
import org.openstreetmap.josm.plugins.fr.cadastre.actions.MenuActionNewLocation;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.DownloadWMSPlanImage;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.RasterImageGeoreferencer;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.WMSLayer;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;

public class MenuActionGrabPlanImage
extends JosmAction
implements Runnable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = I18n.marktr((String)"Georeference an image");
    private transient DownloadWMSPlanImage downloadWMSPlanImage;
    private transient WMSLayer wmsLayer;
    private transient RasterImageGeoreferencer rasterImageGeoreferencer = new RasterImageGeoreferencer();

    public MenuActionGrabPlanImage() {
        super(I18n.tr((String)NAME, (Object[])new Object[0]), "cadastre_small", I18n.tr((String)"Grab non-georeferenced image", (Object[])new Object[0]), null, false, "cadastrefr/grabplanimage", true);
    }

    protected void updateEnabledState() {
        if (this.wmsLayer == null || !MainApplication.isDisplayingMapView()) {
            return;
        }
        if (!this.rasterImageGeoreferencer.isRunning()) {
            return;
        }
        if (MainApplication.getLayerManager().containsLayer((Layer)this.wmsLayer)) {
            return;
        }
        JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Georeferencing interrupted", (Object[])new Object[0]));
        this.rasterImageGeoreferencer.actionInterrupted();
    }

    public void actionPerformed(ActionEvent ae) {
        if (MainApplication.getMap() != null) {
            if (CadastrePlugin.isCadastreProjection()) {
                this.wmsLayer = new MenuActionNewLocation().addNewLayer(new ArrayList<WMSLayer>());
                if (this.wmsLayer == null) {
                    return;
                }
                this.downloadWMSPlanImage = new DownloadWMSPlanImage();
                this.downloadWMSPlanImage.download(this.wmsLayer);
                MainApplication.worker.execute(this);
            } else {
                CadastrePlugin.askToChangeProjection();
            }
        }
    }

    @Override
    public void run() {
        boolean loadedFromCache = this.downloadWMSPlanImage.waitFinished();
        if (loadedFromCache) {
            this.wmsLayer.invalidate();
        } else if (this.wmsLayer.getImages().isEmpty()) {
            this.rasterImageGeoreferencer.actionInterrupted();
        } else {
            int reply = 2;
            if (this.wmsLayer.isAlreadyGeoreferenced()) {
                reply = JOptionPane.showConfirmDialog(null, I18n.tr((String)"This image contains georeference data.\nDo you want to use them ?", (Object[])new Object[0]), null, 0);
            }
            if (reply == 0) {
                this.rasterImageGeoreferencer.transformGeoreferencedImg();
            } else {
                this.rasterImageGeoreferencer.addListener();
                if (!Config.getPref().getBoolean("cadastrewms.noImageCropping", false)) {
                    this.rasterImageGeoreferencer.startCropping(this.wmsLayer);
                } else {
                    this.rasterImageGeoreferencer.startGeoreferencing(this.wmsLayer);
                }
            }
        }
    }
}

