/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pdfimport;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.UploadPolicy;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.importexport.OsmExporter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressRenderer;
import org.openstreetmap.josm.gui.progress.swing.SwingRenderingProgressMonitor;
import org.openstreetmap.josm.plugins.pdfimport.FilePlacement;
import org.openstreetmap.josm.plugins.pdfimport.FilePlacement18;
import org.openstreetmap.josm.plugins.pdfimport.OsmBuilder;
import org.openstreetmap.josm.plugins.pdfimport.PathOptimizer;
import org.openstreetmap.josm.plugins.pdfimport.PathOptimizerConfig;
import org.openstreetmap.josm.plugins.pdfimport.Preferences;
import org.openstreetmap.josm.plugins.pdfimport.Preview;
import org.openstreetmap.josm.plugins.pdfimport.pdfbox.PdfBoxParser;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class LoadPdfDialog
extends JFrame {
    private File pdfFile;
    private final FilePlacement18 placement = new FilePlacement18();
    private PathOptimizer pdfData;
    private final JButton loadFileButton = new JButton(I18n.tr((String)"Load preview ...", (Object[])new Object[0]));
    private final JProgressBar loadProgress = new JProgressBar();
    private OsmDataLayer newLayer;
    private LoadProgressRenderer progressRenderer;
    Component placementPanel = this.placement.getGui();
    MainButtons actionPanel = new MainButtons();
    PathOptimizerConfig configPanel = new PathOptimizerConfig();
    private static JFileChooser loadChooser = null;

    public LoadPdfDialog() {
        this.buildGUI();
        this.removeLayer();
        if (Preferences.getGuiMode() == Preferences.GuiMode.Simple) {
            this.loadFileButton.setVisible(false);
            this.configPanel.getComponent().setVisible(false);
            this.actionPanel.saveButton.setVisible(false);
            this.actionPanel.showButton.setVisible(false);
            this.setSize(new Dimension(380, 350));
            if (!this.loadAction()) {
                this.cancelAction();
                return;
            }
        } else {
            this.setSize(new Dimension(450, 600));
        }
        this.setAlwaysOnTop(true);
        this.setVisible(true);
    }

    private void buildGUI() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = -1;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.actionPanel.build(this);
        this.loadFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadPdfDialog.this.loadAction();
            }
        });
        this.progressRenderer = new LoadProgressRenderer(this.loadProgress);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.configPanel.getComponent(), c);
        c.fill = 2;
        panel.add((Component)this.loadFileButton, c);
        c.fill = 1;
        panel.add(this.placementPanel, c);
        panel.add((Component)this.actionPanel.panel, c);
        c.fill = 2;
        panel.add((Component)this.loadProgress, c);
        this.setContentPane(panel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LoadPdfDialog.this.cancelAction();
            }
        });
        this.placement.setDependsOnValid(this.actionPanel.okButton);
    }

    private boolean loadAction() {
        final File newFileName = this.chooseFile();
        if (newFileName == null) {
            return false;
        }
        Logging.debug((String)"PdfImport: Load Preview");
        this.removeLayer();
        this.loadFileButton.setEnabled(false);
        this.runAsBackgroundTask(new Runnable(){

            @Override
            public void run() {
                OsmBuilder.Mode mode;
                LoadPdfDialog.this.loadProgress.setVisible(true);
                SwingRenderingProgressMonitor monitor = new SwingRenderingProgressMonitor((ProgressRenderer)LoadPdfDialog.this.progressRenderer);
                monitor.beginTask("Loading file", 1000);
                LoadPdfDialog.this.pdfData = LoadPdfDialog.this.loadPDF(newFileName, monitor.createSubTaskMonitor(500, false));
                OsmBuilder.Mode mode2 = mode = LoadPdfDialog.this.configPanel.debugModeCheck.getValue() ? OsmBuilder.Mode.Debug : OsmBuilder.Mode.Draft;
                if (LoadPdfDialog.this.pdfData != null) {
                    LoadPdfDialog.this.newLayer = LoadPdfDialog.this.makeLayer(I18n.tr((String)"PDF preview: ", (Object[])new Object[0]) + newFileName.getName(), new FilePlacement(), mode, monitor.createSubTaskMonitor(500, false));
                }
                monitor.finishTask();
                LoadPdfDialog.this.progressRenderer.finish();
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                LoadPdfDialog.this.pdfFile = newFileName;
                if (LoadPdfDialog.this.pdfData != null) {
                    Preview.set(LoadPdfDialog.this.newLayer, new FilePlacement());
                    MainApplication.getMap().mapView.zoomTo(LoadPdfDialog.this.placement.getWorldBounds(LoadPdfDialog.this.pdfData));
                    try {
                        LoadPdfDialog.this.placement.load(newFileName);
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        LoadPdfDialog.this.placement.verify();
                    }
                    LoadPdfDialog.this.newLayer = null;
                    LoadPdfDialog.this.loadFileButton.setEnabled(true);
                    LoadPdfDialog.this.placementPanel.setEnabled(true);
                    LoadPdfDialog.this.actionPanel.panel.setEnabled(true);
                    LoadPdfDialog.this.actionPanel.showButton.setEnabled(true);
                    LoadPdfDialog.this.actionPanel.saveButton.setEnabled(true);
                    LoadPdfDialog.this.actionPanel.okButton.setEnabled(true);
                    LoadPdfDialog.this.loadProgress.setVisible(false);
                }
            }
        });
        return true;
    }

    private void importAction() {
        if (!this.placement.isValid()) {
            return;
        }
        try {
            this.placement.save(this.pdfFile);
        }
        catch (IOException e) {
            Logging.debug((Throwable)e);
        }
        this.removeLayer();
        this.runAsBackgroundTask(new Runnable(){

            @Override
            public void run() {
                LoadPdfDialog.this.loadProgress.setVisible(true);
                SwingRenderingProgressMonitor monitor = new SwingRenderingProgressMonitor((ProgressRenderer)LoadPdfDialog.this.progressRenderer);
                LoadPdfDialog.this.newLayer = LoadPdfDialog.this.makeLayer(I18n.tr((String)"PDF: ", (Object[])new Object[0]) + LoadPdfDialog.this.pdfFile.getName(), LoadPdfDialog.this.placement, OsmBuilder.Mode.Final, (ProgressMonitor)monitor);
                LoadPdfDialog.this.progressRenderer.finish();
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainApplication.getLayerManager().addLayer((Layer)LoadPdfDialog.this.newLayer);
                MainApplication.getMap().mapView.zoomTo(LoadPdfDialog.this.placement.getWorldBounds(LoadPdfDialog.this.pdfData));
                LoadPdfDialog.this.setVisible(false);
            }
        });
    }

    private void saveAction() {
        if (!this.placement.isValid()) {
            return;
        }
        final File file = this.chooseSaveFile();
        if (file == null) {
            return;
        }
        this.removeLayer();
        this.runAsBackgroundTask(new Runnable(){

            @Override
            public void run() {
                SwingRenderingProgressMonitor monitor = new SwingRenderingProgressMonitor((ProgressRenderer)LoadPdfDialog.this.progressRenderer);
                LoadPdfDialog.this.saveLayer(file, LoadPdfDialog.this.placement, (ProgressMonitor)monitor);
                LoadPdfDialog.this.progressRenderer.finish();
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadPdfDialog.this.setVisible(false);
            }
        });
    }

    private void showAction() {
        if (!this.placement.isValid()) {
            return;
        }
        MainApplication.getMap().mapView.zoomTo(this.placement.getWorldBounds(this.pdfData));
        MainApplication.getMap().repaint();
    }

    private void cancelAction() {
        this.removeLayer();
        this.setVisible(false);
    }

    private File chooseFile() {
        if (loadChooser == null) {
            loadChooser = new JFileChooser(Preferences.getLoadDir());
            loadChooser.setAcceptAllFileFilterUsed(false);
            loadChooser.setMultiSelectionEnabled(false);
            loadChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() || pathname.getName().endsWith(".pdf");
                }

                @Override
                public String getDescription() {
                    return I18n.tr((String)"PDF files", (Object[])new Object[0]);
                }
            });
        } else {
            loadChooser.setSelectedFile(null);
            loadChooser.rescanCurrentDirectory();
        }
        int result = loadChooser.showDialog(this, I18n.tr((String)"Import PDF", (Object[])new Object[0]));
        if (result != 0) {
            return null;
        }
        Preferences.setLoadDir(loadChooser.getSelectedFile().getParentFile().getAbsolutePath());
        return loadChooser.getSelectedFile();
    }

    private File chooseSaveFile() {
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(true);
        fc.setMultiSelectionEnabled(false);
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().endsWith(".osm");
            }

            @Override
            public String getDescription() {
                return I18n.tr((String)"OSM files", (Object[])new Object[0]);
            }
        });
        int result = fc.showOpenDialog((Component)MainApplication.getMainFrame());
        if (result != 0) {
            return null;
        }
        return fc.getSelectedFile();
    }

    private void runAsBackgroundTask(final Runnable task, final ActionListener after) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                task.run();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LoadPdfDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                        after.actionPerformed(null);
                    }
                });
            }
        });
        t.start();
    }

    private PathOptimizer loadPDF(File fileName, ProgressMonitor monitor) {
        monitor.beginTask("", 100);
        monitor.setTicks(0);
        monitor.setCustomText(I18n.tr((String)"Preparing", (Object[])new Object[0]));
        double nodesTolerance = 0.0;
        Color color = null;
        int maxPaths = Integer.MAX_VALUE;
        if (this.configPanel.mergeCloseNodesCheck.getValue() && this.configPanel.mergeCloseNodesTolerance.isDataValid()) {
            nodesTolerance = this.configPanel.mergeCloseNodesTolerance.getValue();
        }
        if (this.configPanel.colorFilterCheck.getValue()) {
            try {
                String colString = this.configPanel.colorFilterColor.getText().replace("#", "");
                color = new Color(Integer.parseInt(colString, 16));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Could not parse color", (Object[])new Object[0]));
                return null;
            }
        }
        if (this.configPanel.limitPathCountCheck.getValue() && this.configPanel.limitPathCount.isDataValid()) {
            maxPaths = this.configPanel.limitPathCount.getValue();
        }
        monitor.setTicks(10);
        monitor.setCustomText(I18n.tr((String)"Parsing file", (Object[])new Object[0]));
        PathOptimizer data = new PathOptimizer(nodesTolerance, color, this.configPanel.splitOnColorChangeCheck.getValue());
        try {
            PdfBoxParser parser = new PdfBoxParser(data);
            parser.parse(fileName, maxPaths, monitor.createSubTaskMonitor(80, false));
        }
        catch (FileNotFoundException e1) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"File not found.", (Object[])new Object[0]));
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Error while parsing: {0}", (Object[])new Object[]{e.getMessage()}));
            return null;
        }
        monitor.setTicks(80);
        if (this.configPanel.removeParallelSegmentsCheck.getValue() && this.configPanel.removeParallelSegmentsTolerance.isDataValid()) {
            double tolerance = this.configPanel.removeParallelSegmentsTolerance.getValue();
            monitor.setCustomText(I18n.tr((String)"Removing parallel segments", (Object[])new Object[0]));
        }
        if (nodesTolerance > 0.0) {
            monitor.setTicks(83);
            monitor.setCustomText(I18n.tr((String)"Joining nodes", (Object[])new Object[0]));
            data.mergeNodes();
        }
        monitor.setTicks(85);
        monitor.setCustomText(I18n.tr((String)"Joining adjacent segments", (Object[])new Object[0]));
        data.mergeSegments();
        if (this.configPanel.removeSmallObjectsCheck.getValue() && this.configPanel.removeSmallObjectsSize.isDataValid()) {
            double tolerance = this.configPanel.removeSmallObjectsSize.getValue();
            monitor.setTicks(90);
            monitor.setCustomText(I18n.tr((String)"Removing small objects", (Object[])new Object[0]));
            data.removeSmallObjects(tolerance);
        }
        if (this.configPanel.removeLargeObjectsCheck.getValue() && this.configPanel.removeLargeObjectsSize.isDataValid()) {
            double tolerance = this.configPanel.removeLargeObjectsSize.getValue();
            monitor.setTicks(90);
            monitor.setCustomText(I18n.tr((String)"Removing large objects", (Object[])new Object[0]));
            data.removeLargeObjects(tolerance);
        }
        monitor.setTicks(95);
        monitor.setCustomText(I18n.tr((String)"Finalizing layers", (Object[])new Object[0]));
        data.splitLayersByPathKind(this.configPanel.splitOnShapeClosedCheck.getValue(), this.configPanel.splitOnSingleSegmentCheck.getValue(), this.configPanel.splitOnOrthogonalCheck.getValue());
        data.finish();
        monitor.finishTask();
        return data;
    }

    private OsmDataLayer makeLayer(String name, FilePlacement placement, OsmBuilder.Mode mode, ProgressMonitor monitor) {
        monitor.beginTask(I18n.tr((String)"Building JOSM layer", (Object[])new Object[0]), 100);
        OsmBuilder builder = new OsmBuilder(placement);
        DataSet data = builder.build(this.pdfData.getLayers(), mode, monitor.createSubTaskMonitor(50, false));
        data.setUploadPolicy(UploadPolicy.BLOCKED);
        monitor.setTicks(50);
        monitor.setCustomText(I18n.tr((String)"Postprocessing layer", (Object[])new Object[0]));
        OsmDataLayer result = new OsmDataLayer(data, name, null);
        result.setUploadDiscouraged(true);
        result.setBackgroundLayer(true);
        result.onPostLoadFromFile();
        monitor.finishTask();
        return result;
    }

    private void removeLayer() {
        Preview.clear();
        this.actionPanel.showButton.setEnabled(false);
        this.actionPanel.saveButton.setEnabled(false);
        this.actionPanel.okButton.setEnabled(false);
        this.placementPanel.setEnabled(false);
    }

    private void saveLayer(File file, FilePlacement placement, ProgressMonitor monitor) {
        monitor.beginTask(I18n.tr((String)"Saving to file.", (Object[])new Object[0]), 1000);
        OsmBuilder builder = new OsmBuilder(placement);
        DataSet data = builder.build(this.pdfData.getLayers(), OsmBuilder.Mode.Final, monitor.createSubTaskMonitor(500, false));
        OsmDataLayer layer = new OsmDataLayer(data, file.getName(), file);
        monitor.setCustomText(I18n.tr((String)" Writing to file", (Object[])new Object[0]));
        monitor.setTicks(500);
        OsmExporter exporter = new OsmExporter();
        try {
            exporter.exportData(file, (Layer)layer);
        }
        catch (IOException e) {
            Logging.error((Throwable)e);
        }
        monitor.finishTask();
    }

    public static class MainButtons {
        public JButton okButton;
        public JButton cancelButton;
        public JButton showButton;
        public JButton saveButton;
        public JPanel panel;

        void build(final LoadPdfDialog loadPdfDialog) {
            this.okButton = new JButton(I18n.tr((String)"Import", (Object[])new Object[0]));
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    loadPdfDialog.importAction();
                }
            });
            this.saveButton = new JButton(I18n.tr((String)"Save", (Object[])new Object[0]));
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    loadPdfDialog.saveAction();
                }
            });
            this.showButton = new JButton(I18n.tr((String)"Show target", (Object[])new Object[0]));
            this.showButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    loadPdfDialog.showAction();
                }
            });
            this.cancelButton = new JButton(I18n.tr((String)"Cancel", (Object[])new Object[0]));
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    loadPdfDialog.cancelAction();
                }
            });
            this.panel = new JPanel(new FlowLayout());
            this.panel.add(this.cancelButton);
            this.panel.add(this.showButton);
            this.panel.add(this.okButton);
            this.panel.add(this.saveButton);
            this.showButton.setVisible(Preferences.isLegacyActions());
            this.saveButton.setVisible(Preferences.isLegacyActions());
        }
    }

    static class LoadProgressRenderer
    implements ProgressRenderer {
        private final JProgressBar pBar;
        private String title = "";

        LoadProgressRenderer(JProgressBar pb) {
            this.pBar = pb;
            this.pBar.setMinimum(0);
            this.pBar.setValue(0);
            this.pBar.setMaximum(1);
            this.pBar.setString("");
            this.pBar.setStringPainted(true);
        }

        public void setCustomText(String message) {
            this.pBar.setString(this.title + message);
        }

        public void setIndeterminate(boolean indeterminate) {
            this.pBar.setIndeterminate(indeterminate);
        }

        public void setMaximum(int maximum) {
            this.pBar.setMaximum(maximum);
        }

        public void setTaskTitle(String taskTitle) {
            this.title = taskTitle;
            this.pBar.setString(this.title);
        }

        public void setValue(int value) {
            this.pBar.setValue(value);
        }

        public void finish() {
            this.pBar.setString(I18n.tr((String)"Finished", (Object[])new Object[0]));
            this.pBar.setValue(this.pBar.getMaximum());
        }
    }
}

