/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfviewer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDMatrix;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.PDGraphicsState;
import org.apache.pdfbox.pdmodel.graphics.PDShading;
import org.apache.pdfbox.pdmodel.graphics.shading.AxialShadingPaint;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingResources;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType1;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType2;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType3;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType4;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType5;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType6;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType7;
import org.apache.pdfbox.pdmodel.graphics.shading.RadialShadingPaint;
import org.apache.pdfbox.pdmodel.graphics.shading.Type1ShadingPaint;
import org.apache.pdfbox.pdmodel.graphics.shading.Type4ShadingPaint;
import org.apache.pdfbox.pdmodel.graphics.shading.Type5ShadingPaint;
import org.apache.pdfbox.pdmodel.graphics.shading.Type6ShadingPaint;
import org.apache.pdfbox.pdmodel.graphics.shading.Type7ShadingPaint;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.PDFStreamEngine;
import org.apache.pdfbox.util.ResourceLoader;
import org.apache.pdfbox.util.TextPosition;

public class PageDrawer
extends PDFStreamEngine {
    private static final Log LOG = LogFactory.getLog(PageDrawer.class);
    private Graphics2D graphics;
    private int clippingWindingRule = -1;
    protected Dimension pageSize;
    protected PDPage page;
    private GeneralPath linePath = new GeneralPath();
    private BasicStroke stroke = null;

    public PageDrawer() throws IOException {
        super(ResourceLoader.loadProperties("org/apache/pdfbox/resources/PageDrawer.properties", true));
    }

    public void drawPage(Graphics g, PDPage p, Dimension pageDimension) throws IOException {
        this.graphics = (Graphics2D)g;
        this.page = p;
        this.pageSize = pageDimension;
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.graphics.setStroke(new BasicStroke(1.0f, 0, 0));
        if (this.page.getContents() != null) {
            PDResources resources = this.page.findResources();
            this.processStream(this.page, resources, this.page.getContents().getStream());
        }
        List<PDAnnotation> annotations = this.page.getAnnotations();
        for (int i = 0; i < annotations.size(); ++i) {
            PDAppearanceStream appearance;
            Map<String, PDAppearanceStream> appearanceMap;
            PDAnnotation annot = annotations.get(i);
            PDRectangle rect = annot.getRectangle();
            String appearanceName = annot.getAppearanceStream();
            PDAppearanceDictionary appearDictionary = annot.getAppearance();
            if (appearDictionary == null) continue;
            if (appearanceName == null) {
                appearanceName = "default";
            }
            if ((appearanceMap = appearDictionary.getNormalAppearance()) == null || (appearance = appearanceMap.get(appearanceName)) == null) continue;
            Point2D.Float point = new Point2D.Float(rect.getLowerLeftX(), rect.getLowerLeftY());
            Matrix matrix = appearance.getMatrix();
            if (matrix != null) {
                AffineTransform at = matrix.createAffineTransform();
                at.transform(point, point);
            }
            g.translate((int)((Point2D)point).getX(), -((int)((Point2D)point).getY()));
            this.processSubStream(this.page, appearance.getResources(), appearance.getStream());
            g.translate(-((int)((Point2D)point).getX()), (int)((Point2D)point).getY());
        }
    }

    public void dispose() {
        this.graphics = null;
        this.linePath = null;
        this.page = null;
        this.pageSize = null;
    }

    protected void processTextPosition(TextPosition text) {
        try {
            Paint paint;
            Composite composite;
            PDGraphicsState graphicsState = this.getGraphicsState();
            switch (graphicsState.getTextState().getRenderingMode()) {
                case 0: {
                    composite = graphicsState.getNonStrokeJavaComposite();
                    paint = graphicsState.getNonStrokingColor().getJavaColor();
                    if (paint != null) break;
                    paint = graphicsState.getNonStrokingColor().getPaint(this.pageSize.height);
                    break;
                }
                case 1: {
                    composite = graphicsState.getStrokeJavaComposite();
                    paint = graphicsState.getStrokingColor().getJavaColor();
                    if (paint != null) break;
                    paint = graphicsState.getStrokingColor().getPaint(this.pageSize.height);
                    break;
                }
                case 3: {
                    Color nsc = graphicsState.getStrokingColor().getJavaColor();
                    float[] components = new float[]{Color.black.getRed(), Color.black.getGreen(), Color.black.getBlue()};
                    paint = new Color(nsc.getColorSpace(), components, 0.0f);
                    composite = graphicsState.getStrokeJavaComposite();
                    break;
                }
                default: {
                    LOG.debug("Unsupported RenderingMode " + this.getGraphicsState().getTextState().getRenderingMode() + " in PageDrawer.processTextPosition()." + " Using RenderingMode " + 0 + " instead");
                    composite = graphicsState.getNonStrokeJavaComposite();
                    paint = graphicsState.getNonStrokingColor().getJavaColor();
                }
            }
            this.graphics.setComposite(composite);
            this.graphics.setPaint(paint);
            PDFont font = text.getFont();
            Matrix textPos = text.getTextPos().copy();
            float x = textPos.getXPosition();
            float y = (float)this.pageSize.height - textPos.getYPosition();
            textPos.setValue(2, 0, 0.0f);
            textPos.setValue(2, 1, 0.0f);
            textPos.setValue(0, 1, -1.0f * textPos.getValue(0, 1));
            textPos.setValue(1, 0, -1.0f * textPos.getValue(1, 0));
            AffineTransform at = textPos.createAffineTransform();
            PDMatrix fontMatrix = font.getFontMatrix();
            at.scale(fontMatrix.getValue(0, 0) * 1000.0f, fontMatrix.getValue(1, 1) * 1000.0f);
            this.graphics.setClip(graphicsState.getCurrentClippingPath());
            font.drawString(text.getCharacter(), text.getCodePoints(), this.graphics, 1.0f, at, x, y);
        }
        catch (IOException io) {
            LOG.error(io, io);
        }
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    public PDPage getPage() {
        return this.page;
    }

    public Dimension getPageSize() {
        return this.pageSize;
    }

    public double fixY(double y) {
        return this.pageSize.getHeight() - y;
    }

    public GeneralPath getLinePath() {
        return this.linePath;
    }

    public void setLinePath(GeneralPath newLinePath) {
        if (this.linePath == null || this.linePath.getCurrentPoint() == null) {
            this.linePath = newLinePath;
        } else {
            this.linePath.append(newLinePath, false);
        }
    }

    public void fillPath(int windingRule) throws IOException {
        this.graphics.setComposite(this.getGraphicsState().getNonStrokeJavaComposite());
        Paint nonStrokingPaint = this.getGraphicsState().getNonStrokingColor().getJavaColor();
        if (nonStrokingPaint == null) {
            nonStrokingPaint = this.getGraphicsState().getNonStrokingColor().getPaint(this.pageSize.height);
        }
        if (nonStrokingPaint == null) {
            LOG.info("ColorSpace " + this.getGraphicsState().getNonStrokingColor().getColorSpace().getName() + " doesn't provide a non-stroking color, using white instead!");
            nonStrokingPaint = Color.WHITE;
        }
        this.graphics.setPaint(nonStrokingPaint);
        this.getLinePath().setWindingRule(windingRule);
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.graphics.setClip(this.getGraphicsState().getCurrentClippingPath());
        if (!(this.graphics.getPaint() instanceof Color)) {
            Area area = new Area(this.getLinePath());
            area.intersect(new Area(this.graphics.getClip()));
            this.graphics.fill(area);
        } else {
            this.graphics.fill(this.getLinePath());
        }
        this.getLinePath().reset();
    }

    public void setStroke(BasicStroke newStroke) {
        this.stroke = newStroke;
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    private BasicStroke calculateStroke() {
        float lineWidth = this.transformWidth((float)this.getGraphicsState().getLineWidth());
        if ((double)lineWidth < 0.25) {
            lineWidth = 0.25f;
        }
        BasicStroke currentStroke = null;
        if (this.stroke == null) {
            currentStroke = new BasicStroke(lineWidth);
        } else {
            float phaseStart = this.stroke.getDashPhase();
            float[] dashArray = this.stroke.getDashArray();
            if (dashArray != null) {
                int i;
                for (i = 0; i < dashArray.length; ++i) {
                    float w = this.transformWidth(dashArray[i]);
                    dashArray[i] = Math.max(w, 0.062f);
                }
                phaseStart = (int)this.transformWidth(phaseStart);
                if (dashArray.length == 0 || Float.isInfinite(phaseStart) || Float.isNaN(phaseStart)) {
                    dashArray = null;
                } else {
                    for (i = 0; i < dashArray.length; ++i) {
                        if (!Float.isInfinite(dashArray[i]) && !Float.isNaN(dashArray[i])) continue;
                        dashArray = null;
                        break;
                    }
                }
            }
            currentStroke = new BasicStroke(lineWidth, this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), dashArray, phaseStart);
        }
        return currentStroke;
    }

    public void strokePath() throws IOException {
        this.graphics.setComposite(this.getGraphicsState().getStrokeJavaComposite());
        Paint strokingPaint = this.getGraphicsState().getStrokingColor().getJavaColor();
        if (strokingPaint == null) {
            strokingPaint = this.getGraphicsState().getStrokingColor().getPaint(this.pageSize.height);
        }
        if (strokingPaint == null) {
            LOG.info("ColorSpace " + this.getGraphicsState().getStrokingColor().getColorSpace().getName() + " doesn't provide a stroking color, using white instead!");
            strokingPaint = Color.WHITE;
        }
        this.graphics.setPaint(strokingPaint);
        this.graphics.setStroke(this.calculateStroke());
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.graphics.setClip(this.getGraphicsState().getCurrentClippingPath());
        GeneralPath path = this.getLinePath();
        this.graphics.draw(path);
        path.reset();
    }

    @Deprecated
    public void colorChanged(boolean bStroking) throws IOException {
    }

    public Point2D.Double transformedPoint(double x, double y) {
        double[] position = new double[]{x, y};
        this.getGraphicsState().getCurrentTransformationMatrix().createAffineTransform().transform(position, 0, position, 0, 1);
        position[1] = this.fixY(position[1]);
        return new Point2D.Double(position[0], position[1]);
    }

    public void setClippingPath(int windingRule) {
        this.setClippingWindingRule(windingRule);
    }

    public void setClippingWindingRule(int windingRule) {
        this.clippingWindingRule = windingRule;
    }

    public void endPath() {
        if (this.clippingWindingRule > -1) {
            PDGraphicsState graphicsState = this.getGraphicsState();
            GeneralPath clippingPath = (GeneralPath)this.getLinePath().clone();
            clippingPath.setWindingRule(this.clippingWindingRule);
            if (graphicsState.getCurrentClippingPath() != null) {
                Area currentArea = new Area(this.getGraphicsState().getCurrentClippingPath());
                Area newArea = new Area(clippingPath);
                currentArea.intersect(newArea);
                graphicsState.setCurrentClippingPath(currentArea);
            } else {
                graphicsState.setCurrentClippingPath(clippingPath);
            }
            this.clippingWindingRule = -1;
        }
        this.getLinePath().reset();
    }

    public void drawImage(Image awtImage, AffineTransform at) {
        this.graphics.setComposite(this.getGraphicsState().getStrokeJavaComposite());
        this.graphics.setClip(this.getGraphicsState().getCurrentClippingPath());
        this.graphics.drawImage(awtImage, at, null);
    }

    public void SHFill(COSName ShadingName) throws IOException {
        this.shFill(ShadingName);
    }

    public void shFill(COSName shadingName) throws IOException {
        PDShadingResources shading = this.getResources().getShadings().get(shadingName.getName());
        LOG.debug("Shading = " + shading.toString());
        int shadingType = shading.getShadingType();
        Matrix ctm = this.getGraphicsState().getCurrentTransformationMatrix();
        Paint paint = null;
        switch (shadingType) {
            case 1: {
                paint = new Type1ShadingPaint((PDShadingType1)shading, ctm, this.pageSize.height);
                break;
            }
            case 2: {
                paint = new AxialShadingPaint((PDShadingType2)shading, ctm, this.pageSize.height);
                break;
            }
            case 3: {
                paint = new RadialShadingPaint((PDShadingType3)shading, ctm, this.pageSize.height);
                break;
            }
            case 4: {
                paint = new Type4ShadingPaint((PDShadingType4)shading, ctm, this.pageSize.height);
                break;
            }
            case 5: {
                paint = new Type5ShadingPaint((PDShadingType5)shading, ctm, this.pageSize.height);
                break;
            }
            case 6: {
                paint = new Type6ShadingPaint((PDShadingType6)shading, ctm, this.pageSize.height);
                break;
            }
            case 7: {
                paint = new Type7ShadingPaint((PDShadingType7)shading, ctm, this.pageSize.height);
                break;
            }
            default: {
                throw new IOException("Invalid ShadingType " + shadingType + " for Shading " + shadingName);
            }
        }
        this.graphics.setComposite(this.getGraphicsState().getNonStrokeJavaComposite());
        this.graphics.setPaint(paint);
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.graphics.setClip(null);
        this.graphics.fill(this.getGraphicsState().getCurrentClippingPath());
    }

    protected void SHFill_Function(PDShading Shading) throws IOException {
        throw new IOException("Not Implemented");
    }

    protected void SHFill_Axial(PDShading Shading) throws IOException {
        throw new IOException("Not Implemented");
    }

    protected void SHFill_Radial(PDShading Shading) throws IOException {
        throw new IOException("Not Implemented");
    }

    protected void SHFill_FreeGourad(PDShading Shading) throws IOException {
        throw new IOException("Not Implemented");
    }

    protected void SHFill_LatticeGourad(PDShading Shading) throws IOException {
        throw new IOException("Not Implemented");
    }

    protected void SHFill_CoonsPatch(PDShading Shading) throws IOException {
        throw new IOException("Not Implemented");
    }

    protected void SHFill_TensorPatch(PDShading Shading) throws IOException {
        throw new IOException("Not Implemented");
    }

    private float transformWidth(float width) {
        Matrix ctm = this.getGraphicsState().getCurrentTransformationMatrix();
        if (ctm == null) {
            return width;
        }
        float x = ctm.getValue(0, 0) + ctm.getValue(1, 0);
        float y = ctm.getValue(0, 1) + ctm.getValue(1, 1);
        return width * (float)Math.sqrt((double)(x * x + y * y) * 0.5);
    }
}

