/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.function;

import java.math.BigInteger;
import java.util.Objects;
import javax.measure.UnitConverter;
import tech.units.indriya.function.AbstractConverter;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.function.PowerOfIntConverter;
import tech.units.indriya.function.RationalNumber;
import tech.units.indriya.internal.function.Calculator;

public final class RationalConverter
extends AbstractConverter
implements MultiplyConverter {
    private static final long serialVersionUID = -9192231963353351648L;
    private final RationalNumber factor;

    RationalConverter(RationalNumber factor) {
        Objects.requireNonNull(factor);
        this.factor = factor;
    }

    RationalConverter(BigInteger dividend, BigInteger divisor) {
        this.factor = RationalNumber.of(dividend, divisor);
    }

    RationalConverter(long dividend, long divisor) {
        this.factor = RationalNumber.of(dividend, divisor);
    }

    static RationalConverter of(RationalNumber factor) {
        return new RationalConverter(factor);
    }

    static RationalConverter of(BigInteger dividend, BigInteger divisor) {
        return new RationalConverter(dividend, divisor);
    }

    static RationalConverter of(long dividend, long divisor) {
        return new RationalConverter(dividend, divisor);
    }

    public BigInteger getDividend() {
        return this.factor.getDividend();
    }

    public BigInteger getDivisor() {
        return this.factor.getDivisor();
    }

    @Override
    protected Number convertWhenNotIdentity(Number value) {
        return Calculator.of(this.factor).multiply(value).peek();
    }

    @Override
    public boolean isIdentity() {
        return this.factor.compareTo(RationalNumber.ONE) == 0;
    }

    @Override
    protected boolean canReduceWith(AbstractConverter that) {
        if (that instanceof RationalConverter) {
            return true;
        }
        return that instanceof PowerOfIntConverter;
    }

    @Override
    protected AbstractConverter reduce(AbstractConverter that) {
        if (that instanceof RationalConverter) {
            return this.composeSameType((RationalConverter)that);
        }
        if (that instanceof PowerOfIntConverter) {
            return this.composeSameType(((PowerOfIntConverter)that).toRationalConverter());
        }
        throw new IllegalStateException(String.format("%s.simpleCompose() not handled for converter %s", this, that));
    }

    @Override
    protected RationalConverter inverseWhenNotIdentity() {
        return RationalConverter.of(this.factor.reciprocal());
    }

    @Override
    protected final String transformationLiteral() {
        return String.format("x -> x * %s", this.factor);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RationalConverter) {
            RationalConverter that = (RationalConverter)obj;
            return Objects.equals(this.factor, that.factor);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.factor.hashCode();
    }

    @Override
    public Number getValue() {
        return this.factor;
    }

    @Override
    public double getAsDouble() {
        return this.factor.doubleValue();
    }

    @Override
    public int compareTo(UnitConverter o) {
        if (this == o) {
            return 0;
        }
        if (o instanceof RationalConverter) {
            RationalConverter that = (RationalConverter)o;
            return this.factor.compareTo(that.factor);
        }
        return this.getClass().getName().compareTo(o.getClass().getName());
    }

    private AbstractConverter composeSameType(RationalConverter that) {
        BigInteger newDividend = this.getDividend().multiply(that.getDividend());
        BigInteger newDivisor = this.getDivisor().multiply(that.getDivisor());
        BigInteger gcd = newDividend.gcd(newDivisor);
        newDividend = newDividend.divide(gcd);
        newDivisor = newDivisor.divide(gcd);
        return newDividend.equals(BigInteger.ONE) && newDivisor.equals(BigInteger.ONE) ? IDENTITY : new RationalConverter(newDividend, newDivisor);
    }
}

