/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.text.MessageFormat;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.measure.Latitude;

public class ProjectionException
extends TransformException {
    private static final long serialVersionUID = 3031350727691500915L;

    public ProjectionException() {
    }

    ProjectionException(String pattern, Object value) {
        super(MessageFormat.format(pattern, value));
    }

    ProjectionException(double latitude) {
        super(MessageFormat.format("Latitude {0} is too close to a pole.", new Latitude(Math.toDegrees(latitude))));
    }

    public ProjectionException(String message) {
        super(message);
    }

    public ProjectionException(Throwable cause) {
        super(cause.getLocalizedMessage(), cause);
    }

    public ProjectionException(String message, Throwable cause) {
        super(message, cause);
    }
}

