/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.datum;

import java.util.Collections;
import java.util.Map;
import org.geotools.api.referencing.datum.VerticalDatum;
import org.geotools.api.referencing.datum.VerticalDatumType;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.datum.AbstractDatum;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.util.Utilities;

public class DefaultVerticalDatum
extends AbstractDatum
implements VerticalDatum {
    private static final long serialVersionUID = 380347456670516572L;
    private static final VerticalDatumType[] TYPES = VerticalDatumType.values();
    private static final short[] LEGACY_CODES = new short[TYPES.length];
    private final VerticalDatumType type;
    public static final DefaultVerticalDatum GEOIDAL;
    public static final DefaultVerticalDatum ELLIPSOIDAL;

    public DefaultVerticalDatum(String name, VerticalDatumType type) {
        this(Collections.singletonMap("name", name), type);
    }

    public DefaultVerticalDatum(VerticalDatum datum) {
        super(datum);
        this.type = datum.getVerticalDatumType();
    }

    public DefaultVerticalDatum(Map<String, ?> properties, VerticalDatumType type) {
        super(properties);
        this.type = type;
        DefaultVerticalDatum.ensureNonNull("type", type);
    }

    @Override
    public VerticalDatumType getVerticalDatumType() {
        return this.type;
    }

    @Override
    final int getLegacyDatumType() {
        int ordinal = this.type.ordinal();
        if (ordinal >= 0 && ordinal < LEGACY_CODES.length) {
            assert (this.type.equals(TYPES[ordinal])) : this.type;
            return LEGACY_CODES[ordinal];
        }
        return 0;
    }

    public static VerticalDatumType getVerticalDatumTypeFromLegacyCode(int code) {
        for (int i = 0; i < LEGACY_CODES.length; ++i) {
            if (LEGACY_CODES[i] != code) continue;
            return TYPES[i];
        }
        return null;
    }

    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            DefaultVerticalDatum that = (DefaultVerticalDatum)object;
            return Utilities.equals(this.type, that.type);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.type.hashCode();
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        super.formatWKT(formatter);
        return "VERT_DATUM";
    }

    static {
        DefaultVerticalDatum.LEGACY_CODES[VerticalDatumType.GEOIDAL.ordinal()] = 2005;
        DefaultVerticalDatum.LEGACY_CODES[VerticalDatumType.ELLIPSOIDAL.ordinal()] = 2002;
        DefaultVerticalDatum.LEGACY_CODES[VerticalDatumType.DEPTH.ordinal()] = 2006;
        DefaultVerticalDatum.LEGACY_CODES[VerticalDatumType.BAROMETRIC.ordinal()] = 2003;
        DefaultVerticalDatum.LEGACY_CODES[VerticalDatumType.ORTHOMETRIC.ordinal()] = 2001;
        DefaultVerticalDatum.LEGACY_CODES[VerticalDatumType.OTHER_SURFACE.ordinal()] = 2000;
        GEOIDAL = new DefaultVerticalDatum(DefaultVerticalDatum.name(88), VerticalDatumType.GEOIDAL);
        ELLIPSOIDAL = new DefaultVerticalDatum(DefaultVerticalDatum.name(57), VerticalDatumType.ELLIPSOIDAL);
    }
}

