/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.Iterator;
import org.geotools.api.filter.expression.Add;
import org.geotools.api.filter.expression.Divide;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.Multiply;
import org.geotools.api.filter.expression.NilExpression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.expression.Subtract;

public class IsStaticExpressionVisitor
implements ExpressionVisitor {
    public static final IsStaticExpressionVisitor VISITOR = new IsStaticExpressionVisitor();

    protected IsStaticExpressionVisitor() {
    }

    @Override
    public Boolean visit(NilExpression expression, Object data) {
        return true;
    }

    @Override
    public Boolean visit(Add expression, Object data) {
        boolean isStatic = (Boolean)expression.getExpression1().accept(this, data);
        if (!isStatic) {
            return false;
        }
        isStatic = (Boolean)expression.getExpression2().accept(this, data);
        return isStatic;
    }

    @Override
    public Boolean visit(Divide expression, Object data) {
        boolean isStatic = (Boolean)expression.getExpression1().accept(this, data);
        if (!isStatic) {
            return false;
        }
        isStatic = (Boolean)expression.getExpression2().accept(this, data);
        return isStatic;
    }

    @Override
    public Boolean visit(Function expression, Object data) {
        boolean isStatic;
        block1: {
            Expression parameter;
            isStatic = true;
            if (expression.getParameters() == null) break block1;
            Iterator<Expression> iterator = expression.getParameters().iterator();
            while (iterator.hasNext() && (isStatic = ((Boolean)(parameter = iterator.next()).accept(this, data)).booleanValue())) {
            }
        }
        return isStatic;
    }

    @Override
    public Boolean visit(Literal expression, Object data) {
        return true;
    }

    @Override
    public Boolean visit(Multiply expression, Object data) {
        boolean isStatic = (Boolean)expression.getExpression1().accept(this, data);
        if (!isStatic) {
            return false;
        }
        isStatic = (Boolean)expression.getExpression2().accept(this, data);
        return isStatic;
    }

    @Override
    public Boolean visit(PropertyName expression, Object data) {
        return false;
    }

    @Override
    public Boolean visit(Subtract expression, Object data) {
        boolean isStatic = (Boolean)expression.getExpression1().accept(this, data);
        if (!isStatic) {
            return false;
        }
        isStatic = (Boolean)expression.getExpression2().accept(this, data);
        return isStatic;
    }
}

