/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.function.FilterFunction_in10;
import org.geotools.filter.function.FilterFunction_in2;
import org.geotools.filter.function.FilterFunction_in3;
import org.geotools.filter.function.FilterFunction_in4;
import org.geotools.filter.function.FilterFunction_in5;
import org.geotools.filter.function.FilterFunction_in6;
import org.geotools.filter.function.FilterFunction_in7;
import org.geotools.filter.function.FilterFunction_in8;
import org.geotools.filter.function.FilterFunction_in9;
import org.geotools.filter.function.StaticGeometry;
import org.geotools.util.Converters;

public class InFunction
extends FunctionExpressionImpl {
    static final Boolean FAST_IN_FUNCTION = Boolean.valueOf(System.getProperty("geotools.function.fastInFunction", "true"));
    private boolean staticSet = true;
    private Set<?> lookup;
    private Class<?> lastContext;
    public static FunctionName NAME = InFunction.functionName("in", "result:Boolean", "candidate:Object:1,1", "v:Object:1,");

    public static boolean isInFunction(Expression expression) {
        return expression instanceof InFunction || expression instanceof FilterFunction_in2 || expression instanceof FilterFunction_in3 || expression instanceof FilterFunction_in4 || expression instanceof FilterFunction_in5 || expression instanceof FilterFunction_in6 || expression instanceof FilterFunction_in7 || expression instanceof FilterFunction_in8 || expression instanceof FilterFunction_in9 || expression instanceof FilterFunction_in10;
    }

    public static FilterCapabilities getInCapabilities() {
        FilterCapabilities caps = new FilterCapabilities();
        caps.addType(InFunction.class);
        caps.addType(FilterFunction_in2.class);
        caps.addType(FilterFunction_in3.class);
        caps.addType(FilterFunction_in4.class);
        caps.addType(FilterFunction_in5.class);
        caps.addType(FilterFunction_in6.class);
        caps.addType(FilterFunction_in7.class);
        caps.addType(FilterFunction_in8.class);
        caps.addType(FilterFunction_in9.class);
        caps.addType(FilterFunction_in10.class);
        return caps;
    }

    public InFunction() {
        super(NAME);
    }

    @Override
    public String getName() {
        return NAME.getName();
    }

    public int getArgCount() {
        return NAME.getArgumentCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParameters(List<Expression> parameters) {
        super.setParameters(parameters);
        if (!FAST_IN_FUNCTION.booleanValue()) {
            return;
        }
        InFunction inFunction = this;
        synchronized (inFunction) {
            this.staticSet = true;
            FilterAttributeExtractor extractor = new FilterAttributeExtractor();
            for (int i = 1; i < parameters.size(); ++i) {
                Expression expression = parameters.get(i);
                if (expression == null) continue;
                extractor.clear();
                expression.accept(extractor, null);
                if (extractor.isConstantExpression()) continue;
                this.staticSet = false;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(Object feature) {
        Object candidate = this.getExpression(0).evaluate(feature);
        Class<?> context = this.getContextFromCandidate(candidate);
        if (FAST_IN_FUNCTION.booleanValue()) {
            Object converted;
            if (this.staticSet && context != null && (this.lookup == null || !this.lastContext.equals(context))) {
                InFunction inFunction = this;
                synchronized (inFunction) {
                    if (this.lookup == null) {
                        this.lastContext = context;
                        this.lookup = this.buildLookup(context);
                    }
                }
            }
            if (context != null && this.lookup != null && (converted = Converters.convert(candidate, context)) != null) {
                return this.lookup.contains(converted);
            }
        }
        boolean result = false;
        List<Expression> valuesToTest = this.getParameters().subList(1, this.getParameters().size());
        for (Expression expression : valuesToTest) {
            Object value = expression.evaluate(feature);
            if (candidate == null) {
                result = StaticGeometry.isNull(value);
            } else {
                boolean bl = result = result || StaticGeometry.equalTo(candidate, value);
            }
            if (!result) continue;
            break;
        }
        return result;
    }

    private Class<?> getContextFromCandidate(Object candidate) {
        if (candidate == null) {
            return Object.class;
        }
        Class<?> target = candidate.getClass();
        if (Number.class.isAssignableFrom(target)) {
            return Double.class;
        }
        if (Boolean.class.isAssignableFrom(target)) {
            return Boolean.class;
        }
        if (Date.class.isAssignableFrom(target)) {
            return Date.class;
        }
        if (String.class.isAssignableFrom(target)) {
            return String.class;
        }
        return null;
    }

    private <T> Set<?> buildLookup(Class<T> context) {
        return this.params.subList(1, this.params.size()).stream().map(e -> e.evaluate(null, context)).collect(Collectors.toSet());
    }
}

