/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.compression;

import it.geosolutions.imageio.compression.CompressionRegistry;
import it.geosolutions.imageio.compression.CompressionType;
import it.geosolutions.imageio.compression.Compressor;
import it.geosolutions.imageio.compression.CompressorSpi;
import it.geosolutions.imageio.compression.Decompressor;
import it.geosolutions.imageio.compression.DecompressorSpi;
import java.util.Iterator;

public class CompressionFinder {
    private static volatile CompressionRegistry compressionRegistry = CompressionRegistry.getDefaultInstance();

    public static void scanForPlugins() {
        compressionRegistry.registerApplicationClasspathSpis();
    }

    public static Compressor getCompressor(int level, CompressionType compressionType) {
        Iterator<CompressorSpi> iterator;
        try {
            iterator = compressionRegistry.getSPIs(CompressorSpi.class, true);
        }
        catch (IllegalArgumentException var6) {
            return null;
        }
        CompressorSpi selectedSPI = null;
        Iterator<CompressorSpi> it = iterator;
        while (it.hasNext()) {
            CompressorSpi spi = it.next();
            if (level > spi.getMaxLevel() || level < spi.getMinLevel()) continue;
            selectedSPI = spi;
            break;
        }
        if (selectedSPI != null) {
            return selectedSPI.createCompressor(level, compressionType);
        }
        return null;
    }

    public static Decompressor getDecompressor(CompressionType compressionType) {
        Iterator<DecompressorSpi> iterator;
        try {
            iterator = compressionRegistry.getSPIs(DecompressorSpi.class, true);
        }
        catch (IllegalArgumentException var6) {
            return null;
        }
        if (iterator.hasNext()) {
            DecompressorSpi spi = iterator.next();
            return spi.createDecompressor(compressionType);
        }
        return null;
    }
}

